import { DBusSubsystem } from './DBusSubsystem.js';
import { LogSubsystem } from './LogSubsystem.js';
import { ServiceSubsystem } from './ServiceSubsystem.js';

/**
 * Monitor configuration data.
 */
type MonitorConfiguration = {
    name: string;
    status: string;
    type: MonitorConfiguration.type;
} & (LogSubsystem | ServiceSubsystem | DBusSubsystem);
declare namespace MonitorConfiguration {
    enum type {
        LOG = "log",
        SERVICE = "service",
        DBUS = "dbus"
    }
}

export { MonitorConfiguration };
