\set ON_ERROR_STOP true
-- DEFAULT APPLICATIONS FOR MP

INSERT INTO "app" ("displayindex", "filepath", "hascontroller", "icon", "meta", "showappslist", "state", "url", "id", "rbac_id") VALUES
(9999,  'application/modules/docs/',  1,  'default.png',  '{"name":"Documentation","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Read CFEngine manuals","icon":"icon.png","show_apps_list":"1","has_controller":"1","disabled":"1","labs":"0","release":{"version":"1","build":"1","date":"20130310"},"supported":{"minversion":"3.0","maxversion":"3.2"},"manual":"http:\/\/cfengine.com\/manuals"}',  1,  '0',  'docs', 'docs', NULL),
(2, 'application/modules/engineering/', 1,  'default.png',  '{"name":"Hosts","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Information about hosts, monitoring etc","icon":"icon.png","show_apps_list":"1","has_controller":"1","labs":"0","release":{"version":"1","build":"1","date":"20130310"},"supported":{"minversion":"3.0","maxversion":"3.2"},"manual":"http:\/\/cfengine.com\/manuals"}', 1,  1,  'hosts',  'engineering', NULL),
(3, 'application/modules/groups_app/', 1,  'default.png',  '{"name":"Groups","description":"Application for host groups configuration.","show_apps_list":"1","rbac_id":"host-groups-shared.get","has_controller":"1","url":"groups","release":{"version":"1","build":"1","date":"20230320"},"supported":{"minversion":"3.21"}}', 1,  1,  'groups',  'groups_app', 'host-groups-shared.get'),
(1, 'application/modules/dashboard/', 1,  'default.png',  '{"name":"Dashboard","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Dashboard home screen","icon":"icon.png","show_apps_list":"1","has_controller":"1","labs":"0","release":{"version":"1","build":"1","date":"20130820"},"supported":{"minversion":"3.5.x","maxversion":"3.6"},"manual":"http:\/\/cfengine.com\/manuals"}', 1,  1,  'dashboard',  'dashboard', NULL),
(9999,  'application/modules/sqlhooks/',  '0',  'default.png',  '{"name":"SQL hooks","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Hooks for advanced reports. Convert ''host'' field from text to link","icon":"icon.png","show_apps_list":"0","disabled":"1","has_controller":"0","labs":"1","release":{"version":"1","build":"1","date":"20130310"},"supported":{"minversion":"3.0","maxversion":"3.2"},"manual":"http:\/\/cfengine.com","author":{"name":"Dmitry Shevchenko","email":"dmitry.shevchenko@cfengine.com","website":"http:\/\/cfengine.com"}}',  '0',  1,  'sqlhooks', 'sqlhooks', NULL),
(4, 'application/modules/advancedreports/', 1,  'default.png',  '{"name":"Reports","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"SQL based reports","icon":"icon.png","show_apps_list":"1","has_controller":"1","labs":"0","release":{"version":"1","build":"1","date":"20130310"},"supported":{"minversion":"3.0","maxversion":"3.2"},"manual":"http:\/\/cfengine.com\/manuals\/Enterprise-3-0-OwnersManual#SQL-Reports-App"}',  1,  1,  'advancedreports',  'advancedreports', NULL),
(5, 'application/modules/monitoring/',  1,  'default.png',  '{"name":"Measurements","copyright":"2017 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Measurements diagrams for hosts","icon":"icon.png","show_apps_list":"1","has_controller":"1","labs":"1","release":{"version":"1","build":"1","date":"20130310"},"supported":{"minversion":"3.0","maxversion":"3.2"},"manual":"http:\/\/cfengine.com","author":{"name":"Nishes Joshi","email":"nishes.joshi@cfengine.com","website":"http:\/\/cfengine.com"}}',  1,  1,  'measurements', 'monitoring', NULL),
(6,	'/var/cfengine/httpd/htdocs/application/modules/policy/',	1,	'default.png',	'{"name":"Policy analyzer","copyright":"2018 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Collection of policy tools. Beta version.","icon":"icon.png","show_apps_list":"1","has_controller":"1","url":"policy\/analyzer","labs":"0","release":{"version":"1","build":"1","date":"20180704"},"supported":{"minversion":"3.12","maxversion":"3.*"},"manual":"http:\/\/cfengine.com"}',	1,	1,	'policy-analyzer',	'policy', 'analyzer.index'),
(7,	'/var/cfengine/httpd/htdocs/application/modules/hub_management/',	1,	'default.png',	'{"name":"Hub management","copyright":"2019 Northern.tech AS","license":"http:\/\/cfengine.com\/enterprise\/eula","description":"Hub management for federated reporting","icon":"icon.png","show_apps_list":"1","only_for_admin":"1","has_controller":"1","disabled":"0","url":"hub_management","labs":"0","release":{"version":"1","build":"1","date":"20190409"},"supported":{"minversion":"3.14"},"manual":"http:\/\/cfengine.com"}',	1,	0,	'hub_management',	'hub_management',	NULL),
(8,	'/var/cfengine/httpd/htdocs/application/modules/build_app/',	1,	'default.png',	'{"name":"Build","description":"Application for modules configuration.","show_apps_list":"1","rbac_id":"build.projects.get","has_controller":"1","url":"build","release":{"version":"1","build":"1","date":"20220411"},"supported":{"minversion":"3.20","maxversion":"3.*"}}',	1,	1,	'build',	'build_app',	'build.projects.get')
ON CONFLICT DO NOTHING;

UPDATE app SET url = 'reports' WHERE id = 'advancedreports';
UPDATE app SET url = 'hosts' WHERE id = 'engineering';
UPDATE app SET url = 'measurements' WHERE id = 'monitoring';
UPDATE app SET url = 'policy-analyzer' WHERE id = 'policy';
UPDATE app SET url = 'hub-management' WHERE id = 'hub_management';

-- Disable design center 3.12.0
DELETE FROM "app" WHERE id = 'designcenter';

-- OOTB inventory variables 3.6.0
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Architecture', 'Hardware', '1', 'string', NULL),
('attribute_name=BIOS vendor', 'Hardware', '1', 'string', NULL),
('attribute_name=BIOS version', 'Hardware', '1', 'string', NULL),
('attribute_name=CPU logical cores', 'Hardware', '1', 'int', NULL),
('attribute_name=CPU model', 'Hardware', '1', 'string', NULL),
('attribute_name=Memory size (MB)', 'Hardware', '1', 'real', NULL),
('attribute_name=System serial number', 'Hardware', '1', 'string', NULL),
('attribute_name=System manufacturer', 'Hardware', '1', 'string', NULL),
('attribute_name=System version', 'Hardware', '1', 'string', NULL),

('attribute_name=Disk free (%)', 'Software', '1', 'real', NULL),
('attribute_name=OS type', 'Software', '1', 'string', NULL),
('attribute_name=OS', 'Software', '1', 'string', NULL),
('attribute_name=Kernel Release', 'Software', '1', 'string', NULL),
('attribute_name=CFEngine ID', 'Software', '1', 'string', NULL),
('attribute_name=CFEngine roles', 'Software', '1', 'string', NULL),
('attribute_name=CFEngine version', 'Software', '1', 'string', NULL),
('attribute_name=Uptime minutes', 'Software', '1', 'int', NULL),

('attribute_name=Interfaces', 'Network', '1', 'slist', 'cf_clearSlist'),
('attribute_name=IPv4 addresses', 'Network', '1', 'slist', 'cf_clearSlist'),
('attribute_name=MAC addresses', 'Network', '1', 'slist', 'cf_clearSlist'),
('attribute_name=Ports listening', 'Network', '1', 'slist', 'cf_clearSlist')
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.6.2
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Solaris zone', 'Software', '1', 'string', NULL),
('attribute_name=Windows roles', 'Software', '1', 'string', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.7.0
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=CPU physical cores', 'Hardware', '1', 'int', NULL),
('attribute_name=CPU sockets', 'Hardware', '1', 'int', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.7.4
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=System product name', 'Hardware', '1', 'string', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.10.1
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Virtual host', 'Hardware', '1', 'string', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.11.0
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Highest Service Pack', 'Software', '1', 'string', NULL),
('attribute_name=Highest Technology Level', 'Software', '1', 'string', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.13.0, 3.12.1, 3.10.5
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Physical memory (MB)', 'Hardware', '1', 'int', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.17.0
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
('attribute_name=Primary Policy Server', 'Software', '1', 'string', NULL),
('attribute_name=Policy Servers', 'Software', '1', 'slist', NULL)
ON CONFLICT DO NOTHING;

-- OOTB inventory variables 3.22.0, 3.21.1, 3.18.4
INSERT INTO "variables_dictionary" ("attribute_name", "category", "readonly", "type", "convert_function") VALUES
  -- ENT-9806
('attribute_name=CFEngine policy version', 'Software', '1', 'string', NULL)
ON CONFLICT DO NOTHING;

DO $$
BEGIN

IF NOT EXISTS (SELECT 1
FROM information_schema.columns
WHERE  table_name='users' AND column_name='dashboard')
THEN
       -- 3.7.0 introduce user selected dashboard
ALTER TABLE IF EXISTS users
  ADD COLUMN dashboard integer DEFAULT NULL;
END IF;
END$$;

CREATE OR REPLACE FUNCTION create_widget(name TEXT, type TEXT, payload TEXT DEFAULT '{}') RETURNS void AS
$BODY$
DECLARE
	WidgetId    integer;
	Widgets     text;
	DashboardId integer;
BEGIN
	SELECT dashboard_dashboards.id, dashboard_dashboards.widgets INTO DashboardId, Widgets
	FROM dashboard_dashboards
	WHERE dashboard_dashboards.name = 'Default dashboard';
	EXECUTE 'INSERT INTO "dashboard_widgets" ("name", "type", "username", "payload", "dashboardid") ' ||
					'SELECT ''' || name || ''', ''' || type || ''', NULL , ''' || payload || ''', ''' || DashboardId || ''' ' ||
					'WHERE
             NOT EXISTS (
                SELECT id
                FROM dashboard_widgets
                WHERE name = ''' || name || ''' AND username IS NULL)' ||
					'RETURNING id' INTO WidgetId;
	IF WidgetId > 0 AND Widgets = '' THEN
		EXECUTE 'UPDATE "dashboard_dashboards" SET widgets = ' || WidgetId || ' WHERE name = ''Default dashboard''';
	ELSEIF WidgetId > 0 AND Widgets != '' THEN
		EXECUTE 'UPDATE "dashboard_dashboards"  SET widgets = CONCAT(widgets, '','', ' || WidgetId || ') ' ||
						'WHERE name = ''Default dashboard''';
	END IF;
	RETURN;
END;
$BODY$ LANGUAGE plpgsql STRICT;

-- Dashboard sharing, 3.7.0
INSERT INTO "dashboard_dashboards" ("name", "username", "public", "widgets")
	SELECT 'Default dashboard', NULL, '1', ''
WHERE
	NOT EXISTS (
		SELECT id
		FROM dashboard_dashboards
		WHERE name = 'Default dashboard' AND username is NULL
	);

-- ENT-9664 - reorder ootb widgets in default dashboard
SELECT create_widget('OS',  'inventory', '{"inventoryAttribute":"OS","chartType":"pie"}');
SELECT create_widget('Software updates', 'alerts', '{"singleAlert": "true"}');
SELECT create_widget('System health', 'alerts', '{"singleAlert": "true"}');
SELECT create_widget('Newly bootstrapped hosts',  'hostCount');
SELECT create_widget('Decommissioned hosts',  'decommissionedHosts');
SELECT create_widget('Policy compliance', 'alerts');
SELECT create_widget('Changes', 'changes');
SELECT create_widget('File changes',  'fileChanges');
SELECT create_widget('Not kept, not repaired count',  'notKeptNeverRepaired');

 -- 3.7.0 introduces (username, name, widgetid) unique contraint for dashboard_alerts due to new sharing functionality
ALTER TABLE IF EXISTS dashboard_alerts
  DROP CONSTRAINT dashboard_alerts_uniq,
  ADD CONSTRAINT dashboard_alerts_uniq UNIQUE (username, name, widgetid);

INSERT INTO "dashboard_rules"
(
	"name",
	"description",
	"type",
	"username",
	"policyconditions",
	"inventoryconditions",
	"softwareupdateconditions"
)
VALUES
(
	'Software updates available',
	'Available software updates to any package.',
	'softwareupdate',
	NULL,
	NULL,
	NULL,
	NULL
),
(
	'Entire CFEngine policy',
	'Promises not kept in the entire policy.',
	'policy',
	NULL,
	'{"promiseoutcome":"NOTKEPT"}',
	NULL,
	NULL
),
(
'Policy Deployment',
'Automatic policy deployment from upstream repository.',
'policy',
NULL,
'{"promisehandle":"masterfiles_update_stage","promiseoutcome":"NOTKEPT"}',
NULL,
NULL)
ON CONFLICT DO NOTHING;

-- ENT-6444 Added rules needed for default compliance report
INSERT INTO "dashboard_rules" ("name", "description", "type", "username", "policyconditions", "inventoryconditions", "softwareupdateconditions", "category", "severity", "hostcontexts", "conditionmustbemet", "customconditions", "filechangedconditions") VALUES
('Supported CentOS', 'Host is running CentOS 7', 'inventory', NULL, '{}', '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","condition":"regex_matches","value":"CentOS (7)"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'')  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , .inventoryValue"}', '{}', 'Operating System', 'low', '{"name":"CentOS","includes":["centos"],"isHosts":false}', '1', '{}', '{}'),
('Supported Ubuntu', 'Ubuntu hosts are running Ubuntu 18 or 20', 'inventory', NULL, NULL, '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"Ubuntu (18|20)","condition":"regex_matches"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'')  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , .inventoryValue"}', NULL, 'Operating System', 'low', '{"name":" Ubuntu","includes":["ubuntu"],"isHosts":false}', '1', '{}', '{}'),
('Supported RHEL', 'Red Hat hosts are running RHEL 8 or 9', 'inventory', NULL, NULL, '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"RHEL (8|9)","condition":"regex_matches"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'')  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , .inventoryValue"}', NULL, 'Operating System', 'low', '{"name":" Red Hat","includes":["redhat_pure"],"isHosts":false}', '1', '{}', '{}'),
('OS is reported', 'All hosts must report their own OS', 'inventory', NULL, NULL, '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"","condition":"is_reported"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'')  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , .inventoryValue"}', NULL, 'Operating System', 'high', '{"name":"All hosts","includes":[],"isHosts":false}', '1', '{}', '{}'),
('Packages should be updated', 'Fails if there are updates available', 'softwareupdate', NULL, '{}', '{}', '{"condition":"is"}', 'Security', 'low', NULL, '0', '{}', '{}'),
('Supported Debian', 'Debian hosts are running Debian 10 or 11', 'inventory', NULL, NULL, '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"Debian (10|11)","condition":"regex_matches"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'')  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , .inventoryValue"}', NULL, 'Operating System', 'low', '{"name":" Debian","includes":["debian_pure"],"isHosts":false}', '1', '{}', '{}'),
('Available disk space', 'All hosts must have above 25% available disk space', 'inventory', NULL, '{}', '{"columns":[{"attribute_name":"attribute_name=Disk free (%)","label":"Disk free (%)","type":"int","keyname":"default.cfe_autorun_inventory_disk.free","category":"User defined","readonly":0,"source_table":"inventory","id":"attribute_name=Disk free (%)"}],"filters":[{"attribute_name":"attribute_name=Disk free (%)","label":"Disk free (%)","type":"int","keyname":"default.cfe_autorun_inventory_disk.free","category":"User defined","readonly":0,"source_table":"inventory","id":"attribute_name=Disk free (%)","condition":">","value":25}],"SQLSTRING":"SELECT undefined AS \"Disk free (%)\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Disk free (%)'') table_default_cfe_autorun_inventory_disk_free ON  table_default_cfe_autorun_inventory_disk_free.hostkey = hosts.hostkey WHERE undefined>25 GROUP BY Hosts.hostkey , table_default_cfe_autorun_inventory_disk_free.inventoryValue"}', '{}', 'Other', 'medium', NULL, '1', '{}', '{}'),
('More than 0 CPU cores', NULL, 'inventory', NULL, NULL, '{"columns":[{"id":"attribute_name=attribute_name=CPU physical cores","attribute_name":"attribute_name=CPU physical cores","category":"Hardware","readonly":1,"type":"int","convert_function":null,"keyname":null,"enabled":1,"label":"CPU physical cores","id_key":24,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=CPU physical cores","attribute_name":"attribute_name=CPU physical cores","category":"Hardware","readonly":1,"type":"int","convert_function":null,"keyname":null,"enabled":1,"label":"CPU physical cores","id_key":24,"source_table":"inventory","value":0,"condition":">"}],"SQLSTRING":"SELECT undefined AS \"CPU physical cores\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=CPU physical cores'')  ON  .hostkey = hosts.hostkey WHERE undefined>0 GROUP BY Hosts.hostkey , .inventoryValue"}', NULL, 'Hardware', 'low', '{"name":"All hosts","includes":[],"isHosts":false}', '1', '{}', '{}')
ON CONFLICT DO NOTHING;

-- ENT-10939: Updated conditions used in example compliance report for vendor supported operating systems
-- Ubuntu https://wiki.ubuntu.com/Releases (20 End of Standard Support April 2025)
UPDATE
  dashboard_rules
   SET
     description = 'Ubuntu hosts are running Ubuntu 20 or 22',
     inventoryconditions = '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"Ubuntu (20|22)","condition":"regex_matches"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(attribute_name=OS)  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , inventoryValue"}'
 WHERE
   name = 'Supported Ubuntu';

-- Debian https://wiki.debian.org/LTS (10 EoL June 2024)
UPDATE
  dashboard_rules
   SET
     description = 'Debian hosts are running Debian 10, 11 or 12',
     inventoryconditions = '{"columns":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory"}],"filters":[{"id":"attribute_name=attribute_name=OS","attribute_name":"attribute_name=OS","category":"Software","readonly":1,"type":"string","convert_function":null,"keyname":null,"enabled":1,"label":"OS","id_key":12,"source_table":"inventory","value":"Debian (10|11|12)","condition":"regex_matches"}],"SQLSTRING":"SELECT .inventoryValue  AS \"OS\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(attribute_name=OS)  ON  .hostkey = hosts.hostkey WHERE  GROUP BY Hosts.hostkey , inventoryValue"}'
 WHERE
   name = 'Supported Debian';

INSERT INTO "dashboard_alerts"
(
	"ruleid",
	"failhosts",
	"hostcontextsprofileid",
	"lastcheck",
	"lasteventtime",
	"laststatuschange",
	"servertime",
	"pause",
	"paused",
	"name",
	"severity",
	"site_url",
	"status",
	"totalhosts",
	"username",
	"widgetname",
	"emailtonotify",
	"reminder",
	"widgetid",
	"hostcontexts",
	"hostcontextspath"
)
VALUES
(
	( SELECT id FROM dashboard_rules WHERE name = 'Software updates available' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	'0',
	'',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'0',
	'Software updates available',
	'low',
	'',
	NULL,
	NULL,
	'CFE_ROBOT',
	'Software updates',
	NULL,
	NULL,
	( SELECT id FROM dashboard_widgets WHERE name = 'Software updates' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	NULL,
	NULL
),
(
	( SELECT id FROM dashboard_rules WHERE name = 'Entire CFEngine policy' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	'0',
	'',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'0',
	'Entire CFEngine policy',
	'medium',
	'',
	NULL,
	NULL,
	'CFE_ROBOT',
	'Policy compliance',
	NULL,
	NULL,
	( SELECT id FROM dashboard_widgets WHERE name = 'Policy compliance' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	NULL,
	NULL
),
(
  ( SELECT id FROM dashboard_rules WHERE name = 'Policy Deployment' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
  '0',
  '',
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  '0',
  'Policy Deployment',
  'high',
  '',
  NULL,
  NULL,
  'CFE_ROBOT',
  'Policy compliance',
  NULL,
  NULL,
  ( SELECT id FROM dashboard_widgets WHERE name = 'Policy compliance' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
  '{"includes": ["policy_server"], "name": "Policy Servers"}',
  NULL)
  ON CONFLICT DO NOTHING;


DO $$
BEGIN

IF NOT EXISTS (SELECT 1
FROM information_schema.columns
WHERE  table_name='dashboard_widgets' AND column_name='dashboardid')
THEN
-- 3.7.0 introduced dashboardid column to dashboard_widgets for dashboard sharing
ALTER TABLE IF EXISTS dashboard_widgets
  ADD COLUMN dashboardid integer,
  ADD CONSTRAINT dashboard_widgets_dashboardid_fkey FOREIGN KEY (dashboardid)
      REFERENCES dashboard_dashboards (id)  ON DELETE CASCADE;
END IF;
END$$;

-- OOTB Widgets, rules and alerts 3.6.2

INSERT INTO "dashboard_rules"
(
	"name",
	"description",
	"type",
	"username",
	"policyconditions",
	"inventoryconditions",
	"softwareupdateconditions"
)
VALUES
(
	'Low disk space',
	'Low disk space',
	'inventory',
	NULL,
	NULL,
	'{"columns":[{"keyname":"hostname","attribute_name":"Host name","label":"Host name","type":"string","category":"Network","readonly":"1","source_table":"hosts","id":"Host name"},{"attribute_name":"attribute_name=Disk free (%)","label":"Disk free (%)","type":"int","keyname":"default.cfe_autorun_inventory_disk.free","category":"User defined","readonly":0,"source_table":"inventory","id":"attribute_name=Disk free (%)"}],"filters":[{"attribute_name":"attribute_name=Disk free (%)","label":"Disk free (%)","type":"int","keyname":"default.cfe_autorun_inventory_disk.free","category":"User defined","readonly":0,"source_table":"inventory","id":"attribute_name=Disk free (%)","condition":"<","value":15}],"SQLSTRING":"SELECT DISTINCT Hosts.HostKey,  hostname AS \"Host name\", cf_convertToNum(table_default_cfe_autorun_inventory_disk_free.inventoryValue ) AS \"Disk free (%)\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Disk free (%)'') table_default_cfe_autorun_inventory_disk_free ON  table_default_cfe_autorun_inventory_disk_free.hostkey = hosts.hostkey WHERE cf_convertToNum(table_default_cfe_autorun_inventory_disk_free.inventoryValue )<15 GROUP BY Hosts.hostkey , table_default_cfe_autorun_inventory_disk_free.inventoryValue, hosts.hostname"}',
	NULL
)
ON CONFLICT DO NOTHING;

INSERT INTO "dashboard_alerts"
(
	"ruleid",
	"failhosts",
	"hostcontextsprofileid",
	"lastcheck",
	"lasteventtime",
	"laststatuschange",
	"servertime",
	"pause",
	"paused",
	"name",
	"severity",
	"site_url",
	"status",
	"totalhosts",
	"username",
	"widgetname",
	"emailtonotify",
	"reminder",
	"widgetid",
	"hostcontexts",
	"hostcontextspath"
)
VALUES
(
	( SELECT id FROM dashboard_rules WHERE name = 'Low disk space' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	'0',
	'',
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	'0',
	'Low disk space',
	'high',
	'',
	NULL,
	NULL,
	'CFE_ROBOT',
	'System health',
	NULL,
	NULL,
	( SELECT id FROM dashboard_widgets WHERE name = 'System health' AND username IS NULL ORDER BY id ASC LIMIT 1 ),
	NULL,
	NULL
) ON CONFLICT DO NOTHING;


-- OOTB Host Count widget 3.12.0
UPDATE dashboard_widgets SET name = 'Newly bootstrapped hosts' WHERE name = 'Host count';

-- OOTB reports 3.6.0
INSERT INTO "report" ("username", "url", "reporttype", "reportcategory", "type", "readonly", "is_public", "can_subscribe", "is_subscribed", "label", "date", "params", "sharedpermission", "sharedby", "advancedreportsdata", "meta_data") VALUES
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promise outcome of last run',	'2014-04-08 12:34:01',	'SELECT Hosts.HostName AS "Host name", PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", PromiseExecutions.PromiseOutcome AS "Promise outcome", PromiseExecutions.LogMessages AS "Log messages", PromiseExecutions.ChangeTimeStamp AS "Change time" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE  PromiseExecutions.PromiseHandle NOT ILIKE ''cfe_internal%'' OR PromiseExecutions.PromiseHandle IS NULL',	'{}',	'{}',	'{"SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", PromiseExecutions.PromiseOutcome AS \\\"Promise outcome\\\", PromiseExecutions.LogMessages AS \\\"Log messages\\\", PromiseExecutions.ChangeTimeStamp AS \\\"Change time\\\" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE PromiseExecutions.PromiseHandle NOT ILIKE ''cfe_internal%'' OR PromiseExecutions.PromiseHandle IS NULL\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promise outcome of last run, aggregated by promise and outcome',	'2014-04-08 12:35:26',	'SELECT PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", PromiseExecutions.PromiseOutcome AS "Promise outcome", COUNT(PromiseExecutions.PromiseHash) AS "Occurrences" FROM PromiseExecutions WHERE PromiseExecutions.PromiseHandle NOT LIKE ''cfe_internal%'' OR PromiseExecutions.PromiseHandle IS NULL GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle, PromiseExecutions.PromiseOutcome ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC',	'{}',	'{}',	'{"SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", PromiseExecutions.PromiseOutcome AS \\\"Promise outcome\\\", COUNT(PromiseExecutions.PromiseHash) AS \\\"Occurrences\\\" FROM PromiseExecutions WHERE PromiseExecutions.PromiseHandle NOT LIKE ''cfe_internal%'' OR PromiseExecutions.PromiseHandle IS NULL GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle, PromiseExecutions.PromiseOutcome ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promises repaired (changed) of last run',	'2014-04-08 12:38:51',	'SELECT Hosts.HostName AS "Host name", PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", PromiseExecutions.LogMessages AS "Log messages", PromiseExecutions.ChangeTimeStamp AS "Change time" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE  PromiseExecutions.PromiseOutcome = ''REPAIRED'' ',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.BundleName\":{\"name\":\"BundleName\",\"label\":\"Bundle name\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.BundleName\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.PromiseType\":{\"name\":\"PromiseType\",\"label\":\"Promise type\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseType\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.Promiser\":{\"name\":\"Promiser\",\"label\":\"Promiser\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.Promiser\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.PromiseHandle\":{\"name\":\"PromiseHandle\",\"label\":\"Promise handle\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseHandle\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.LogMessages\":{\"name\":\"LogMessages\",\"label\":\"Log messages\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.LogMessages\",\"dataType\":\"array\",\"isSelected\":true},\"PromiseExecutions.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[{\"name\":\"PromiseOutcome\",\"label\":\"Promise outcome\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseOutcome\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"REPAIRED\"}],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", PromiseExecutions.LogMessages AS \\\"Log messages\\\", PromiseExecutions.ChangeTimeStamp AS \\\"Change time\\\" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE  PromiseExecutions.PromiseOutcome = ''REPAIRED'' \"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promises repaired (changed) of last run, aggregated by promise',	'2014-04-08 12:39:38',	'SELECT PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", COUNT(PromiseExecutions.PromiseHash) AS "Occurrences" FROM PromiseExecutions WHERE PromiseExecutions.PromiseOutcome = ''REPAIRED'' GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC',	'{}',	'{}',	'{"SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", COUNT(PromiseExecutions.PromiseHash) AS \\\"Occurrences\\\" FROM PromiseExecutions WHERE PromiseExecutions.PromiseOutcome = ''REPAIRED'' GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promises not kept (failed) of last run',	'2014-04-08 12:40:46',	'SELECT Hosts.HostName AS "Host name", PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", PromiseExecutions.LogMessages AS "Log messages", PromiseExecutions.ChangeTimeStamp AS "Change time" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE  PromiseExecutions.PromiseOutcome = ''NOTKEPT'' ',	'{}',	'{}',	'{"noResultsSuccess": true,"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.BundleName\":{\"name\":\"BundleName\",\"label\":\"Bundle name\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.BundleName\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.PromiseType\":{\"name\":\"PromiseType\",\"label\":\"Promise type\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseType\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.Promiser\":{\"name\":\"Promiser\",\"label\":\"Promiser\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.Promiser\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.PromiseHandle\":{\"name\":\"PromiseHandle\",\"label\":\"Promise handle\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseHandle\",\"dataType\":\"string\",\"isSelected\":true},\"PromiseExecutions.LogMessages\":{\"name\":\"LogMessages\",\"label\":\"Log messages\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.LogMessages\",\"dataType\":\"array\",\"isSelected\":true},\"PromiseExecutions.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[{\"name\":\"PromiseOutcome\",\"label\":\"Promise outcome\",\"inputType\":\"text\",\"table\":\"PromiseExecutions\",\"sqlField\":\"PromiseExecutions.PromiseOutcome\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"NOTKEPT\"}],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", PromiseExecutions.LogMessages AS \\\"Log messages\\\", PromiseExecutions.ChangeTimeStamp AS \\\"Change time\\\" FROM PromiseExecutions INNER JOIN Hosts ON Hosts.HostKey = PromiseExecutions.HostKey WHERE  PromiseExecutions.PromiseOutcome = ''NOTKEPT'' \"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	'1',	1,	'0',	'0',	'Promises not kept (failed) of last run, aggregated by promise',	'2014-04-08 12:41:26',	'SELECT PromiseExecutions.BundleName AS "Bundle name", PromiseExecutions.PromiseType AS "Promise type", PromiseExecutions.Promiser AS "Promiser", PromiseExecutions.PromiseHandle AS "Promise handle", COUNT(PromiseExecutions.PromiseHash) AS "Occurrences" FROM PromiseExecutions WHERE PromiseExecutions.PromiseOutcome = ''NOTKEPT'' GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC',	'{}',	'{}',	'{"noResultsSuccess": true, "SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT PromiseExecutions.BundleName AS \\\"Bundle name\\\", PromiseExecutions.PromiseType AS \\\"Promise type\\\", PromiseExecutions.Promiser AS \\\"Promiser\\\", PromiseExecutions.PromiseHandle AS \\\"Promise handle\\\", COUNT(PromiseExecutions.PromiseHash) AS \\\"Occurrences\\\" FROM PromiseExecutions WHERE PromiseExecutions.PromiseOutcome = ''NOTKEPT'' GROUP BY PromiseExecutions.BundleName, PromiseExecutions.PromiseType, PromiseExecutions.Promiser, PromiseExecutions.PromiseHandle ORDER BY COUNT(PromiseExecutions.PromiseHash) DESC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'file_integrity_monitoring',	'advanced',	'1',	1,	'0',	'0',	'File changes, excluding new files detected',	'2014-04-08 12:49:05',	'SELECT Hosts.HostName AS "Host name", FileChangesLog.FileName AS "File name", FileChangesLog.ChangeType AS "Change type", FileChangesLog.ChangeDetails AS "Change details", FileChangesLog.ChangeTimeStamp AS "Change time" FROM FileChangesLog INNER JOIN Hosts ON Hosts.HostKey = FileChangesLog.HostKey WHERE  FileChangesLog.ChangeType != ''N'' ORDER BY FileChangesLog.ChangeTimeStamp DESC ',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"FileChangesLog.FileName\":{\"name\":\"FileName\",\"label\":\"File name\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.FileName\",\"dataType\":\"string\",\"isSelected\":true},\"FileChangesLog.ChangeType\":{\"name\":\"ChangeType\",\"label\":\"Change type\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.ChangeType\",\"dataType\":\"string\",\"isSelected\":true},\"FileChangesLog.ChangeDetails\":{\"name\":\"ChangeDetails\",\"label\":\"Change details\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.ChangeDetails\",\"dataType\":\"array\",\"isSelected\":true},\"FileChangesLog.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[{\"name\":\"ChangeType\",\"label\":\"Change type\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.ChangeType\",\"dataType\":\"string\",\"isSelected\":true,\"logical\":\"AND\",\"comparison\":\"!=\",\"value\":\"N\"}],\"groupby\":{},\"orderby\":{\"FileChangesLog.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"FileChangesLog\",\"sqlField\":\"FileChangesLog.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true,\"order\":\"DESC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", FileChangesLog.FileName AS \\\"File name\\\", FileChangesLog.ChangeType AS \\\"Change type\\\", FileChangesLog.ChangeDetails AS \\\"Change details\\\", FileChangesLog.ChangeTimeStamp AS \\\"Change time\\\" FROM FileChangesLog INNER JOIN Hosts ON Hosts.HostKey = FileChangesLog.HostKey WHERE  FileChangesLog.ChangeType != ''N'' ORDER BY FileChangesLog.ChangeTimeStamp DESC \"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'file_integrity_monitoring',	'advanced',	'1',	1,	'0',	'0',	'File changes last day, excluding new files detected',	'2014-04-08 12:50:23',	'SELECT Hosts.HostName AS "Host name", FileChangesLog.FileName AS "File name", FileChangesLog.ChangeType AS "Change type", FileChangesLog.ChangeDetails AS "Change details", FileChangesLog.ChangeTimeStamp AS "Change time" FROM FileChangesLog INNER JOIN Hosts ON Hosts.HostKey = FileChangesLog.HostKey WHERE FileChangesLog.ChangeType != ''N'' AND FileChangesLog.ChangeTimeStamp > current_date - interval ''1'' day ORDER BY FileChangesLog.ChangeTimeStamp DESC',	'{}',	'{}',	'{"SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", FileChangesLog.FileName AS \\\"File name\\\", FileChangesLog.ChangeType AS \\\"Change type\\\", FileChangesLog.ChangeDetails AS \\\"Change details\\\", FileChangesLog.ChangeTimeStamp AS \\\"Change time\\\" FROM FileChangesLog INNER JOIN Hosts ON Hosts.HostKey = FileChangesLog.HostKey WHERE FileChangesLog.ChangeType != ''N'' AND FileChangesLog.ChangeTimeStamp > current_date - interval ''1'' day ORDER BY FileChangesLog.ChangeTimeStamp DESC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'inventory',	'advanced',	'1',	1,	'0',	'0',	'Hosts listening to port 80',	'2014-07-21 09:11:36',	'SELECT DISTINCT Hosts.HostKey,  hostname AS "Host name", table_default_sys_flavor.inventoryValue  AS "OS", table_default_sys_release.inventoryValue  AS "Kernel Release", cf_clearSlist(table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue ) AS "Ports listening" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Ports listening'') table_default_cfe_autorun_inventory_listening_ports_ports ON  table_default_cfe_autorun_inventory_listening_ports_ports.hostkey = hosts.hostkey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'') table_default_sys_flavor ON  table_default_sys_flavor.hostkey = hosts.hostkey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Kernel Release'') table_default_sys_release ON  table_default_sys_release.hostkey = hosts.hostkey WHERE table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue ILIKE ''%''''80''''%'' GROUP BY Hosts.hostkey , table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue, hosts.hostname, table_default_sys_flavor.inventoryValue, table_default_sys_release.inventoryValue',	'{}',	'{}',	'{"SQL":"{\"filters\":[{\"attribute_name\":\"attribute_name=Ports listening\",\"label\":\"Ports listening\",\"type\":\"slist\",\"keyname\":\"default.cfe_autorun_inventory_listening_ports.ports\",\"category\":\"Network\",\"readonly\":1,\"source_table\":\"inventory\",\"id\":\"attribute_name=Ports listening\",\"condition\":\"=\",\"value\":\"80\"}],\"columns\":[{\"keyname\":\"hostname\",\"attribute_name\":\"Host name\",\"label\":\"Host name\",\"type\":\"string\",\"category\":\"Network\",\"readonly\":\"1\",\"source_table\":\"hosts\",\"id\":\"Host name\",\"selected\":true},{\"attribute_name\":\"attribute_name=OS\",\"label\":\"OS\",\"type\":\"string\",\"keyname\":\"default.inventory_os.description\",\"category\":\"Software\",\"readonly\":1,\"source_table\":\"inventory\",\"id\":\"attribute_name=OS\",\"selected\":true},{\"attribute_name\":\"attribute_name=Kernel Release\",\"label\":\"Kernel Release\",\"type\":\"string\",\"keyname\":\"default.sys.release\",\"category\":\"Software\",\"readonly\":1,\"source_table\":\"inventory\",\"id\":\"attribute_name=Kernel Release\",\"selected\":true},{\"attribute_name\":\"attribute_name=Ports listening\",\"label\":\"Ports listening\",\"type\":\"slist\",\"keyname\":\"default.cfe_autorun_inventory_listening_ports.ports\",\"category\":\"Network\",\"convert_function\":\"cf_clearSlist\",\"readonly\":1,\"source_table\":\"inventory\",\"id\":\"attribute_name=Ports listening\",\"selected\":true}],\"SQLSTRING\":\"SELECT DISTINCT Hosts.HostKey,  hostname AS \\\"Host name\\\", table_default_sys_flavor.inventoryValue  AS \\\"OS\\\", table_default_sys_release.inventoryValue  AS \\\"Kernel Release\\\", cf_clearSlist(table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue ) AS \\\"Ports listening\\\" FROM Hosts INNER JOIN INVENTORY ON INVENTORY.HostKey = Hosts.HostKey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Ports listening'') table_default_cfe_autorun_inventory_listening_ports_ports ON  table_default_cfe_autorun_inventory_listening_ports_ports.hostkey = hosts.hostkey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=OS'') table_default_sys_flavor ON  table_default_sys_flavor.hostkey = hosts.hostkey  LEFT JOIN getHostkeyAndValuesForAttribute(''attribute_name=Kernel Release'') table_default_sys_release ON  table_default_sys_release.hostkey = hosts.hostkey WHERE table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue ILIKE ''%''''80''''%'' GROUP BY Hosts.hostkey , table_default_cfe_autorun_inventory_listening_ports_ports.inventoryValue, hosts.hostname, table_default_sys_flavor.inventoryValue, table_default_sys_release.inventoryValue\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'software',	'advanced',	'1',	1,	'0',	'0',	'Software installed',	'2014-04-08 13:15:55',	'SELECT Hosts.HostName AS "Host name", Software.SoftwareName AS "Software name", Software.SoftwareVersion AS "Software version", Software.SoftwareArchitecture AS "Software architecture", Software.ChangeTimeStamp AS "Discovered at (UTC)" FROM Software INNER JOIN Hosts ON Hosts.HostKey = Software.HostKey ORDER BY Software.SoftwareName ASC',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Software.SoftwareName\":{\"name\":\"SoftwareName\",\"label\":\"Software name\",\"inputType\":\"text\",\"table\":\"Software\",\"sqlField\":\"Software.SoftwareName\",\"dataType\":\"string\",\"isSelected\":true},\"Software.SoftwareVersion\":{\"name\":\"SoftwareVersion\",\"label\":\"Software version\",\"inputType\":\"text\",\"table\":\"Software\",\"sqlField\":\"Software.SoftwareVersion\",\"dataType\":\"string\",\"isSelected\":true},\"Software.SoftwareArchitecture\":{\"name\":\"SoftwareArchitecture\",\"label\":\"Software architecture\",\"inputType\":\"text\",\"table\":\"Software\",\"sqlField\":\"Software.SoftwareArchitecture\",\"dataType\":\"string\",\"isSelected\":true},\"Software.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"Software\",\"sqlField\":\"Software.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[],\"groupby\":{},\"orderby\":{\"Software.SoftwareName\":{\"name\":\"SoftwareName\",\"label\":\"Software name\",\"inputType\":\"text\",\"table\":\"Software\",\"sqlField\":\"Software.SoftwareName\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Software.SoftwareName AS \\\"Software name\\\", Software.SoftwareVersion AS \\\"Software version\\\", Software.SoftwareArchitecture AS \\\"Software architecture\\\", Software.ChangeTimeStamp AS \\\"Discovered at (UTC)\\\" FROM Software INNER JOIN Hosts ON Hosts.HostKey = Software.HostKey ORDER BY Software.SoftwareName ASC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'software',	'advanced',	'1',	1,	'0',	'0',	'Software updates available',	'2014-04-19 02:09:22',	'SELECT Hosts.HostName AS "Host name", SoftwareUpdates.PatchName AS "Patch name", SoftwareUpdates.PatchVersion AS "Patch version", SoftwareUpdates.PatchArchitecture AS "Patch architecture", SoftwareUpdates.ChangeTimeStamp AS "Discovered at (UTC)" FROM SoftwareUpdates INNER JOIN Hosts ON Hosts.HostKey = SoftwareUpdates.HostKey WHERE  SoftwareUpdates.PatchReportType = ''AVAILABLE'' ORDER BY SoftwareUpdates.ChangeTimeStamp ASC',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"SoftwareUpdates.PatchName\":{\"name\":\"PatchName\",\"label\":\"Patch name\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.PatchName\",\"dataType\":\"string\",\"isSelected\":true},\"SoftwareUpdates.PatchVersion\":{\"name\":\"PatchVersion\",\"label\":\"Patch version\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.PatchVersion\",\"dataType\":\"string\",\"isSelected\":true},\"SoftwareUpdates.PatchArchitecture\":{\"name\":\"PatchArchitecture\",\"label\":\"Patch architecture\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.PatchArchitecture\",\"dataType\":\"string\",\"isSelected\":true},\"SoftwareUpdates.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[{\"name\":\"PatchReportType\",\"label\":\"Patch-report type\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.PatchReportType\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"AVAILABLE\"}],\"groupby\":{},\"orderby\":{\"SoftwareUpdates.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"SoftwareUpdates\",\"sqlField\":\"SoftwareUpdates.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", SoftwareUpdates.PatchName AS \\\"Patch name\\\", SoftwareUpdates.PatchVersion AS \\\"Patch version\\\", SoftwareUpdates.PatchArchitecture AS \\\"Patch architecture\\\", SoftwareUpdates.ChangeTimeStamp AS \\\"Discovered at (UTC)\\\" FROM SoftwareUpdates INNER JOIN Hosts ON Hosts.HostKey = SoftwareUpdates.HostKey WHERE  SoftwareUpdates.PatchReportType = ''AVAILABLE'' ORDER BY SoftwareUpdates.ChangeTimeStamp ASC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'resource_usage',	'advanced',	'1',	1,	'0',	'0',	'Benchmarks',	'2014-04-08 13:19:43',	'SELECT Hosts.HostName AS "Host name", BenchmarksLog.EventName AS "Event name", cast(BenchmarksLog.LastValue AS real) AS "Last value", cast(BenchmarksLog.AverageValue AS real) AS "Average value", cast(BenchmarksLog.StandardDeviation AS real) AS "Standard deviation", BenchmarksLog.CheckTimeStamp AS "Check time" FROM BenchmarksLog INNER JOIN Hosts ON Hosts.HostKey = BenchmarksLog.HostKey ORDER BY BenchmarksLog.CheckTimeStamp DESC ',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"BenchmarksLog.EventName\":{\"name\":\"EventName\",\"label\":\"Event name\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.EventName\",\"dataType\":\"string\",\"isSelected\":true},\"BenchmarksLog.LastValue\":{\"name\":\"LastValue\",\"label\":\"Last value\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.LastValue\",\"dataType\":\"real\",\"isSelected\":true},\"BenchmarksLog.AverageValue\":{\"name\":\"AverageValue\",\"label\":\"Average value\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.AverageValue\",\"dataType\":\"real\",\"isSelected\":true},\"BenchmarksLog.StandardDeviation\":{\"name\":\"StandardDeviation\",\"label\":\"Standard deviation\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.StandardDeviation\",\"dataType\":\"real\",\"isSelected\":true},\"BenchmarksLog.CheckTimeStamp\":{\"name\":\"CheckTimeStamp\",\"label\":\"Check time\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.CheckTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[],\"groupby\":{},\"orderby\":{\"BenchmarksLog.CheckTimeStamp\":{\"name\":\"CheckTimeStamp\",\"label\":\"Check time\",\"inputType\":\"text\",\"table\":\"BenchmarksLog\",\"sqlField\":\"BenchmarksLog.CheckTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true,\"order\":\"DESC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", BenchmarksLog.EventName AS \\\"Event name\\\", cast(BenchmarksLog.LastValue AS real) AS \\\"Last value\\\", cast(BenchmarksLog.AverageValue AS real) AS \\\"Average value\\\", cast(BenchmarksLog.StandardDeviation AS real) AS \\\"Standard deviation\\\", BenchmarksLog.CheckTimeStamp AS \\\"Check time\\\" FROM BenchmarksLog INNER JOIN Hosts ON Hosts.HostKey = BenchmarksLog.HostKey ORDER BY BenchmarksLog.CheckTimeStamp DESC \"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'resource_usage',	'advanced',	'1',	1,	'0',	'0',	'Memory free (MB)',	'2014-04-08 13:32:12',	'SELECT Hosts.HostName AS "Host name", Variables.VariableValue AS "Memory free (MB)" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_memory'' AND Variables.VariableName = ''free'' ORDER BY Variables.VariableValue::numeric ASC',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"cfe_autorun_inventory_memory\"},{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"free\"}],\"groupby\":{},\"orderby\":{\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.VariableValue AS \\\"Memory free (MB)\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_memory'' AND Variables.VariableName = ''free'' ORDER BY Variables.VariableValue::numeric ASC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'resource_usage',	'advanced',	'1',	1,	'0',	'0',	'Hosts with less than 20% disk free',	'2014-04-08 13:32:42',	'SELECT Hosts.HostName AS "Host name", Variables.VariableValue  AS "Disk free %" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"cfe_autorun_inventory_disk\"},{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"free\"}],\"groupby\":{},\"orderby\":{\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.VariableValue  AS \\\"Disk free %\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'resource_usage',	'advanced',	'1',	1,	'0',	'0',	'Load averages',	'2014-04-08 13:34:55',	'SELECT Hosts.HostName AS "Host name", Variables.VariableValue AS "Load average" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_loadaverage'' AND Variables.VariableName = ''value'' ORDER BY Variables.VariableValue::numeric DESC',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"cfe_autorun_inventory_loadaverage\"},{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"value\"}],\"groupby\":{},\"orderby\":{\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"DESC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.VariableValue AS \\\"Load average\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_loadaverage'' AND Variables.VariableName = ''value'' ORDER BY Variables.VariableValue::numeric DESC\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'uncategorized',	'advanced',	'1',	1,	'0',	'0',	'Contexts (classes) defined last run',	'2014-04-08 13:35:54',	'SELECT Hosts.HostName AS "Host name", Contexts.ContextName AS "Context name", Contexts.ChangeTimeStamp AS "Defined since" FROM Contexts INNER JOIN Hosts ON Hosts.HostKey = Contexts.HostKey',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Contexts.ContextName\":{\"name\":\"ContextName\",\"label\":\"Context name\",\"inputType\":\"text\",\"table\":\"Contexts\",\"sqlField\":\"Contexts.ContextName\",\"dataType\":\"string\",\"isSelected\":true},\"Contexts.ChangeTimeStamp\":{\"name\":\"ChangeTimeStamp\",\"label\":\"Change time\",\"inputType\":\"text\",\"table\":\"Contexts\",\"sqlField\":\"Contexts.ChangeTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Contexts.ContextName AS \\\"Context name\\\", Contexts.ChangeTimeStamp AS \\\"Defined since\\\" FROM Contexts INNER JOIN Hosts ON Hosts.HostKey = Contexts.HostKey\"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'uncategorized',	'advanced',	'1',	1,	'0',	'0',	'CFEngine connections',	'2014-04-08 13:37:39',	'SELECT Hosts.HostName AS "Host name", LastSeenHosts.LastSeenDirection AS "Last seen direction", LastSeenHosts.RemoteHostKey AS "Remote host key", LastSeenHosts.RemoteHostIP AS "Remote host IP", LastSeenHosts.LastSeenTimeStamp AS "Last seen time" FROM LastSeenHosts INNER JOIN Hosts ON Hosts.HostKey = LastSeenHosts.HostKey ',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"LastSeenHosts.LastSeenDirection\":{\"name\":\"LastSeenDirection\",\"label\":\"Last seen direction\",\"inputType\":\"text\",\"table\":\"LastSeenHosts\",\"sqlField\":\"LastSeenHosts.LastSeenDirection\",\"dataType\":\"string\",\"isSelected\":true},\"LastSeenHosts.RemoteHostKey\":{\"name\":\"RemoteHostKey\",\"label\":\"Remote host key\",\"inputType\":\"text\",\"table\":\"LastSeenHosts\",\"sqlField\":\"LastSeenHosts.RemoteHostKey\",\"dataType\":\"string\",\"isSelected\":true},\"LastSeenHosts.RemoteHostIP\":{\"name\":\"RemoteHostIP\",\"label\":\"Remote host IP\",\"inputType\":\"text\",\"table\":\"LastSeenHosts\",\"sqlField\":\"LastSeenHosts.RemoteHostIP\",\"dataType\":\"string\",\"isSelected\":true},\"LastSeenHosts.LastSeenTimeStamp\":{\"name\":\"LastSeenTimeStamp\",\"label\":\"Last seen time\",\"inputType\":\"text\",\"table\":\"LastSeenHosts\",\"sqlField\":\"LastSeenHosts.LastSeenTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", LastSeenHosts.LastSeenDirection AS \\\"Last seen direction\\\", LastSeenHosts.RemoteHostKey AS \\\"Remote host key\\\", LastSeenHosts.RemoteHostIP AS \\\"Remote host IP\\\", LastSeenHosts.LastSeenTimeStamp AS \\\"Last seen time\\\" FROM LastSeenHosts INNER JOIN Hosts ON Hosts.HostKey = LastSeenHosts.HostKey \"}"}', '{"source": "from CFEngine team"}'),
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'uncategorized',	'advanced',	'1',	1,	'0',	'0',	'Variables',	'2014-04-08 13:41:37',	'SELECT Hosts.HostName AS "Host name", Variables.Bundle AS "Bundle", Variables.VariableName AS "Variable name", Variables.VariableValue AS "Variable value" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.NameSpace = ''default'' ',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.Bundle\":{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableName\":{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"NameSpace\",\"label\":\"Name space\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.NameSpace\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"default\"}],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.Bundle AS \\\"Bundle\\\", Variables.VariableName AS \\\"Variable name\\\", Variables.VariableValue AS \\\"Variable value\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.NameSpace = ''default'' \"}"}', '{"source": "from CFEngine team"}')
ON CONFLICT DO NOTHING;

-- OOTB reports 3.12.0
INSERT INTO "report" ("username", "url", "reporttype", "reportcategory", "type", "readonly", "is_public", "can_subscribe", "is_subscribed", "label", "date", "params", "sharedpermission", "sharedby", "advancedreportsdata", "meta_data") VALUES
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'uncategorized',	'advanced',	'1',	'1',	'0',	'0',	'Hosts were bootstrapped to the hub',	'2017-12-07 13:52:32',	'SELECT Hosts.HostName AS "Host name", Hosts.FirstReportTimeStamp AS "First report-time" FROM Hosts',	'{}',	'{}',	'{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Hosts.FirstReportTimeStamp\":{\"name\":\"FirstReportTimeStamp\",\"label\":\"First report-time\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.FirstReportTimeStamp\",\"dataType\":\"timestamp\",\"isSelected\":true}},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Hosts.FirstReportTimeStamp AS \\\"First report-time\\\" FROM Hosts\"}"}', '{"source": "from CFEngine team"}')
ON CONFLICT DO NOTHING;

-- ENT-6444 Create example of compliance report
INSERT INTO "report" (
"username",
"url",
"reporttype",
"reportcategory",
"type",
"readonly",
"is_public",
"can_subscribe",
"is_subscribed",
"label",
"date",
"params",
"sharedpermission",
"sharedby",
"advancedreportsdata",
"meta_data")
VALUES
('CFE_ROBOT',
 'advancedreports',
 'Advanced reports',
 'compliance_report',
 'compliance',
 1,
 1,
 0,
 0,
 'Example Compliance Report',
 '2020-10-28 17:54:00',
 '',
 '{}',
 '{}',
 ('{"SQL":"{\"conditions\":[' ||
     (SELECT string_agg(id::text, ',') FROM dashboard_rules WHERE name IN (
         'More than 0 CPU cores',
         'Available disk space',
         'Supported Debian',
         'Packages should be updated',
         'OS is reported',
         'Supported RHEL',
         'Supported Ubuntu',
         'Supported CentOS'
         ) AND username = 'admin')
  || '],\"SQLSTRING\":\"\"}"}')::json,
 '{"source": "from CFEngine team"}'
  )
ON CONFLICT DO NOTHING;

-- ENT-3305 Avoid broken report if reported free disk is not numeric
-- This updates the OOTB report that was originally introduced in 3.6.0
UPDATE report SET params = 'SELECT Hosts.HostName AS "Host name", Variables.VariableValue  AS "Disk free %" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC'
WHERE params='SELECT Hosts.HostName AS "Host name", Variables.VariableValue  AS "Disk free %" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC';
UPDATE report SET advancedreportsdata = '{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"cfe_autorun_inventory_disk\"},{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"free\"}],\"groupby\":{},\"orderby\":{\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.VariableValue  AS \\\"Disk free %\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue ~ ''[0-9]'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC\"}"}'
WHERE advancedreportsdata::text = '{"SQL":"{\"fields\":{\"Hosts.HostName\":{\"name\":\"HostName\",\"label\":\"Host name\",\"inputType\":\"text\",\"table\":\"Hosts\",\"sqlField\":\"Hosts.HostName\",\"dataType\":\"string\",\"isSelected\":true},\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true}},\"filters\":[{\"name\":\"Bundle\",\"label\":\"Bundle\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.Bundle\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"cfe_autorun_inventory_disk\"},{\"name\":\"VariableName\",\"label\":\"Variable name\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableName\",\"dataType\":\"string\",\"isSelected\":false,\"logical\":\"AND\",\"comparison\":\"=\",\"value\":\"free\"}],\"groupby\":{},\"orderby\":{\"Variables.VariableValue\":{\"name\":\"VariableValue\",\"label\":\"Variable value\",\"inputType\":\"text\",\"table\":\"Variables\",\"sqlField\":\"Variables.VariableValue\",\"dataType\":\"string\",\"isSelected\":true,\"order\":\"ASC\"}},\"limit\":\"\",\"SQLSTRING\":\"SELECT Hosts.HostName AS \\\"Host name\\\", Variables.VariableValue  AS \\\"Disk free %\\\" FROM Variables INNER JOIN Hosts ON Hosts.HostKey = Variables.HostKey WHERE  Variables.Bundle = ''cfe_autorun_inventory_disk'' AND Variables.VariableName = ''free'' AND Variables.VariableValue::numeric < 20 ORDER BY Variables.VariableValue::numeric ASC\"}"}';


INSERT INTO mail_settings (key, value) VALUES
('protocol', ''),
('default_from_email', ''),
('mailpath', ''),
('smtp_host', ''),
('smtp_user', ''),
('smtp_pass', ''),
('max_email_attach_size', '10'),
('smtp_crypto', ''),
('smtp_port', ''),
('email_link_domain', '')
ON CONFLICT DO NOTHING;

-- Set seen_tour to 0 to show tour guide after the update.
UPDATE users SET seen_tour = 0;

--- ENT-4093  NULLs are converted to empty strings in variable table ---
UPDATE report SET advancedreportsdata = regexp_replace(advancedreportsdata::text, 'variablevalue(\s+)IS(\s+)NULL', 'variablevalue = ''''', 'ig')::json;
UPDATE report SET advancedreportsdata = regexp_replace(advancedreportsdata::text, 'variablevalue(\s+)IS(\s+)NOT(\s+)NULL', 'variablevalue != ''''', 'ig')::json;

--- ENT-4766 Promises not kept (failed) that have not been kept or repaired ---
INSERT INTO "report" ("username", "url", "reporttype", "reportcategory", "type", "readonly", "is_public", "can_subscribe", "is_subscribed", "label", "date", "params", "sharedpermission", "sharedby", "advancedreportsdata", "meta_data") VALUES
('CFE_ROBOT',	'advancedreports',	'Advanced reports',	'compliance',	'advanced',	1,	1,	0,	0,	'Promises not kept (failed) that have not been kept or repaired',	'2019-06-19 12:42:02',	'SELECT DISTINCT ON (promisehash) * FROM not_kept_not_repaired',	'{}',	'{}',	'{"noResultsSuccess": true, "SQL":"{\"fields\":{},\"filters\":[],\"groupby\":{},\"orderby\":{},\"limit\":\"\",\"SQLSTRING\":\"SELECT DISTINCT ON (promisehash) * FROM not_kept_not_repaired\"}"}', '{"source": "from CFEngine team"}')
ON CONFLICT DO NOTHING;

--- ENT-4767 ---

INSERT INTO customization (key, value) VALUES
('logo_on_pdf', '1')
ON CONFLICT DO NOTHING;

UPDATE dashboard_widgets SET payload = '{}' WHERE payload IS NULL;

-- ENT-5557 --
UPDATE report SET reportcategory = 'promise_outcomes' WHERE reportcategory = 'compliance';

-- ENT-3607 - Target hosts reporting policy_server for Policy Deployment alert--
UPDATE dashboard_alerts
   SET    hostcontexts =
          '{"includes": ["policy_server"], "name": "Policy Servers"}'
 WHERE  ( hostcontexts ->> 'includes' = '["%"]'
         OR hostcontexts IS NULL )
   AND NAME = 'Policy Deployment';

-- ENT-8258 Added export IDs to default rules
UPDATE dashboard_rules SET export_id = 'software-updates-available'
WHERE name = 'Software updates available' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'entire-cfengine-policy'
WHERE name = 'Entire CFEngine policy' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'supported-ubuntu'
WHERE name = 'Supported Ubuntu' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'supported-rhel'
WHERE name = 'Supported RHEL' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'os-is-reported'
WHERE name = 'OS is reported' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'packages-should-be-updated'
WHERE name = 'Packages should be updated' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'supported-debian'
WHERE name = 'Supported Debian' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'available-disk-space'
WHERE name = 'Available disk space' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'more-than-0-cpu-cores'
WHERE name = 'More than 0 CPU cores' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'policy-deployment'
WHERE name = 'Policy Deployment' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'supported-centos'
WHERE name = 'Supported CentOS' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE dashboard_rules SET export_id = 'low-disk-space'
WHERE name = 'Low disk space' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

UPDATE report SET export_id = 'example-compliance-report'
WHERE label = 'Example Compliance Report' AND (username = 'admin' OR username IS NULL) AND export_id IS NULL;

-- ENT-10822 - Example Compliance Report should be readonly so not editable
UPDATE report set readonly = 1
WHERE label = 'Example Compliance Report' AND username = 'CFE_ROBOT';

BEGIN;
SELECT migrate_duplicate_reports();
COMMIT;
