'use strict';
/**
 * Show list of saved reports
 **/
var allreportsController = BaseController.extend({
    /**
     * Initialize  Controller
     * @param $scope, current controller scope
     */
    init: function($scope, $location, reportService, notificationService, wizardSharedService, commonHelper, paginationService, modalWindowService) {
        var self = this;

        this._super($scope);
        this._reportService = reportService;
        this._notificationService = notificationService;
        this._wizardSharedService = wizardSharedService;
        this._commonHelper        = commonHelper;


        this.$scope.paginator     = paginationService;
        this.$scope.modalWindow   = modalWindowService;


        self.$scope.reportRoles = {};
        self.$scope.selectedCategories = {};
        self.$scope.roles    = this._commonHelper.getRolesArray();
        self.$scope.is_admin = self._commonHelper.checkifAdmin(self.$scope.roles);
        self.$scope.is_public = {};

        this.$location = $location;

        self.$scope.Math = Math;

        self.$scope.savedSearchName = {};
        self.$scope.currentReportId = '';
        self.$scope.savedSearchCategory = {};

        self.$scope.selectedCategories = [];
        self.$scope.reportCategories = ReportCategories;

        self._commonHelper._setVIEWVariables(self.$scope);

        self._refreshAllReportList();
    },

    defineScope: function() {
        this.$scope.instance = "allreportsController";
        this.$scope.cleanStoredScope     = this.cleanStoredScope.bind(this);
        this.$scope.setCurrentReportData = this.setCurrentReportData.bind(this);

        this.$scope.showOwnReports  = this.showOwnReports.bind(this);
        this.$scope.copyReport      = this.copyReport.bind(this);
        this.$scope.subscribe       = this.subscribe.bind(this);
        this.$scope.unsubscribe     = this.unsubscribe.bind(this);

        this.$scope.createNewReport = this.createNewReport.bind(this);

        this.$scope.sortReorder     = this.sortReorder.bind(this);
        //TODO: refactor
        this.$scope.roles_disablePublicReport = this.roles_disablePublicReport.bind(this);
        this.$scope.publicReport_disableRoles = this.publicReport_disableRoles.bind(this);

        this.$scope.isObjEmpty          = this.checkIfObjEmpty.bind(this);

        this.$scope.filterCategories    = this.filterCategories.bind(this);
        this.$scope.isSelectedCategory  = this.isSelectedCategory.bind(this);
    },


    defineListeners: function() {
        var self = this;

        self.$scope.$on('paginatorChange', function() {
           self._refreshAllReportList();
        });

        self.$scope.$on('subscribeToReport', function() {
           self._refreshAllReportList();
        });

        self.$scope.$on('unSubscribeFromReport', function() {
           self._refreshAllReportList();
        });
     },
     /**
     *  Click on new report button
     */
    createNewReport: function(arg)
    {
        var self = this;
        sessionStorage.clear();
        self._wizardSharedService.resetScope();
         if (arg === 'inventory') {
            self.$location.path('/inventory');
        } else if (arg === 'changes') {
            self.$location.path('/changes');
        } else {
          self.$location.path('/custom/new');
        }
    },

    filterCategories: function(cat) {

        if (cat) {
            var index = this.$scope.selectedCategories.indexOf(cat);
            if (index !== -1) {
                this.$scope.selectedCategories.splice(index, 1);
            } else {
                this.$scope.selectedCategories.push(cat);
            }
        } else {
            this.$scope.selectedCategories = [];
        }

        this._refreshAllReportList();
    },
    isSelectedCategory: function(cat) {
        var index = this.$scope.selectedCategories.indexOf(cat);
        return (index === -1) ? false : true;
    },
    /**
     * Query server for all reports available for user excluding
     */

    _refreshAllReportList: function() {
        var self = this;
        self.$scope.reports_loaded = false;
        self.$scope.savedReports  = {};

        var pagingData = $.param({
            page      : (self.$scope.paginator.page !== undefined ? self.$scope.paginator.page : 1),
            limit     : self.$scope.paginator.rowsPerPage,
            reportCategory: self.$scope.selectedCategories,
            sortColumn    : (self.$scope.VIEW.sortColumn     !== undefined && self.$scope.VIEW.sortColumn     != '' ? self.$scope.VIEW.sortColumn     : 'label'),
            sortDescending: (self.$scope.VIEW.sortDescending !== undefined && self.$scope.VIEW.sortDescending != '' ? self.$scope.VIEW.sortDescending : '0')
        });

        self._reportService.loadAllReports(pagingData).then(
            function(result) {
                var tmp = result.data;
                self.$scope.savedReports  = tmp.items;
                self.$scope.paginator.refreshPaginator(tmp.total);
                if (self.$scope.paginator.page > self.$scope.paginator.pages) {
                    // if refreshing data causes current page to be outwith page range, reset page number
                    self.$scope.paginator.reloadView(self.$scope.paginator.pages);
                }
                self.$scope.reports_loaded = true;
            },
            function(error) {
                self._notificationService.setNotification('error', error.data);
                self.$scope.reports_loaded = true;
            });
    },

    showOwnReports: function() {
        var self = this;
        self.$location.path('/index');
    },

    cleanStoredScope: function() {
        this._wizardSharedService.resetScope();
    },

    copyReport: function(isOverwrite) {
        var self = this;
        self._commonHelper.copyReport(self.$scope.currentReportId, self.$scope.savedSearchName.input, self.$scope, isOverwrite);
    },

    subscribe: function(id) {
        var self = this;
        var $scope = self.$scope;
        self._commonHelper.subscribeToReport(id);
    },

    unsubscribe: function(id) {
        var self = this;
        var $scope = self.$scope;
        self._commonHelper.unSubscribeFromReport(id);
    },

    setCurrentReportData: function (id, label, reportCategory) {
        var self = this;
        self.$scope.currentReportId    = id;
        self.$scope.savedSearchName.input = "Copy_".concat(label);
        self.$scope.savedSearchCategory.input = reportCategory;

        if (reportCategory === 'inventory') {
            self.$scope.savedSearchCategory.readonly = true;
        }
    },
// TODO: refactor
   sortReorder: function(col, e) {
        var self = this;
        angular.forEach(self.$scope.VIEW.tablehead, function(el) {

            if (el.nameToSort==col)
            {
                el.sort = el.sort>0?-1:1;
                self.$scope.VIEW.sortColumn     = el.name;
                self.$scope.VIEW.sortDescending = el.sort>0 ? 0:1; //
            }
            else
            {
                el.sort = null;
            }
        });

        if (self.$scope.VIEW.sortColumn !== undefined && self.$scope.VIEW.sortColumn !=='')
        {
            self._refreshAllReportList();
        }
    },
     /*
     * When user clicks on public report checkbox
     */
    publicReport_disableRoles: function() {
        var self = this;
        var $scope = self.$scope;
        self._commonHelper.publicReport_disableRoles($scope.is_public.input, $scope);
    },
    // when user clicks on roles
    roles_disablePublicReport: function() {
        var self = this;
        var $scope = self.$scope;
        self._commonHelper.roles_disablePublicReport($scope.is_public.input, $scope);
    },

    checkIfObjEmpty: function (val)
    {
       var self = this;
       return self._commonHelper._isObjEmpty(val);
    }
});

allreportsController.$inject = ['$scope', '$location', 'reportService', 'notificationService', 'wizardSharedService', 'commonHelper', 'paginationService', 'modalWindowService'];