<?php

class DismissHealthDiagnosticModel
{
    const DISMISS_TABLE = '__health_diagnostics_dismissed';

    /**
     * @var PDO
     */
    private $cfdb;

    /**
     * @var string
     */
    private $userName;

    public function __construct(PDO $cfdb, string $userName)
    {
        $this->cfdb = $cfdb;
        $this->userName = $userName;
    }

    public function dismissedList($type, int $limit, int $offset)
    {
        $query = "SELECT * FROM hosts 
                  WHERE hostkey IN (
                      SELECT hostkey FROM health_diagnostics_dismissed 
                      WHERE report_type = '{$type}' AND username = '{$this->userName}'
                  )";
        $result = cfapi_query_post($this->userName, $query, '', false, $offset, $limit, [], []);
        return $result;
    }

    public function add(array $hostkeys, string $type)
    {
        $sql = 'INSERT INTO ' . self::DISMISS_TABLE . ' (hostkey, report_type, username) VALUES 
                (:hostkey, :report_type, :username) 
                ON CONFLICT DO NOTHING';
        $statement = $this->cfdb->prepare($sql);

        try {
            $this->cfdb->beginTransaction();
            foreach ($hostkeys as $hostkey) {
                $data = [
                    'hostkey' => $hostkey,
                    'report_type' => $type,
                    'username' => $this->userName
                ];

                $statement->execute($data);
            }
            $this->cfdb->commit();
        } catch (Exception $e) {
            $this->cfdb->rollBack();
            throw new Exception($e->getMessage());
        }
    }

    public function delete(array $hostkeys, string $type)
    {
        $sql = 'DELETE FROM ' . self::DISMISS_TABLE . ' 
                WHERE hostkey = :hostkey 
                AND report_type = :report_type 
                AND username = :username';
        $statement = $this->cfdb->prepare($sql);
        try {
            $this->cfdb->beginTransaction();
            foreach ($hostkeys as $hostkey) {
                $data = [
                    'hostkey' => $hostkey,
                    'report_type' => $type,
                    'username' => $this->userName
                ];

                $statement->execute($data);
            }
            $this->cfdb->commit();
        } catch (Exception $e) {
            $this->cfdb->rollBack();
            throw new Exception($e->getMessage());
        }
    }
}
