if (typeof require != 'undefined') throw "`require` already defined"

var rootRequire = function (fileName, cwd) {
    if (!fileName) throw new Error("Invalid argument to rootRequire")
    
    var resolved    = rootResolve(fileName, cwd)
    
    var module      = modules[ resolved ]
    
    if (!module) throw new Error('Failed to resolve module: ' + fileName + ', tried: ' + resolved)
    
    return cache[ resolved ] || (cache[ resolved ] = module(rootRequire))
}

var modules = rootRequire.modules   = {}
var cache   = rootRequire.cache     = {}

var resolver    

var rootResolve = function (fileName, baseDir) {
    
    if (!resolver) {
        resolver    = ModuleResolver.methods
        
        var props = {
            
            coreModules : {
                'assert'    : true,
                'events'    : true,
                'fs'        : true,
                'path'      : true,
                'vm'        : true
            },
            
            fileExists  : function (fileName) {
                return modules[ fileName ] != null
            },

            
            getCoreModule : function (coreModule) {
                throw new Error('not supported yet')
            },
            
            
            addAdditionalDependency : function () {
                throw "Should never happen on client"
            },
            
            
            getFileAsJSON : function (fileName) {
                return modules[ fileName ]()
            }
        }
        
        for (var name in props) resolver[ name ] = props[ name ]
    }
    
    return resolver.resolve(fileName, baseDir)
}


var child   = rootRequire.child = function (dirName) {
    
    var childRequire        = function (fileName) { return rootRequire(fileName, dirName) }
    
    childRequire.resolve    = function (fileName) { return rootResolve(fileName, dirName) }
    childRequire.modules    = modules
    childRequire.cache      = cache
    
    return childRequire
}

return rootRequire
