<?php
// Change the css classes to suit your needs

$this->load->helper('form_helper');
$this->load->library(array('form_validation'));
$attributes = array('class' => 'form-horizontal confirm-before-leave', 'id' => 'mpsettings', 'autocomplete' => "off");
echo form_open_multipart('settings/mail', $attributes);
?>
<div class="control-group mail_settings">
    <label class="control-label" for="authentication">Mail protocol</label>
    <div class="controls">
        <label class="radio inline">
            <?php
            $elem = array(
                'name' => 'protocol',
                'id' => 'mailProtocol1',
                'class' => 'radio',
                'value' => 'sendmail',
                'checked' => ((isset($protocol) && $protocol === 'sendmail') || empty($protocol) ? true : $this->form_validation->set_radio('protocol',
                    'sendmail'))
            );
            echo form_radio($elem);
            ?>
            Sendmail
        </label>

        <label class="radio inline">

            <?php
            $elem = array(
                'name' => 'protocol',
                'id' => 'mailProtocol2',
                'class' => 'radio',
                'value' => 'smtp',
                'checked' => (isset($protocol) && $protocol === 'smtp' ? true : $this->form_validation->set_radio('protocol',
                    'smtp'))
            );
            echo form_radio($elem);
            ?>
            SMTP
        </label>
    </div>
</div>
<fieldset CLASS="border-bottom">
    <div class="control-group">
        <label class="control-label" for="bluehost_threshold_global">Default from email</label>
        <div class="controls">
            <input id="default_from_email" type="text" name="default_from_email"
                   value="<?= isset($default_from_email) ? htmlspecialchars($default_from_email) : '' ?>"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label" for="bluehost_threshold_global">Max email attachment size (MB)</label>
        <div class="controls">
            <input id="max_email_attach_size" type="text" name="max_email_attach_size"
                   value="<?= isset($max_email_attach_size) ? htmlspecialchars($max_email_attach_size) : '' ?>"/>
        </div>
    </div>
    <div class="control-group mailpath-block">
        <label class="control-label" for="bluehost_threshold_global">Sendmail path</label>
        <div class="controls">
            <input id="mailpath" type="text" name="mailpath" placeholder="/usr/sbin/sendmail"
                   value="<?= isset($mailpath) ? htmlspecialchars($mailpath) : '' ?>"/>
        </div>
    </div>
</fieldset>
<fieldset id="smtpSettings" class="border-bottom" style="display: none;">
    <div class="control-group">
        <label class="control-label" for="host">SMTP host</label>
        <div class="controls">
            <input id="smtp_host" type="text" name="smtp_host"
                   value="<?= isset($smtp_host) ? htmlspecialchars($smtp_host) : '' ?>"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label" for="host">SMTP user</label>
        <div class="controls">
            <input id="smtp_user" type="text" name="smtp_user"
                   value="<?= isset($smtp_user) ? htmlspecialchars($smtp_user) : '' ?>"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label" for="host">SMTP password</label>
        <div class="controls">
            <input id="smtp_pass" type="password" autocomplete="new-password" autocomplete="off" onchange="this.setAttribute('name', 'smtp_pass')"
                   placeholder="<?php echo isset($smtp_pass) ? 'Password is set' : ''; ?>"/>
            <?php $this->load->view('common/show-password-btn.php'); ?>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label" for="host">SMTP port</label>
        <div class="controls">
            <input id="smtp_port" type="text" name="smtp_port"
                   value="<?= isset($smtp_port) ? htmlspecialchars($smtp_port) : '' ?>"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label" for="host">SMTP encryption</label>
        <div class="controls">
           <select name="smtp_crypto" >
                <option <?php if(isset($smtp_crypto) && $smtp_crypto == ''){ ?>selected="selected"<?php } ?> value="">none</option>
                <option <?php if(isset($smtp_crypto) && $smtp_crypto == 'ssl'){ ?>selected="selected"<?php } ?> value="ssl">ssl</option>
                <option <?php if(isset($smtp_crypto) && $smtp_crypto == 'tls'){ ?>selected="selected"<?php } ?> value="tls">tls</option>
           </select>
        </div>
    </div>

</fieldset>
<?php echo form_submit(array(
    'name' => 'submit',
    'class' => 'btn apply-button btn-primary btn-large pull-right',
    'value' => 'Apply'
)); ?>
<?php echo form_close(); ?>
<script type="text/javascript">
    $(document).ready(function () {
        var mode = $("input[name='protocol']:checked").val();
        settings_toggle();
        function settings_toggle() {
            if ($("input[name='protocol']:checked").val() == 'sendmail') {
                $('#smtpSettings').hide();
                $('.mailpath-block').show().find('input').css('display', 'block');
            }
            else if ($("input[name='protocol']:checked").val() == 'smtp') {
                $('#smtpSettings').show();
                $('.mailpath-block').hide().find('input').css('display', 'none');
            }
        };
        $("input[name='protocol']").change(function () {
            settings_toggle();
        });
    });
</script>