class PieWidget extends BaseBarPieWidget {
    constructor(payload, data)
    {
        super(payload, data);
        this.config = {
            chart: {
                type: 'pie',
                events: {
                    click: this.clickAction.bind(this)
                },
                attribute: '',
                backgroundColor: 'transparent'
            },

            exporting: {
                enabled: false
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    borderWidth: 0,
                    cursor: 'pointer',
                    center: ["18%", "50%"],
                    colors: widgetColors.pieColors(),
                    dataLabels: {
                        enabled: false
                    },
                    events: {
                        click: function (event) {
                            const clickAction = this.clickAction(event, event.point.name);
                            if (clickAction != undefined) {
                                clickAction.call(this);
                            }
                        }.bind(this)
                    },
                    showInLegend: true
                }
            },
            tooltip: {
                formatter: function () {
                    return this.key + ': ' + this.y;
                }
            },
            legend: {
                layout: 'vertical',
                backgroundColor: 'transparent',
                floating: true,
                align: 'right',
                verticalAlign: 'top',
                navigation: {
                    arrowSize: 8,
                    animation: true,
                    activeColor: widgetColors.pieNavigationColors().activeColor,
                    style: {
                        fontWeight: '500',
                        fontSize: '14px',
                        color: widgetColors.pieNavigationColors().textColor,
                        fontFamily: '"Red Hat Mono", monospace'
                    }
                },

                title: {
                    text: '',
                },

                itemStyle: {
                    fontSize: '14px',
                    textOverflow: 'ellipsis',
                    fontWeight: "500",
                    color: "#0B132A"
                },
                useHTML: true

            },

            series: [{
                name: this.variable,
                colorByPoint: true,
                data: []
            }],
            title: {
                text: ''
            },
            subtitle: {
                text: ''
            },
            credits: {
                enabled: false
            },
            loading: false
        };
    }

    getConfig() {
        let self = this;
        let pieConvertedData = this.pieConvertArray(this.data);
        this.config.series[0].data = pieConvertedData.array;
        this.config.legend.title.text = this.getLegendTitle();
        this.config.legend.labelFormatter = function () {
            return self.getLabel(this);
        },
            this.config.chart.attribute = this.variable;
        return this.config;
    }

    pieConvertArray(arr) {
        let returnData = {};
        returnData.array = [];
        angular.forEach(arr.data, function (value, key) {
            returnData.array.push({name: key, y: value});
        });
        return returnData;
    };
}
