'use strict';

var dashboardApp = angular.module('dashboardApp',
        [
            'ui.sortable',
            'ngRoute',
            'ngCookies',
            'ui.bootstrap',
            'inventoryServiceModule',
            'autocompleteServiceModule',
            'dashboardApp.filters',
            'alertsServiceModule',
            'widgetwizardServiceModule',
            'changesServiceModule',
            'dashboardServiceModule',
            'welcomeWizardServiceModule',
            'eventsLogServiceModule',
            'rulesServiceModule',
            'commonDirectives',
            'inventoryDirectives',
            'commonHelper',
            'inventoryHelpers',
            'dc.naviTreeService',
            'env.environmentServiceModule',
            'inclExcl.paginationServiceModule',
            'inclExclDirectives',
            'inclExcl.naviTreeService',
            'includeExcludeServiceModule',
            'autoCompleteServiceModule',
            'localytics.directives',
            'daterangepicker',
            'inventoryDataServiceModule',
            'inventoryFilterServiceModule',
            'userServiceModule',
            'highChartsDirective',
            'healthIssueDirective',
            'customFilter',
            'reportServiceModule',
            'complianceWidgetDirective',
            'complianceWidgetHelper',
            'complianceHelperModule',
            'editableFieldModule'
         ],
            function ($routeProvider, $locationProvider, $controllerProvider) {

            $locationProvider.hashPrefix('');

            dashboardApp.controllerProvider = $controllerProvider;

            $routeProvider.when('/', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/dashboard',
                controller: dashboardController
            });

            $routeProvider.when('/alerts/widget/:widgetId', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertsByWidget',
                controller: alertsController
            });
            $routeProvider.when('/alerts/listAll', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertlist',
                controller: alertsController
            });

              $routeProvider.when('/alerts/listAll/:widgetId', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertlist',
                controller: alertsController
            });

            $routeProvider.when('/alerts/result/:alertId', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertresults',
                controller: alertsController
            });

            $routeProvider.when('/alerts/:action', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertedit',
                controller: alertsController
            });

            $routeProvider.when('/alerts/:action/:alertId', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/alertedit',
                controller: alertsController
            });

            $routeProvider.when('/conditions/listAll', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/rulelist',
                controller: alertsController
            });
            $routeProvider.when('/conditions/:action', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/ruleedit',
                controller: alertsController
            });

            $routeProvider.when('/eventlog', {
                templateUrl: MP_SITE_URL + '/dashboard/partials/eventlog',
                controller: eventsController
            });

            $routeProvider.otherwise({
                templateUrl: MP_SITE_URL + '/dashboard/partials/dashboard',
                controller: dashboardController
            });

		 // configure html5 to get links working
        // If you don't do this, you URLs will be base.com/#/home rather than base.com/home
        $locationProvider.html5Mode(true);
        }
        );

dashboardApp.factory('authHttpResponseInterceptor',['$q','$location',function($q){
    return {
        response: function(response){
            if (response.status === 401) {
                unAuthorizedHandler();
            }
            return response || $q.when(response);
        },
        responseError: function(rejection) {
            if (rejection.status === 401) {
                unAuthorizedHandler();
            }
            return $q.reject(rejection);
        }
    }
}]);

dashboardApp.config(['$httpProvider','$provide', function($httpProvider, $provide) {
    //This header was removed from recent version of angular.
    // PHP looks at this header to separate request between regular and AJAX.
    $httpProvider.defaults.headers.common["X-Requested-With"] = 'XMLHttpRequest';
    // IE fix to prevent caching
    $httpProvider.defaults.headers.common["If-Modified-Since"] = 0;
    // add interceptor to httpProvider
    $httpProvider.interceptors.push('authHttpResponseInterceptor');

    $provide.decorator('$exceptionHandler',
        ['$delegate', errorLogger]);
}]);



function errorLogger($delegate) {
    return function (exception, cause) {
        $delegate(exception, cause);
        var msg = exception.message + "\n" + exception.stack;
        globalLogger.sendErrorToServer(msg)
    };
}


dashboardApp.run(['$templateCache',function($templateCache){
       $templateCache.put("template/accordion/accordion-group.html",
      "<div class=\"accordion-default\" style=\"overflow:hidden\">\n" +
      "  <div class=\"accordion-heading\" ><a class=\"accordion-toggle\" ng-click=\"isOpen = !isOpen\" accordion-transclude=\"heading\">{{heading}}</a></div>\n" +
      "  <div class=\"accordion-collapse collapse in\" collapse=\"!isOpen\">\n" +
      "    <div class=\"accordion-body\" ng-transclude></div>  </div>\n" +
      "</div>");

       $templateCache.put("template/accordion/accordion.html",
      "<div class=\"accordion-group\" ng-transclude></div>");

    $templateCache.put("template/datepicker/datepicker.html",
        '<table>' +
          '<thead>' +
            '<tr>' +
              '<th><button type="button" class="btn btn-default btn-sm pull-left" ng-click="move(-1)"><i class="icon-chevron-left"></i></button></th>' +
              '<th colspan="{{rows[0].length - 2 + showWeekNumbers}}"><button type="button" class="btn btn-default btn-sm btn-block" ng-click="toggleMode()"><strong>{{title}}</strong></button></th>' +
              '<th><button type="button" class="btn btn-default btn-sm pull-right" ng-click="move(1)"><i class="icon-chevron-right"></i></button></th>' +
            '</tr>' +
            '<tr ng-show="labels.length > 0" class="h6">' +
              '<th ng-show="showWeekNumbers" class="text-center">#</th>' +
              '<th ng-repeat="label in labels" class="text-center">{{label}}</th>'+
            '</tr>' +
          '</thead>' +
          '<tbody>' +
            '<tr ng-repeat="row in rows">' +
              '<td ng-show="showWeekNumbers" class="text-center"><em>{{ getWeekNumber(row) }}</em></td>' +
              '<td ng-repeat="dt in row" class="text-center">' +
                '<button type="button" style="width:100%;" class="btn btn-default btn-sm" ng-class="{\'btn-info\': dt.selected}" ng-click="select(dt.date)" ng-disabled="dt.disabled"><span ng-class="{\'text-muted\': dt.secondary}">{{dt.label}}</span></button>' +
              '</td>' +
            '</tr>' +
          '</tbody>' +
        '</table>');
    }
]);
