<?php


/**
 * @uri /event 0
 */
class EventList extends CfProtectedResource
{
    /**
     * @param $request
     * @return Response
     *
     * @rbacName Get event list
     * @rbacGroup Events API
     * @rbacAlias eventList.get
     * @rbacAllowedByDefault
     */
    function get($request)
    {
        $response = new Response($request);
        $cfEvent = new CfEvent();

        $response->body = json_encode($cfEvent->getEventList(), JSON_PRETTY_PRINT);
        $response->code = Response::OK;

        return $response;
    }
}

/**
 * @uri /event/:event_id 1
 */
class Event extends CfProtectedResource
{
    /**
     * @var CfEvent
     */
    private $cfEvent;

    /**
     * Event constructor.
     * @param $parameters
     */
    public function __construct($parameters)
    {
        parent::__construct($parameters);
        $this->cfEvent = new CfEvent();
    }

    /**
     * @param $request
     * @param $event_id
     * @return Response
     *
     * @rbacName Get event
     * @rbacGroup Events API
     * @rbacAlias event.get
     * @rbacAllowedByDefault
     */
    function get($request, $event_id)
    {

        $response = new Response($request);
        $payload = $this->cfEvent->getEventById($event_id);
        if ($payload) {
            $response->code = Response::OK;
            $response->body = json_encode($payload);
        } else {
            $response->code = Response::NOTFOUND;
        }

        return $response;
    }

    /**
     * @param $request
     * @param $event_id
     * @return Response
     *
     * @rbacName Delete event
     * @rbacGroup Events API
     * @rbacAlias event.delete
     */
    function delete($request, $event_id)
    {
        $response = new Response($request);

        if ($this->cfEvent->deleteEventById($event_id)) {
            $response->code = Response::NOCONTENT;
        } else {
            $response->code = Response::INTERNALSERVERERROR;
        }

        return $response;
    }
}

/**
 * @uri /event-batch 0
 */
class EventBatchDelete extends CfProtectedResource
{

    /**
     * @param $request
     * @return Response
     * @throws ResponseException
     *
     * @rbacName Batch delete
     * @rbacGroup Events API
     * @rbacAlias eventBatchDelete.delete
     */
    function delete($request)
    {
        $response = new Response($request);
        $data = Utils::getValidJsonData($request->data);
        $cfEvent = new CfEvent();
        $cfEvent->deleteBatch($data);
        $response->code = Response::NOCONTENT;

        return $response;
    }
}