// src/LeftNav.tsx
import React from "react";
import { NavLink } from "react-router-dom";
import { List, ListItem, ListItemIcon, ListItemText, ListSubheader } from "@mui/material";
import { listItemTextClasses } from "@mui/material/ListItemText";
import { makeStyles } from "tss-react/mui";
import { isDarkMode } from "@northern.tech/store/utils";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  list: {
    [`&.navLink .${listItemTextClasses.root}`]: {
      color: isDarkMode(theme.palette.mode) ? theme.palette.text.primary : theme.palette.grey[900]
    },
    [`&.navLink.active .${listItemTextClasses.root}`]: {
      color: isDarkMode(theme.palette.mode) ? theme.palette.grey[900] : theme.palette.text.primary
    },
    "&.active": {
      background: theme.palette.grey[400]
    }
  },
  listItem: {
    [`.${listItemTextClasses.primary}`]: {
      fontSize: "0.8rem",
      "&:hover": {
        color: theme.palette.primary.main
      }
    }
  }
}));
var LeftNav = ({ sections }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsx(List, { className: "leftFixed", children: sections.map(({ itemClass = "", items = [], title = "" }, index) => /* @__PURE__ */ jsxs(React.Fragment, { children: [
    /* @__PURE__ */ jsx(ListSubheader, { disableSticky: true, children: title }),
    items.map(({ exact, path, icon = null, style = {}, title: title2 = "", url }) => {
      const props = url ? { component: "a", exact: `${exact}`, href: url, rel: "noopener", target: "_blank", to: url } : { component: NavLink, end: exact, to: path };
      return /* @__PURE__ */ jsxs(ListItem, { className: `navLink ${itemClass} ${classes.list}`, style, ...props, children: [
        /* @__PURE__ */ jsx(ListItemText, { className: classes.listItem, primary: title2, url }),
        !!icon && /* @__PURE__ */ jsx(ListItemIcon, { children: icon })
      ] }, path);
    })
  ] }, `${itemClass}-${index}`)) });
};
var LeftNav_default = LeftNav;

export {
  LeftNav,
  LeftNav_default
};
//# sourceMappingURL=chunk-YQ4WAMKG.js.map