import { SnackbarContent } from '../appSlice/index.js';
import * as axios from 'axios';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.js';
import { UserSession, User, CustomColumn, GlobalSettings, UserSettings } from './index.js';
import { PersonalAccessToken } from '@northern.tech/types/MenderTypes';
import { AuditLogPermission, DeploymentPermission, GroupsPermission, ReleasesPermission, UserManagementPermission, Role, PermissionSet } from '@northern.tech/utils/constants';
import { ReadState } from './constants.js';
import 'redux';
import 'immer';
import '@mui/material';
import 'redux-thunk';
import '../releasesSlice/index.js';
import '../organizationSlice/types.js';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.js';
import '../onboardingSlice/index.js';
import '@northern.tech/types/Alert';
import '../deploymentsSlice/index.js';
import '../devicesSlice/index.js';
import '../commonConstants.js';
import 'react/jsx-runtime';
import '../devicesSlice/constants.js';

type ThunkPermissionSet = Record<string, PermissionSet>;
type SubmittedRoleUiPermissions = {
    auditlog: AuditLogPermission[];
    deployments: DeploymentPermission[];
    groups: {
        disableEdit?: boolean;
        item: string;
        notFound?: boolean;
        uiPermissions: GroupsPermission[];
    }[];
    releases: {
        disableEdit?: boolean;
        item: string;
        notFound?: boolean;
        uiPermissions: ReleasesPermission[];
    }[];
    tenantManagement?: UserManagementPermission[];
    userManagement: UserManagementPermission[];
};
type SubmittedRole = {
    allowUserManagement?: boolean;
    description?: string;
    name: string;
    source?: Omit<SubmittedRole, 'source'>;
    uiPermissions: Partial<SubmittedRoleUiPermissions>;
};
interface LoginUserPayload {
    email: string;
    password?: string;
    stayLoggedIn?: boolean;
    token2fa?: string;
}
declare const loginUser: _reduxjs_toolkit.AsyncThunk<{
    payload: UserSession;
    type: "users/successfullyLoggedIn";
} | undefined, LoginUserPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const logoutUser: _reduxjs_toolkit.AsyncThunk<axios.AxiosResponse<any, any>, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const switchUserOrganization: _reduxjs_toolkit.AsyncThunk<void, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const passwordResetStart: _reduxjs_toolkit.AsyncThunk<axios.AxiosResponse<any, any>, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface PasswordResetPayload {
    newPassword: string;
    secretHash: string;
}
declare const passwordResetComplete: _reduxjs_toolkit.AsyncThunk<axios.AxiosResponse<any, any>, PasswordResetPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const verifyEmailStart: _reduxjs_toolkit.AsyncThunk<axios.AxiosResponse<any, any>, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const verifyEmailComplete: _reduxjs_toolkit.AsyncThunk<axios.AxiosResponse<any, any>, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const verify2FA: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<[{
    payload: User;
    type: "users/receivedUser";
}, _reduxjs_toolkit.PayloadAction<void, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, User], string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, {
    token2fa: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUserList: _reduxjs_toolkit.AsyncThunk<{
    payload: Record<string, User>;
    type: "users/receivedUserList";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUser: _reduxjs_toolkit.AsyncThunk<[{
    payload: User;
    type: "users/receivedUser";
}, _reduxjs_toolkit.PayloadAction<void, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, User], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const initializeSelf: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<[{
    payload: User;
    type: "users/receivedUser";
}, _reduxjs_toolkit.PayloadAction<void, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, User], string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface UpdateColumnSettingsPayload {
    columns?: CustomColumn[];
    currentUserId?: string;
}
declare const updateUserColumnSettings: _reduxjs_toolkit.AsyncThunk<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, UpdateColumnSettingsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface CreateUserPayload {
    email: string;
    password: string;
    shouldResetPassword?: boolean;
    sso?: boolean;
}
declare const createUser: _reduxjs_toolkit.AsyncThunk<[_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Record<string, User>;
    type: "users/receivedUserList";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], CreateUserPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeUser: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "users/removedUser";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Record<string, User>;
    type: "users/receivedUserList";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface EditUserPayload {
    current_password: string;
    email: string;
    id: string;
    password: string;
    roles?: string[];
}
declare const editUser: _reduxjs_toolkit.AsyncThunk<[{
    payload: Partial<User> & {
        id: string;
    };
    type: "users/updatedUser";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], EditUserPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const checkEmailExists: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const addUserToCurrentTenant: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Record<string, User>;
    type: "users/receivedUserList";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const enableUser2fa: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<[{
    payload: User;
    type: "users/receivedUser";
}, _reduxjs_toolkit.PayloadAction<void, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, User], string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const disableUser2fa: _reduxjs_toolkit.AsyncThunk<[_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<[{
    payload: User;
    type: "users/receivedUser";
}, _reduxjs_toolkit.PayloadAction<void, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: {
        shouldHide: boolean;
        userId?: string;
    };
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<{
    payload: CustomColumn[];
    type: "users/setCustomColumns";
}, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: UpdateColumnSettingsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, User], string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, {
    payload: string | null;
    type: "users/receivedQrCode";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const normalizeRbacRoles: (roles: Role[], rolesById: Record<string, Role>, permissionSets: ThunkPermissionSet) => {
    [x: string]: Role;
};
declare const getPermissionSets: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getRoles: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const createRole: _reduxjs_toolkit.AsyncThunk<[{
    payload: Role;
    type: "users/createdRole";
}, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], SubmittedRole, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const editRole: _reduxjs_toolkit.AsyncThunk<[{
    payload: Role;
    type: "users/createdRole";
}, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], SubmittedRole, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeRole: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "users/removedRole";
}, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getGlobalSettings: _reduxjs_toolkit.AsyncThunk<[{
    payload: GlobalSettings;
    type: "users/setGlobalSettings";
}, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, any], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const saveGlobalSettings: _reduxjs_toolkit.AsyncThunk<any[] | [any] | undefined, Partial<GlobalSettings>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUserSettings: _reduxjs_toolkit.AsyncThunk<[{
    payload: UserSettings;
    type: "users/setUserSettings";
}, any], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const saveUserSettings: _reduxjs_toolkit.AsyncThunk<unknown, Partial<UserSettings> | undefined, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const get2FAQRCode: _reduxjs_toolkit.AsyncThunk<{
    payload: string | null;
    type: "users/receivedQrCode";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setHideAnnouncement: _reduxjs_toolkit.AsyncThunk<void, {
    shouldHide: boolean;
    userId?: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getTokens: _reduxjs_toolkit.AsyncThunk<{
    payload: Partial<User> & {
        id: string;
    };
    type: "users/updatedUser";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const generateToken: _reduxjs_toolkit.AsyncThunk<[_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Partial<User> & {
        id: string;
    };
    type: "users/updatedUser";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, any], {
    expiresIn?: number;
    name: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const revokeToken: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Partial<User> & {
        id: string;
    };
    type: "users/updatedUser";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, PersonalAccessToken, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setTooltipReadState: _reduxjs_toolkit.AsyncThunk<void, {
    id: string;
    persist: boolean;
    readState: ReadState;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setAllTooltipsReadState: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    readState: string;
    tooltipIds: string[];
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type SubmitFeedbackPayload = {
    feedback: string;
    meta: any;
    satisfaction: string;
};
declare const submitFeedback: _reduxjs_toolkit.AsyncThunk<void, SubmitFeedbackPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { type SubmittedRole, addUserToCurrentTenant, checkEmailExists, createRole, createUser, disableUser2fa, editRole, editUser, enableUser2fa, generateToken, get2FAQRCode, getGlobalSettings, getPermissionSets, getRoles, getTokens, getUser, getUserList, getUserSettings, initializeSelf, loginUser, logoutUser, normalizeRbacRoles, passwordResetComplete, passwordResetStart, removeRole, removeUser, revokeToken, saveGlobalSettings, saveUserSettings, setAllTooltipsReadState, setHideAnnouncement, setTooltipReadState, submitFeedback, switchUserOrganization, updateUserColumnSettings, verify2FA, verifyEmailComplete, verifyEmailStart };
