import "../chunk-424PT5DM.js";

// src/forms/CountrySelect.tsx
import { useEffect, useState } from "react";
import { Controller, useFormContext } from "react-hook-form";
import { Autocomplete, TextField } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { countries } from "@northern.tech/store/constants";
import { jsx } from "react/jsx-runtime";
var useStyles = makeStyles()(() => ({
  autocomplete: { width: 400 }
}));
var CountrySelect = (props) => {
  const { id, onChange, defaultValue, ...restProps } = props;
  const { classes } = useStyles();
  return /* @__PURE__ */ jsx(
    Autocomplete,
    {
      getOptionLabel: (option) => option.label,
      options: countries,
      className: classes.autocomplete,
      autoHighlight: true,
      renderInput: (params) => /* @__PURE__ */ jsx(TextField, { ...params, label: "Country", id: id || "country" }),
      onChange: (e, data) => onChange(data),
      ...restProps,
      defaultValue: countries.find((country) => country.code === defaultValue)
    },
    defaultValue
  );
};
var ControlledCountrySelect = ({ control, id, required }) => {
  const [defaultCountry, setDefaultCountry] = useState("");
  const { getValues } = useFormContext();
  const values = getValues();
  useEffect(() => {
    setDefaultCountry(values.country);
  }, []);
  return /* @__PURE__ */ jsx(
    Controller,
    {
      rules: { required },
      render: ({ field: { onChange }, formState, fieldState, ...props }) => /* @__PURE__ */ jsx(CountrySelect, { defaultValue: defaultCountry, onChange, id, ...props }),
      name: "country",
      control
    }
  );
};
export {
  ControlledCountrySelect,
  CountrySelect
};
//# sourceMappingURL=CountrySelect.js.map