"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/FileUpload.tsx
var FileUpload_exports = {};
__export(FileUpload_exports, {
  FileUpload: () => FileUpload,
  default: () => FileUpload_default
});
module.exports = __toCommonJS(FileUpload_exports);
var import_react = require("react");
var import_react_dropzone = __toESM(require("react-dropzone"), 1);
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var { setSnackbar } = import_actions.default;
var FileUpload = ({ enableContentReading = true, fileNameSelection, onFileChange, onFileSelect = () => void 0, placeholder, style = {} }) => {
  const [filename, setFilename] = (0, import_react.useState)(fileNameSelection);
  const dispatch = (0, import_react_redux.useDispatch)();
  const onDrop = (acceptedFiles, rejectedFiles) => {
    if (acceptedFiles.length) {
      if (enableContentReading) {
        const reader = new FileReader();
        reader.readAsBinaryString(acceptedFiles[0]);
        reader.fileName = acceptedFiles[0].name;
        reader.onload = () => {
          const str = reader.result.replace(/\n|\r/g, "\n");
          onFileChange(str);
        };
        reader.onerror = (error) => {
          console.log("Error: ", error);
          setFilename();
        };
      }
      setFilename(acceptedFiles[0].name);
      onFileSelect(acceptedFiles[0]);
    }
    if (rejectedFiles.length) {
      dispatch(setSnackbar(`File '${rejectedFiles[0].name}' was rejected.`));
    }
  };
  const onClear = () => {
    onFileChange();
    onFileSelect();
    setFilename();
  };
  return filename ? /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { style, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.TextField, { id: "keyfile", value: filename, disabled: true, style: { color: "rgba(0, 0, 0, 0.8)", borderBottom: "1px solid rgb(224, 224, 224)" } }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { style: { top: "6px" }, onClick: onClear, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Clear, {}) })
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { style, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_dropzone.default, { activeClassName: "active", rejectClassName: "active", multiple: false, onDrop, children: ({ getRootProps, getInputProps }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { ...getRootProps(), style: { padding: 15 }, className: "dropzone onboard dashboard-placeholder flexbox centered", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("input", { ...getInputProps() }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.CloudUploadOutlined, { className: "icon", style: { height: 24, width: 24, verticalAlign: "middle", marginTop: "-2px" } }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "margin-left-small", style: { fontSize: "11pt" }, children: placeholder })
  ] }) }) });
};
var FileUpload_default = FileUpload;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FileUpload
});
//# sourceMappingURL=FileUpload.cjs.map