import {
  BaseDialog
} from "./chunk-G4SBL2PI.js";

// src/ConfirmModal.tsx
import { useState } from "react";
import { Button, DialogActions, DialogContent, DialogContentText, TextField } from "@mui/material";
import { jsx, jsxs } from "react/jsx-runtime";
var ConfirmModal = (props) => {
  const { close, onConfirm, className = "", toType, header, description, open, maxWidth = "xs" } = props;
  const [inputValue, setInputValue] = useState("");
  return /* @__PURE__ */ jsxs(
    BaseDialog,
    {
      title: header,
      className,
      open,
      onClose: close,
      maxWidth,
      slotProps: {
        paper: {
          component: "form",
          onSubmit: (event) => {
            event.preventDefault();
            onConfirm();
            close();
          }
        }
      },
      children: [
        /* @__PURE__ */ jsxs(DialogContent, { children: [
          /* @__PURE__ */ jsx(DialogContentText, { className: "margin-bottom-small", children: description }),
          /* @__PURE__ */ jsxs(DialogContentText, { className: "margin-bottom-small", children: [
            "Type '",
            toType,
            "' below to continue"
          ] }),
          /* @__PURE__ */ jsx(
            TextField,
            {
              value: inputValue,
              onChange: (e) => setInputValue(e.target.value),
              autoFocus: true,
              required: true,
              name: "confirmation-text",
              id: "confirmation-text",
              label: toType,
              type: "text"
            }
          )
        ] }),
        /* @__PURE__ */ jsxs(DialogActions, { children: [
          /* @__PURE__ */ jsx(Button, { onClick: close, size: "small", children: "Cancel" }),
          /* @__PURE__ */ jsx(Button, { color: "secondary", type: "submit", variant: "contained", disabled: inputValue !== toType, size: "small", children: "Confirm" })
        ] })
      ]
    }
  );
};

export {
  ConfirmModal
};
//# sourceMappingURL=chunk-33AXH2JB.js.map