declare const commonProcessor: (searchParams: any) => {
    pageState: {};
    params: URLSearchParams;
    sort: {} | undefined;
};
declare const parseDeviceQuery: (searchParams: any, extraProps?: {}) => {
    open: boolean;
    detailsTab: string | null;
    filters: unknown[];
    groupName: string;
} | {
    open?: undefined;
    detailsTab: string | null;
    filters: unknown[];
    groupName: string;
};
declare const formatPageState: ({ selectedId, selectedIssues, page, perPage, sort }: {
    selectedId: any;
    selectedIssues: any;
    page: any;
    perPage: any;
    sort: any;
}, { defaults }: {
    defaults: any;
}) => string;
declare const formatDeviceSearch: ({ pageState, filters, selectedGroup }: {
    pageState: any;
    filters: any;
    selectedGroup: any;
}) => string;
declare const generateDevicePath: ({ pageState }: {
    pageState: any;
}) => string;
declare const formatAuditlogs: ({ pageState }: {
    pageState: any;
}, { today, tonight }: {
    today: any;
    tonight: any;
}) => string;
declare const parseDateParams: (params: any, today: any, tonight: any) => {
    endDate: any;
    startDate: any;
};
declare const parseAuditlogsQuery: (params: any, { today, tonight }: {
    today: any;
    tonight: any;
}) => {
    detail: any;
    endDate: any;
    startDate: any;
    type: {
        title: string;
        queryParameter: string;
        value: string;
    } | undefined;
    user: any;
};
declare const formatDeployments: ({ deploymentObject, pageState }: {
    deploymentObject: any;
    pageState: any;
}, { defaults, today, tonight }: {
    defaults: any;
    today: any;
    tonight: any;
}) => string;
declare const parseDeploymentsQuery: (params: any, { pageState, location, tonight }: {
    pageState: any;
    location: any;
    tonight: any;
}) => {
    deploymentObject: {};
    general: {
        showCreationDialog: boolean;
        showReportDialog: boolean;
        state: any;
    };
};
declare const generateDeploymentsPath: ({ pageState }: {
    pageState: any;
}) => string;
interface FormatReleasesParams {
    pageState: {
        searchTerm?: string;
        selectedTags?: string[];
        tab?: string;
        type?: string;
    };
}
declare const formatReleases: ({ pageState: { searchTerm, selectedTags, tab, type } }: FormatReleasesParams) => string;
declare const generateReleasesPath: ({ pageState: { selectedRelease } }: {
    pageState: {
        selectedRelease: any;
    };
}) => string;
declare const parseReleasesQuery: (queryParams: any, extraProps: any) => {
    searchTerm: any;
    selectedRelease: string;
    tab: any;
    tags: any;
    type: any;
};
declare const generateTenantPath: ({ pageState: { selectedTenant } }: {
    pageState: {
        selectedTenant: any;
    };
}) => string;
declare const generateTenantPathById: (id: any) => string;
declare const parseTenantsQuery: (queryParams: any, extraProps: any) => {
    name: any;
    selectedTenant: any;
};
declare const formatTenants: () => string;

export { type FormatReleasesParams, commonProcessor, formatAuditlogs, formatDeployments, formatDeviceSearch, formatPageState, formatReleases, formatTenants, generateDeploymentsPath, generateDevicePath, generateReleasesPath, generateTenantPath, generateTenantPathById, parseAuditlogsQuery, parseDateParams, parseDeploymentsQuery, parseDeviceQuery, parseReleasesQuery, parseTenantsQuery };
