import { Card, AuditLogSelectionState, TenantList, SSOConfig } from './types.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.js';
import { SnackbarContent } from '../appSlice/index.js';
import { BillingProfile, NewTenant, PreviewRequest, Product, SupportRequest, Integration } from '@northern.tech/types/MenderTypes';
import { SortOptions } from '@northern.tech/utils/constants';
import { locations, AvailablePlans } from '../appSlice/constants.js';
import { ContentType } from './constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import 'redux-thunk';
import 'redux';
import '../usersSlice/constants.js';
import '../usersSlice/index.js';
import 'immer';
import '../commonConstants.js';
import 'react/jsx-runtime';
import '../releasesSlice/index.js';
import '../onboardingSlice/index.js';
import '@northern.tech/types/Alert';
import '../deploymentsSlice/index.js';
import '../devicesSlice/index.js';
import '../devicesSlice/constants.js';

declare const cancelRequest: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getTargetLocation: (key: string) => string;
type OrganizationTrialPayload = {
    email: string;
    'g-recaptcha-response': string;
    location: keyof typeof locations;
    name: string;
    organization: string;
    password: string;
    plan: string;
    tos: boolean;
    ts?: number;
};
declare const createOrganizationTrial: _reduxjs_toolkit.AsyncThunk<void, OrganizationTrialPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const startCardUpdate: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const confirmCardUpdate: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    payload: string | null;
    type: "organization/receiveSetupIntent";
}], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getCurrentCard: _reduxjs_toolkit.AsyncThunk<{
    payload: Card;
    type: "organization/receiveCurrentCard";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const startUpgrade: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const cancelUpgrade: _reduxjs_toolkit.AsyncThunk</*elided*/ any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface completeUpgradePayload {
    billing_profile: BillingProfile;
    plan: AvailablePlans;
    tenantId: string;
}
declare const completeUpgrade: _reduxjs_toolkit.AsyncThunk<[_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: number;
    type: "devices/setDeviceLimit";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<any[], string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], completeUpgradePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type AuditLogQuery = {
    detail?: {
        id: string;
    } | string;
    endDate?: string;
    sort?: SortOptions;
    startDate?: string;
    type?: {
        queryParameter: string;
        title: string;
        value: string;
    } | null;
    user?: {
        id: string;
    } | string;
};
type GetAuditLogPayload = {
    page: number;
    perPage: number;
} & AuditLogQuery;
declare const getAuditLogs: _reduxjs_toolkit.AsyncThunk<any, GetAuditLogPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getAuditLogsCsvLink: _reduxjs_toolkit.AsyncThunk<string, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setAuditlogsState: _reduxjs_toolkit.AsyncThunk<any[], Partial<AuditLogSelectionState>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const tenantDataDivergedMessage = "The system detected there is a change in your plan or purchased add-ons. Please log out and log in again";
declare const addTenant: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, unknown], NewTenant, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getTenants: _reduxjs_toolkit.AsyncThunk<void, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setTenantsListState: _reduxjs_toolkit.AsyncThunk<{
    payload: TenantList;
    type: "organization/setTenantListState";
}, Partial<TenantList>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface editTenantBody {
    id: string;
    name: string;
    newLimit: number;
}
declare const editTenantDeviceLimit: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<any[], string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, unknown], editTenantBody, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const editBillingProfile: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: BillingProfile;
    type: "organization/setBillingProfile";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    billingProfile: BillingProfile;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const createBillingProfile: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: BillingProfile;
    type: "organization/setBillingProfile";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    billingProfile: BillingProfile;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeTenant: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<any[], string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, unknown], {
    id: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUserOrganization: _reduxjs_toolkit.AsyncThunk<any[], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUserBilling: _reduxjs_toolkit.AsyncThunk<{
    payload: BillingProfile;
    type: "organization/setBillingProfile";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getUserSubscription: _reduxjs_toolkit.AsyncThunk<void, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getBillingPreview: _reduxjs_toolkit.AsyncThunk<any, PreviewRequest, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getCurrentSubscription: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const requestPlanUpgrade: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, NodeJS.Timeout, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<any[], string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    plan: string;
    products: Product[];
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const sendSupportMessage: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, SupportRequest, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface requestPlanChangePayload {
    content: {
        current_addons: string;
        current_plan: string;
        requested_addons: string;
        requested_plan: string;
        user_message: string;
    };
    tenantId: string;
}
declare const requestPlanChange: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, requestPlanChangePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const downloadLicenseReport: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const createIntegration: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Integration[];
    type: "organization/receiveExternalDeviceIntegrations";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], Integration, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const changeIntegration: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: Integration[];
    type: "organization/receiveExternalDeviceIntegrations";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], Integration, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const deleteIntegration: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    payload: Integration[];
    type: "organization/receiveExternalDeviceIntegrations";
}], {
    id: string;
} & Integration, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getIntegrations: _reduxjs_toolkit.AsyncThunk<{
    payload: Integration[];
    type: "organization/receiveExternalDeviceIntegrations";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type GetWebhookEventsPayload = {
    isFollowUp?: boolean;
    page?: number;
    perPage?: number;
};
declare const getWebhookEvents: _reduxjs_toolkit.AsyncThunk<any[], GetWebhookEventsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const storeSsoConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: SSOConfig[];
    type: "organization/receiveSsoConfigs";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    config: string;
    contentType: ContentType;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const changeSsoConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: SSOConfig[];
    type: "organization/receiveSsoConfigs";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    config: SSOConfig;
    contentType: ContentType;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const deleteSsoConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    payload: SSOConfig[];
    type: "organization/receiveSsoConfigs";
}], SSOConfig, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getSsoConfigById: _reduxjs_toolkit.AsyncThunk<any, SSOConfig, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getSsoConfigs: _reduxjs_toolkit.AsyncThunk<{
    payload: SSOConfig[];
    type: "organization/receiveSsoConfigs";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { addTenant, cancelRequest, cancelUpgrade, changeIntegration, changeSsoConfig, completeUpgrade, confirmCardUpdate, createBillingProfile, createIntegration, createOrganizationTrial, deleteIntegration, deleteSsoConfig, downloadLicenseReport, editBillingProfile, editTenantDeviceLimit, getAuditLogs, getAuditLogsCsvLink, getBillingPreview, getCurrentCard, getCurrentSubscription, getIntegrations, getSsoConfigById, getSsoConfigs, getTargetLocation, getTenants, getUserBilling, getUserOrganization, getUserSubscription, getWebhookEvents, removeTenant, requestPlanChange, requestPlanUpgrade, sendSupportMessage, setAuditlogsState, setTenantsListState, startCardUpdate, startUpgrade, storeSsoConfig, tenantDataDivergedMessage };
