"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/releasesSlice/mocks.ts
var mocks_exports = {};
__export(mocks_exports, {
  mockState: () => mockState
});
module.exports = __toCommonJS(mocks_exports);

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/releasesSlice/index.ts
var import_toolkit = require("@reduxjs/toolkit");
var sliceName = "releases";
var initialState = {
  /*
   * Return list of saved artifacts objects
   */
  /*
   * return list of artifacts where duplicate names are collated with device compatibility lists combined
   */
  // artifacts: AppStore.getCollatedArtifacts(AppStore.getArtifactsRepo()),
  artifacts: [],
  /*
   * Return list of saved release objects
   */
  byId: {
    /*
    [releaseName]: {
      artifacts: [
        {
          id: '',
          name: '',
          description: '',
          device_types_compatible: [],
          ...
          updates: [{
            files: [
              { size: 123, name: '' }
            ],
            type_info: { type: '' }
          }],
          url: '' // optional
        }
      ],
      modified: ''
      device_types_compatible,
      name: '',
      tags: ['something'],
      notes: ''
    }
    */
  },
  releasesList: {
    ...import_constants.DEVICE_LIST_DEFAULTS,
    searchedIds: [],
    releaseIds: [],
    selection: [],
    sort: {
      direction: import_constants.SORTING_OPTIONS.desc,
      key: "modified"
    },
    isLoading: void 0,
    searchTerm: "",
    searchTotal: 0,
    selectedTags: [],
    total: 0,
    type: ""
  },
  tags: [],
  updateTypes: [],
  /*
   * Return single release with corresponding Artifacts
   */
  selectedRelease: null
};
var releaseSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    receiveRelease: (state, action) => {
      const { name } = action.payload;
      state.byId[name] = action.payload;
    },
    receiveReleases: (state, action) => {
      state.byId = action.payload;
    },
    receiveReleaseTags: (state, action) => {
      state.tags = action.payload;
    },
    receiveReleaseTypes: (state, action) => {
      state.updateTypes = action.payload;
    },
    removeRelease: (state, action) => {
      const { [action.payload]: toBeRemoved, ...byId } = state.byId;
      state.byId = byId;
      state.selectedRelease = action.payload === state.selectedRelease ? null : state.selectedRelease;
    },
    selectedRelease: (state, action) => {
      state.selectedRelease = action.payload;
    },
    setReleaseListState: (state, action) => {
      state.releasesList = action.payload;
    }
  }
});
var actions = releaseSlice.actions;
var releasesSlice_default = releaseSlice.reducer;

// src/releasesSlice/mocks.ts
var deviceTypes = { qemu: "qemux86-64" };
var mockState = {
  ...initialState,
  byId: {
    r1: {
      name: "r1",
      artifacts: [
        {
          id: "art1",
          description: "test description",
          device_types_compatible: [deviceTypes.qemu],
          modified: "2020-09-10T12:16:22.667Z",
          updates: [{ type_info: "testtype" }],
          artifact_depends: {
            device_type: [deviceTypes.qemu]
          },
          artifact_provides: {
            artifact_name: "myapp",
            "data-partition.myapp.version": "v2020.10",
            list_of_fancy: [deviceTypes.qemu, "x172"]
          },
          clears_artifact_provides: ["data-partition.myapp.*"]
        }
      ],
      device_types_compatible: [deviceTypes.qemu],
      modified: "2020-09-10T12:16:22.667Z",
      metaData: {}
    }
  },
  releasesList: {
    ...import_constants.DEVICE_LIST_DEFAULTS,
    searchedIds: [],
    isLoading: false,
    releaseIds: ["r1"],
    selection: [],
    sort: {
      direction: import_constants.SORTING_OPTIONS.desc,
      key: "name"
    },
    searchTerm: "",
    searchTotal: 0,
    total: 1
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  mockState
});
//# sourceMappingURL=mocks.cjs.map