<?php

namespace Controllers;

use models\compositers\UsersCompositor;
use models\dataMappers\UserMapper;
use models\LdapUser;
use models\LdapUserAdapter;
use models\UsersDataMapper;
use Services\Ldap\Implementations\Ldap;
use Slim\Http\Request;

class UserController extends ProtectedController
{


    /**
     * @param Request $request
     * @param $response
     * @return mixed
     */
    public function getUserList(Request $request, $response)
    {
        $config = $this->container->get('ldap');

        $ldapService = new Ldap($config);

        $searchArr = [];
        if ($request->getParam('search')) {
            $searchArr = ['searchKey' => $config['login_attribute'], 'searchValue' => $request->getParam('search')];
        }

        $page = intval($request->getParam('page') == 0 ? 0 : $request->getParam('page') - 1);
        $perPage = intval($request->getParam('perPage') ?? 25);

        $users = $ldapService->getUsersList($searchArr);

        $offset = ($page) * $perPage;
        $pageData = array_slice($users->toArray(), $offset, $perPage);

        $usersCompositor = new UsersCompositor($pageData, new LdapUserAdapter($config));
        $usersToReturn = $usersCompositor->map();


        $data = [
            'success' => true,
            'data' => $usersToReturn,
            'meta' => [
                'page' => $page + 1,
                'total' => sizeof($users),
                'count' => sizeof($pageData),
                'timestamp' => time(),
            ]
        ];

        $response = $response->withJson($data);
        return $response;
    }
    
    public function getUserListByUsernames(Request $request, $response)
    {
        $config = $this->container->get('ldap');
        $ldapService = new Ldap($config);
        $usernames = $request->getParam('usernames', []);

        if (!is_array($usernames) || empty($usernames)) {
            throw new \InvalidArgumentExceptin('parameter usernames must be a non-empty array');
        }

        $users = $ldapService->getUsersByUsernames($usernames);
        $usersCompositor = new UsersCompositor($users->toArray(), new LdapUserAdapter($config));
        $usersToReturn = $usersCompositor->map();

        $data = [
            'success' => true,
            'data' => $usersToReturn,
            'meta' => [
                'total' => sizeof($users),
                'timestamp' => time(),
            ]
        ];

        $response = $response->withJson($data);
        return $response;
    }
}
