import {
  Loader_default
} from "./chunk-3AOVUJ7W.js";

// src/Search.tsx
import { useCallback, useEffect, useRef } from "react";
import { Controller, FormProvider, useForm, useFormContext } from "react-hook-form";
import { Search as SearchIcon } from "@mui/icons-material";
import { InputAdornment, TextField } from "@mui/material";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { useDebounce } from "@northern.tech/utils/debouncehook";
import { jsx, jsxs } from "react/jsx-runtime";
var endAdornment = /* @__PURE__ */ jsx(InputAdornment, { position: "end", children: /* @__PURE__ */ jsx(Loader_default, { show: true, small: true, style: { marginTop: -10 } }) });
var startAdornment = /* @__PURE__ */ jsx(InputAdornment, { position: "start", children: /* @__PURE__ */ jsx(SearchIcon, { color: "disabled", fontSize: "small" }) });
var MINIMUM_SEARCH_LENGTH = 2;
var ControlledSearch = ({ className = "", isSearching, name = "search", onSearch, placeholder = "Search devices", style = {} }) => {
  const { control, watch } = useFormContext();
  const inputRef = useRef();
  const focusLockRef = useRef(true);
  const timer = useRef();
  const triggerDebounceRef = useRef(false);
  const searchValue = watch(name, "");
  const debouncedSearchTerm = useDebounce(searchValue, TIMEOUTS.debounceDefault);
  const focusAndLock = () => {
    focusLockRef.current = false;
    inputRef.current.focus();
    clearTimeout(timer.current);
    triggerDebounceRef.current = false;
    timer.current = setTimeout(() => focusLockRef.current = true, TIMEOUTS.oneSecond);
  };
  useEffect(
    () => () => {
      clearTimeout(timer.current);
    },
    []
  );
  useEffect(() => {
    if (debouncedSearchTerm.length < MINIMUM_SEARCH_LENGTH || triggerDebounceRef.current) {
      return;
    }
    triggerDebounceRef.current = true;
    onSearch(debouncedSearchTerm).then(focusAndLock);
  }, [debouncedSearchTerm, onSearch]);
  const onTriggerSearch = useCallback(
    ({ key }) => {
      if (key === "Enter" && (!debouncedSearchTerm || debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH)) {
        onSearch(debouncedSearchTerm).then(focusAndLock);
      }
    },
    [debouncedSearchTerm, onSearch]
  );
  const onFocus = useCallback(() => {
    if (focusLockRef.current && debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH) {
      onSearch(debouncedSearchTerm).then(focusAndLock);
    }
  }, [debouncedSearchTerm, onSearch]);
  const adornments = isSearching ? { startAdornment, endAdornment } : { startAdornment };
  return /* @__PURE__ */ jsx(
    Controller,
    {
      name,
      control,
      render: ({ field }) => /* @__PURE__ */ jsx(
        TextField,
        {
          className,
          slotProps: { input: adornments },
          onKeyUp: onTriggerSearch,
          onFocus,
          placeholder,
          inputRef,
          size: "small",
          style,
          ...field
        }
      )
    }
  );
};
ControlledSearch.displayName = "ConnectedSearch";
var Search = (props) => {
  const { className = "", searchTerm, onSearch, trigger } = props;
  const methods = useForm({ mode: "onChange", defaultValues: { search: searchTerm ?? "" } });
  const { handleSubmit } = methods;
  const onSubmit = useCallback((search) => onSearch(search, !trigger), [onSearch, trigger]);
  return /* @__PURE__ */ jsx(FormProvider, { ...methods, children: /* @__PURE__ */ jsxs("form", { className, noValidate: true, onSubmit: handleSubmit(({ search }) => onSearch(search, !trigger)), children: [
    /* @__PURE__ */ jsx(ControlledSearch, { ...props, onSearch: onSubmit }),
    /* @__PURE__ */ jsx("input", { className: "hidden", type: "submit" })
  ] }) });
};
var Search_default = Search;

export {
  ControlledSearch,
  Search_default
};
//# sourceMappingURL=chunk-67ILUKD7.js.map