"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dialogs/index.ts
var dialogs_exports = {};
__export(dialogs_exports, {
  ConfirmDismissHelptips: () => ConfirmDismissHelptips,
  FeedbackDialog: () => FeedbackDialog,
  LogDialog: () => LogDialog,
  StartupNotificationDialog: () => StartupNotificationDialog
});
module.exports = __toCommonJS(dialogs_exports);

// src/dialogs/ConfirmDismissHelpTips.tsx
var import_material2 = require("@mui/material");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_store = require("@northern.tech/store/store");
var import_thunks = require("@northern.tech/store/thunks");

// src/dialogs/BaseDialog.tsx
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var BaseDialog = (props) => {
  const { children, onClose, title, ...dialogProps } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.Dialog, { ...dialogProps, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.DialogTitle, { children: title }),
    children
  ] });
};

// src/dialogs/ConfirmDismissHelpTips.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var { setShowDismissOnboardingTipsDialog } = import_actions.default;
var ConfirmDismissHelptips = () => {
  const dispatch = (0, import_store.useAppDispatch)();
  const onClose = () => dispatch((0, import_thunks.setOnboardingCanceled)());
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(BaseDialog, { open: true, title: "Dismiss the Getting Started help?", onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.DialogContent, { children: "Hide the help tips? You haven't finished your first update yet." }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.DialogActions, { className: "flexbox space-between", children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { onClick: () => dispatch(setShowDismissOnboardingTipsDialog(false)), children: "Cancel" }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { variant: "contained", color: "secondary", onClick: onClose, children: "Yes, hide the help" })
    ] })
  ] });
};

// src/dialogs/Feedback.tsx
var import_react = require("react");
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material3 = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_actions2 = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_thunks2 = require("@northern.tech/store/thunks");
var import_utils = require("@northern.tech/store/utils");
var import_jsx_runtime3 = require("react/jsx-runtime");
var { setShowFeedbackDialog } = import_actions2.default;
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  root: {
    pointerEvents: "none",
    [`.${import_material3.dialogClasses.paper}`]: { width: 350, bottom: 0, right: 0, position: "absolute" },
    [`.${import_material3.dialogTitleClasses.root}`]: {
      alignSelf: "flex-end",
      padding: 0,
      [`.${import_material3.iconButtonClasses.root}`]: { marginBottom: theme.spacing(-1) }
    },
    ".title": {
      color: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material3.lighten)(theme.palette.primary.main, 0.85) : "inherit"
    }
  },
  columns: { gap: theme.spacing(2) },
  rating: {
    [`.${import_material3.iconButtonClasses.root}`]: {
      borderRadius: theme.shape.borderRadius,
      height: theme.spacing(6),
      width: theme.spacing(6),
      backgroundColor: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material3.darken)(theme.palette.primary.main, 0.45) : (0, import_material3.lighten)(theme.palette.primary.main, 0.85),
      color: theme.palette.primary.main,
      "&:hover": {
        backgroundColor: theme.palette.primary.main,
        color: (0, import_material3.lighten)(theme.palette.primary.main, 0.85)
      }
    }
  },
  text: { [`.${import_material3.textFieldClasses.root}`]: { marginTop: 0 }, ".submitButton": { alignSelf: "start" } }
}));
var satisfactionLevels = [
  { Icon: import_icons_material.SentimentVeryDissatisfiedOutlined, title: "Very Dissatisfied" },
  { Icon: import_icons_material.SentimentVeryDissatisfied, title: "Dissatisfied" },
  { Icon: import_icons_material.SentimentNeutral, title: "Neutral" },
  { Icon: import_icons_material.SentimentSatisfiedAlt, title: "Satisfied" },
  { Icon: import_icons_material.SentimentVerySatisfiedOutlined, title: "Very Satisfied" }
];
var explanations = ["Very unsatisfied", "Very satisfied"];
var SatisfactionGauge = ({ classes, setSatisfaction }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: `flexbox column ${classes.columns}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "title", children: "How satisfied are you with Mender?" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: `flexbox space-between ${classes.rating}`, children: satisfactionLevels.map(({ Icon, title }, index) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.IconButton, { onClick: () => setSatisfaction(index), title, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Icon, { fontSize: "large" }) }, `satisfaction-${index}`)) }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "flexbox space-between muted", children: explanations.map((explanation, index) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "slightly-smaller", children: explanation }, `explanation-${index}`)) })
] });
var TextEntry = ({ classes, feedback, onChangeFeedback, onSubmit }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: `flexbox column ${classes.columns} ${classes.text}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "title", children: "What do you think is the most important thing to improve in Mender? (optional)" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_material3.TextField,
    {
      placeholder: "Your feedback",
      multiline: true,
      minRows: 4,
      onChange: ({ target: { value } }) => onChangeFeedback(value),
      value: feedback,
      variant: "outlined"
    }
  ),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.Button, { className: "submitButton", variant: "contained", onClick: onSubmit, children: "Submit Feedback" })
] });
var AppreciationNote = () => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("p", { className: "margin-top-none align-center title", children: "Thank you for taking the time to share your thoughts!" });
var progressionLevels = [SatisfactionGauge, TextEntry, AppreciationNote];
var FeedbackDialog = () => {
  const [progress, setProgress] = (0, import_react.useState)(0);
  const [satisfaction, setSatisfaction] = (0, import_react.useState)(-1);
  const [feedback, setFeedback] = (0, import_react.useState)("");
  const dispatch = (0, import_react_redux.useDispatch)();
  const isInitialized = (0, import_react.useRef)(false);
  const { classes } = useStyles();
  (0, import_react.useEffect)(() => {
    if (!isInitialized.current) {
      return;
    }
    setProgress((current) => current + 1);
  }, [satisfaction]);
  (0, import_react.useEffect)(() => {
    setTimeout(() => isInitialized.current = true, import_constants.TIMEOUTS.oneSecond);
  }, []);
  const onCloseClick = () => dispatch(setShowFeedbackDialog(false));
  const onSubmit = () => {
    setProgress(progress + 1);
    dispatch((0, import_thunks2.submitFeedback)({ satisfaction: satisfactionLevels[satisfaction].title, feedback }));
  };
  const Component = progressionLevels[progress];
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_material3.Dialog, { className: classes.root, open: true, hideBackdrop: true, disableEnforceFocus: true, PaperProps: { style: { pointerEvents: "auto" } }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.DialogTitle, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.IconButton, { onClick: onCloseClick, "aria-label": "close", size: "small", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.Close, {}) }) }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.DialogContent, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { classes, feedback, setSatisfaction, onChangeFeedback: setFeedback, onSubmit }) })
  ] });
};

// src/dialogs/Log.tsx
var import_react3 = require("react");
var import_react_copy_to_clipboard2 = __toESM(require("react-copy-to-clipboard"), 1);
var import_material5 = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");

// src/CopyCode.tsx
var import_react2 = require("react");
var import_react_copy_to_clipboard = __toESM(require("react-copy-to-clipboard"), 1);
var import_icons_material2 = require("@mui/icons-material");
var import_material4 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_constants2 = require("@northern.tech/store/constants");
var import_jsx_runtime4 = require("react/jsx-runtime");
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  code: {
    border: "1px solid",
    borderColor: theme.palette.background.lightgrey,
    backgroundColor: theme.palette.background.lightgrey
  }
}));
var Code = ({ className = "", children, style = {} }) => {
  const { classes } = useStyles2();
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: `code ${classes.code} ${className}`, style, children });
};

// src/dialogs/Log.tsx
var import_jsx_runtime5 = require("react/jsx-runtime");
var wrapperStyle = { marginRight: 10, display: "inline-block" };
var dialogTypes = {
  "deviceLog": {
    title: "Deployment log for device",
    filename: ({ device, releaseName, date }) => `deployment-log-${device}-${releaseName}-${date}.log`
  },
  "configUpdateLog": {
    title: "Config update log for device",
    filename: () => "configuration-update.log"
  }
};
var LogDialog = ({ context = {}, logData = "", onClose, type = "deviceLog" }) => {
  const [copied, setCopied] = (0, import_react3.useState)(false);
  const exportLog = () => (0, import_helpers.createFileDownload)(logData, dialogTypes[type].filename(context), "");
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(BaseDialog, { open: true, title: dialogTypes[type].title, maxWidth: "lg", onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_material5.DialogContent, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(Code, { className: "log", children: logData }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("p", { style: { marginLeft: 24 }, children: copied && /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_material5.DialogActions, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("div", { style: wrapperStyle, children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { onClick: onClose, children: "Cancel" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_react_copy_to_clipboard2.default, { style: wrapperStyle, text: logData, onCopy: () => setCopied(true), children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { children: "Copy to clipboard" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { variant: "contained", color: "primary", onClick: exportLog, children: "Export log" })
    ] })
  ] });
};

// src/dialogs/StartupNotification.tsx
var import_react4 = require("react");
var import_react_redux2 = require("react-redux");
var import_material6 = require("@mui/material");
var import_actions3 = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants3 = require("@northern.tech/store/constants");
var import_selectors = require("@northern.tech/store/selectors");
var import_thunks3 = require("@northern.tech/store/thunks");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// ../../assets/img/headerlogo.png
var headerlogo_default = "../headerlogo-QQW3XP5Y.png";

// ../../assets/img/whiteheaderlogo.png
var whiteheaderlogo_default = "../whiteheaderlogo-76DNCTF3.png";

// src/SupportLink.tsx
var import_jsx_runtime6 = require("react/jsx-runtime");
var variants = {
  email: "support@mender.io",
  ourTeam: "contact our team",
  support: "contact support",
  salesTeam: "contact our sales team"
};
var SupportLink = ({ className = "", variant }) => /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("a", { className, href: "mailto:support@mender.io", target: "_blank", rel: "noopener noreferrer", children: variants[variant] ?? variant });

// src/dialogs/StartupNotification.tsx
var import_jsx_runtime7 = require("react/jsx-runtime");
var { setShowStartupNotification } = import_actions3.default;
var OfflineThresholdContent = () => /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_jsx_runtime7.Fragment, { children: [
  "In our continuous efforts to enhance performance and to ensure the stability of our service, we have made adjustments to how granular device connectivity can be checked.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("h4", { children: "What's changing:" }),
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("ul", { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("li", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("i", { children: "Offline threshold" }),
    " setting: if a device no longer connects with the server, it may take up to 1 day until it is shown as an offline device in the UI."
  ] }) }),
  "More granular connectivity information will still be reflected in the device details.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("h4", { children: "Why are we changing this:" }),
  /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("ul", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("li", { children: "Performance Improvements: Less frequent updates allow us to better optimize the platform and improve overall performance." }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("li", { children: "Stability: This change helps ensure that our backend will remain stable while serving an ever growing number of devices and potential disruptions are minimized." })
  ] }),
  "We appreciate your understanding and cooperation as we implement these improvements. Our commitment to providing you with a reliable and high-performing platform remains our top priority.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.Divider, { className: "margin-top-small margin-bottom-small" }),
  "If you have any questions or concerns regarding this change, please do not hesitate to ",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(SupportLink, { variant: "ourTeam" }),
  "."
] });
var notifications = {
  offlineThreshold: {
    Content: OfflineThresholdContent,
    action: ({ dispatch }) => dispatch((0, import_thunks3.saveGlobalSettings)({ offlineThreshold: { interval: 1, intervalUnit: import_constants3.DEVICE_ONLINE_CUTOFF.intervalName } }))
  }
};
var StartupNotificationDialog = () => {
  const [isAllowedToClose] = (0, import_react4.useState)(false);
  const dispatch = (0, import_react_redux2.useDispatch)();
  const isDarkMode2 = (0, import_react_redux2.useSelector)(import_selectors.getIsDarkMode);
  const { action, Content } = notifications.offlineThreshold;
  const debouncedCloseGuard = (0, import_debouncehook.useDebounce)(isAllowedToClose, import_constants3.TIMEOUTS.fiveSeconds);
  const onClose = () => {
    action({ dispatch });
    dispatch(setShowStartupNotification(false));
  };
  const headerLogo = isDarkMode2 ? whiteheaderlogo_default : headerlogo_default;
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(
    BaseDialog,
    {
      open: true,
      slotProps: {
        paper: {
          className: "padding-small",
          sx: { maxWidth: 720 }
        }
      },
      title: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { className: "flexbox center-aligned", children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("img", { src: headerLogo, style: { maxHeight: 75 } }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("div", { className: "margin-left-small", children: "Welcome back!" })
      ] }),
      onClose,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.DialogContent, { className: "margin-left-small margin-right-small", children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(Content, {}) }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.DialogActions, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.Button, { variant: "contained", disabled: debouncedCloseGuard, onClick: onClose, children: "Close" }) })
      ]
    }
  );
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfirmDismissHelptips,
  FeedbackDialog,
  LogDialog,
  StartupNotificationDialog
});
//# sourceMappingURL=index.cjs.map