import { AWSCredentials } from './AWSCredentials.js';
import { AzureSharedAccessSecret } from './AzureSharedAccessSecret.js';
import { HTTP } from './HTTP.js';

type Credentials = {
    /**
     * The credential type
     */
    type: Credentials.type;
} & (AWSCredentials | AzureSharedAccessSecret | HTTP);
declare namespace Credentials {
    /**
     * The credential type
     */
    enum type {
        AWS = "aws",
        SAS = "sas",
        HTTP = "http"
    }
}

export { Credentials };
