<?php

class Groups extends Cf_Controller
{
    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('groups_app');
    }

    public function index()
    {
        $requiredcss = [
            ['angularjs-ui/angular-ui.css']
        ];

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = [
            ['node_modules/underscore/underscore-min.js'],
            ['node_modules/angular/angular.min.js'],
            ['node_modules/angular-cookies/angular-cookies.min.js'],
            ['node_modules/angular-route/angular-route.min.js'],
            ['node_modules/angular-sanitize/angular-sanitize.min.js'],
            ['libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'],
            ['libs/class.js']
        ];

        $requiredjs = [
            ['libs/baseclasses/BaseController.js'],
            ['libs/baseclasses/EventDispatcher.js'],
            ['libs/baseclasses/Notifications.js'],
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/editableField.js'],
            //inventory directive (for filter)
            ['advancedreports/dca.js'],
            ['advancedreports/services/notificationService.js'],
            ['advancedreports/services/reportService.js'],
            ['dashboard/helpers/inventory/BaseInventoryWidgetClass.js'],
            ['dashboard/helpers/inventory/PieInventoryWidgetClass.js'],
            ['common_directives/tableDirective.js'],
            ['common_directives/objectsFilter.js'],
            ['common_directives/high-chart.js'],
            ['common_directives/inventory/services/inventoryDataService.js'],
            ['common_directives/inventory/services/inventoryFilterService.js'],
            ['common_directives/inventory/inventory_dca.js'],
            ['common_directives/inventory/services/inventoryService.js'],
            ['common_directives/inventory/helpers/inventoryHelper.js'],
            ['common_directives/inventory/directives/inventoryFilterDirectiveCtrl.js'],
            ['common_directives/inventory/directives/inventoryFilter_directive.js'],
            ['common_directives/objectsFilter.js'],
            // hosts include exclude selector
            ['dashboard/helpers/commonHelper.js'],
            ['common/helper.js'],
            ['common/filters.js'],
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/hostsInclude/services/includeExcludeService.js'],
            ['common_directives/hostsInclude/services/autocompleteService.js'],
            ['common_directives/hostsInclude/services/naviTreeService.js'],
            ['common_directives/hostsInclude/directives/include_exclude_directive.js'],
            ['common_directives/hostsInclude/directives/includeExcludeSelectionDirective.js'],
            ['common_directives/hostsInclude/directives/includeExcludeByHostkeyDirective.js'],
            ['common_directives/hostsInclude/services/paginationService.js'],
            ['common_directives/environment/services/naviTreeService.js'],
            // groups APP
            ['groups/app.js'],
            ['groups/controllers/groupsListController.js'],
            ['groups/controllers/baseGroupController.js'],
            ['groups/controllers/personalGroupController.js'],
            ['groups/controllers/sharedGroupController.js'],
            ['groups/services/personalGroupsService.js'],
            ['groups/services/sharedGroupsService.js'],
        ];

        $highchartsjs = [
            ['node_modules/highcharts/highcharts.js'],
            ['node_modules/highcharts/highcharts-more.js'],
            ['node_modules/highcharts/modules/no-data-to-display.js'],
            ['node_modules/highcharts/modules/exporting.js'],
            ['node_modules/highcharts/modules/solid-gauge.js'],
            ['node_modules/highcharts/modules/exporting.js'],
            ['node_modules/highcharts/modules/offline-exporting.js'],
            ['node_modules/highcharts/modules/accessibility.js'],
        ];

        if (isDarkMode()) {
            $highchartsjs = array_merge($highchartsjs, [['node_modules/highcharts/themes/dark-unica.js']]);
        }

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);
        $this->carabiner->js($highchartsjs, $highchartsjs, TRUE, FALSE, 'footer');

        $data = ['title' => 'Mission Portal - Groups'];

        $this->load->model('ProfileModel');
        $this->ProfileModel->setAdditionalData(
            $this->session->userdata('username'),
            ProfileModel::GROUPS_APP_OPENED_KEY,
            true
        );

        $this->template->load('template', 'groups_app/index', $data);
    }

    public function partials($dir, $partial)
    {
        $view = addslashes($dir) . '/' . addslashes($partial) . '.php';
        $this->load->view($view);
    }
}
