"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/Filters.tsx
var Filters_exports = {};
__export(Filters_exports, {
  Filters: () => Filters,
  default: () => Filters_default
});
module.exports = __toCommonJS(Filters_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_mui = require("tss-react/mui");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");
var import_jsx_runtime = require("react/jsx-runtime");
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    columnGap: theme.spacing(2),
    display: "flex",
    flexWrap: "wrap",
    padding: `10px ${theme.spacing(3)} ${theme.spacing(3)}`,
    rowGap: theme.spacing(2),
    ".filter-item": {
      display: "grid"
    },
    ".filter-item > div": {
      alignSelf: "end"
    }
  },
  filterReset: { right: theme.spacing(3) }
}));
var Filters = ({ className = "", defaultValues, filters = [], initialValues, onChange, fieldResetTrigger = "", dirtyField, clearDirty }) => {
  const { classes } = useStyles();
  const [values, setValues] = (0, import_react.useState)(initialValues);
  const methods = (0, import_react_hook_form.useForm)({ mode: "onChange", defaultValues });
  const { formState, reset, resetField, watch, setValue, getValues } = methods;
  const { isDirty } = formState;
  (0, import_react.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  (0, import_react.useEffect)(() => {
    if (dirtyField && !formState.isDirty) {
      setValue(dirtyField, getValues(dirtyField), { shouldDirty: true });
      clearDirty("");
    }
  }, [clearDirty, dirtyField, formState, getValues, setValue]);
  (0, import_react.useEffect)(() => {
    if (!fieldResetTrigger) {
      return;
    }
    resetField(fieldResetTrigger);
  }, [fieldResetTrigger, resetField]);
  watch(setValues);
  const debouncedValues = (0, import_debouncehook.useDebounce)(values, import_constants.TIMEOUTS.oneSecond);
  (0, import_react.useEffect)(() => {
    onChange(debouncedValues);
  }, [JSON.stringify(debouncedValues), onChange]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_hook_form.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("form", { className: `margin-bottom relative margin-top ${classes.filters} ${className}`, noValidate: true, children: [
    filters.map(({ key, title, Component, componentProps }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "filter-item", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("h5", { className: "margin-top-small margin-bottom-small muted", children: title }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Component, { name: key, ...componentProps })
    ] }, key)),
    isDirty && /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: `link absolute ${classes.filterReset}`, onClick: () => reset(), children: "Clear filter" })
  ] }) });
};
var Filters_default = Filters;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Filters
});
//# sourceMappingURL=Filters.cjs.map