"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Alert: () => Alert_default,
  ApproximateRelativeDate: () => ApproximateRelativeDate,
  AsyncAutocomplete: () => AsyncAutocomplete,
  ChipSelect: () => ChipSelect,
  ClickFilter: () => ClickFilter,
  Code: () => Code,
  CommonList: () => CommonList,
  ConfigurationObject: () => ConfigurationObject,
  Confirm: () => Confirm,
  ConfirmDismissHelptips: () => ConfirmDismissHelptips,
  ConfirmModal: () => ConfirmModal,
  ConfirmationButtons: () => ConfirmationButtons,
  ControlledAutoComplete: () => ControlledAutoComplete,
  ControlledSearch: () => ControlledSearch,
  CopyCode: () => CopyCode,
  CopyTextToClipboard: () => CopyTextToClipboard,
  DOCSTIPS: () => DOCSTIPS,
  DefaultUpgradeNotification: () => DefaultUpgradeNotification,
  DetailsIndicator: () => DetailsIndicator,
  DetailsTable: () => DetailsTable,
  DeviceIdentityDisplay: () => DeviceIdentityDisplay,
  DeviceNameInput: () => DeviceNameInput,
  DocsLink: () => DocsLink,
  DocsTooltip: () => DocsTooltip,
  DrawerTitle: () => DrawerTitle,
  EditButton: () => EditButton,
  EditableLongText: () => EditableLongText,
  EnterpriseNotification: () => EnterpriseNotification_default,
  ExpandableAttribute: () => ExpandableAttribute,
  FeedbackDialog: () => FeedbackDialog,
  FileUpload: () => FileUpload,
  Filters: () => Filters,
  Form: () => Form,
  FormCheckbox: () => FormCheckbox,
  InfoHint: () => InfoHint,
  InfoHintContainer: () => InfoHintContainer,
  InfoText: () => InfoText,
  KeyValueEditor: () => KeyValueEditor,
  LeftNav: () => LeftNav,
  LinedGroupHeader: () => LinedGroupHeader,
  LinedHeader: () => LinedHeader_default,
  Loader: () => Loader,
  LogDialog: () => LogDialog,
  MaterialDesignIcon: () => MaterialDesignIcon_default,
  MaybeTime: () => MaybeTime,
  Pagination: () => Pagination_default,
  PasswordInput: () => PasswordInput,
  RelativeTime: () => RelativeTime,
  Search: () => Search_default,
  SharedSnackbar: () => SharedSnackbar_default,
  StartupNotificationDialog: () => StartupNotificationDialog,
  TablePaginationActions: () => TablePaginationActions,
  TextInput: () => TextInput,
  Time: () => Time,
  TimeframePicker: () => TimeframePicker,
  TwoColumnData: () => TwoColumnData,
  TwoColumnDataMultiple: () => TwoColumnDataMultiple,
  TwoColumns: () => TwoColumns,
  Xterm: () => Xterm,
  calculateResizeChange: () => calculateResizeChange,
  confirmationType: () => confirmationType,
  defaultTextRender: () => defaultTextRender,
  getDeviceIdentityText: () => getDeviceIdentityText,
  minCellWidth: () => minCellWidth,
  runValidations: () => runValidations
});
module.exports = __toCommonJS(index_exports);

// src/dialogs/ConfirmDismissHelpTips.tsx
var import_material2 = require("@mui/material");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_store = require("@northern.tech/store/store");
var import_thunks = require("@northern.tech/store/thunks");

// src/dialogs/BaseDialog.tsx
var import_material = require("@mui/material");
var import_jsx_runtime = require("react/jsx-runtime");
var BaseDialog = (props) => {
  const { children, onClose, title, ...dialogProps } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.Dialog, { ...dialogProps, onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.DialogTitle, { children: title }),
    children
  ] });
};

// src/dialogs/ConfirmDismissHelpTips.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var { setShowDismissOnboardingTipsDialog } = import_actions.default;
var ConfirmDismissHelptips = () => {
  const dispatch = (0, import_store.useAppDispatch)();
  const onClose = () => dispatch((0, import_thunks.setOnboardingCanceled)());
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(BaseDialog, { open: true, title: "Dismiss the Getting Started help?", onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.DialogContent, { children: "Hide the help tips? You haven't finished your first update yet." }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_material2.DialogActions, { className: "flexbox space-between", children: [
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { onClick: () => dispatch(setShowDismissOnboardingTipsDialog(false)), children: "Cancel" }),
      /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.Button, { variant: "contained", color: "secondary", onClick: onClose, children: "Yes, hide the help" })
    ] })
  ] });
};

// src/dialogs/Feedback.tsx
var import_react = require("react");
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material3 = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_actions2 = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_thunks2 = require("@northern.tech/store/thunks");
var import_utils = require("@northern.tech/store/utils");
var import_jsx_runtime3 = require("react/jsx-runtime");
var { setShowFeedbackDialog } = import_actions2.default;
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  root: {
    pointerEvents: "none",
    [`.${import_material3.dialogClasses.paper}`]: { width: 350, bottom: 0, right: 0, position: "absolute" },
    [`.${import_material3.dialogTitleClasses.root}`]: {
      alignSelf: "flex-end",
      padding: 0,
      [`.${import_material3.iconButtonClasses.root}`]: { marginBottom: theme.spacing(-1) }
    },
    ".title": {
      color: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material3.lighten)(theme.palette.primary.main, 0.85) : "inherit"
    }
  },
  columns: { gap: theme.spacing(2) },
  rating: {
    [`.${import_material3.iconButtonClasses.root}`]: {
      borderRadius: theme.shape.borderRadius,
      height: theme.spacing(6),
      width: theme.spacing(6),
      backgroundColor: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material3.darken)(theme.palette.primary.main, 0.45) : (0, import_material3.lighten)(theme.palette.primary.main, 0.85),
      color: theme.palette.primary.main,
      "&:hover": {
        backgroundColor: theme.palette.primary.main,
        color: (0, import_material3.lighten)(theme.palette.primary.main, 0.85)
      }
    }
  },
  text: { [`.${import_material3.textFieldClasses.root}`]: { marginTop: 0 }, ".submitButton": { alignSelf: "start" } }
}));
var satisfactionLevels = [
  { Icon: import_icons_material.SentimentVeryDissatisfiedOutlined, title: "Very Dissatisfied" },
  { Icon: import_icons_material.SentimentVeryDissatisfied, title: "Dissatisfied" },
  { Icon: import_icons_material.SentimentNeutral, title: "Neutral" },
  { Icon: import_icons_material.SentimentSatisfiedAlt, title: "Satisfied" },
  { Icon: import_icons_material.SentimentVerySatisfiedOutlined, title: "Very Satisfied" }
];
var explanations = ["Very unsatisfied", "Very satisfied"];
var SatisfactionGauge = ({ classes, setSatisfaction }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: `flexbox column ${classes.columns}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "title", children: "How satisfied are you with Mender?" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: `flexbox space-between ${classes.rating}`, children: satisfactionLevels.map(({ Icon, title }, index) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.IconButton, { onClick: () => setSatisfaction(index), title, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Icon, { fontSize: "large" }) }, `satisfaction-${index}`)) }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "flexbox space-between muted", children: explanations.map((explanation, index) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "slightly-smaller", children: explanation }, `explanation-${index}`)) })
] });
var TextEntry = ({ classes, feedback, onChangeFeedback, onSubmit }) => /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)("div", { className: `flexbox column ${classes.columns} ${classes.text}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { className: "title", children: "What do you think is the most important thing to improve in Mender? (optional)" }),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    import_material3.TextField,
    {
      placeholder: "Your feedback",
      multiline: true,
      minRows: 4,
      onChange: ({ target: { value } }) => onChangeFeedback(value),
      value: feedback,
      variant: "outlined"
    }
  ),
  /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.Button, { className: "submitButton", variant: "contained", onClick: onSubmit, children: "Submit Feedback" })
] });
var AppreciationNote = () => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("p", { className: "margin-top-none align-center title", children: "Thank you for taking the time to share your thoughts!" });
var progressionLevels = [SatisfactionGauge, TextEntry, AppreciationNote];
var FeedbackDialog = () => {
  const [progress, setProgress] = (0, import_react.useState)(0);
  const [satisfaction, setSatisfaction] = (0, import_react.useState)(-1);
  const [feedback, setFeedback] = (0, import_react.useState)("");
  const dispatch = (0, import_react_redux.useDispatch)();
  const isInitialized = (0, import_react.useRef)(false);
  const { classes } = useStyles();
  (0, import_react.useEffect)(() => {
    if (!isInitialized.current) {
      return;
    }
    setProgress((current) => current + 1);
  }, [satisfaction]);
  (0, import_react.useEffect)(() => {
    setTimeout(() => isInitialized.current = true, import_constants.TIMEOUTS.oneSecond);
  }, []);
  const onCloseClick = () => dispatch(setShowFeedbackDialog(false));
  const onSubmit = () => {
    setProgress(progress + 1);
    dispatch((0, import_thunks2.submitFeedback)({ satisfaction: satisfactionLevels[satisfaction].title, feedback }));
  };
  const Component = progressionLevels[progress];
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_material3.Dialog, { className: classes.root, open: true, hideBackdrop: true, disableEnforceFocus: true, PaperProps: { style: { pointerEvents: "auto" } }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.DialogTitle, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.IconButton, { onClick: onCloseClick, "aria-label": "close", size: "small", children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_icons_material.Close, {}) }) }),
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_material3.DialogContent, { children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { classes, feedback, setSatisfaction, onChangeFeedback: setFeedback, onSubmit }) })
  ] });
};

// src/dialogs/Log.tsx
var import_react3 = require("react");
var import_react_copy_to_clipboard2 = __toESM(require("react-copy-to-clipboard"), 1);
var import_material5 = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");

// src/CopyCode.tsx
var import_react2 = require("react");
var import_react_copy_to_clipboard = __toESM(require("react-copy-to-clipboard"), 1);
var import_icons_material2 = require("@mui/icons-material");
var import_material4 = require("@mui/material");
var import_mui2 = require("tss-react/mui");
var import_constants2 = require("@northern.tech/store/constants");
var import_jsx_runtime4 = require("react/jsx-runtime");
var buttonStyle = { float: "right", margin: "-20px 0 0 10px" };
var useStyles2 = (0, import_mui2.makeStyles)()((theme) => ({
  code: {
    border: "1px solid",
    borderColor: theme.palette.background.lightgrey,
    backgroundColor: theme.palette.background.lightgrey
  }
}));
var Code = ({ className = "", children, style = {} }) => {
  const { classes } = useStyles2();
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("div", { className: `code ${classes.code} ${className}`, style, children });
};
var CopyCode = ({ code, onCopy, withDescription }) => {
  const [copied, setCopied] = (0, import_react2.useState)(false);
  const onCopied = (_text, result) => {
    setCopied(result);
    setTimeout(() => setCopied(false), import_constants2.TIMEOUTS.fiveSeconds);
    if (onCopy) {
      onCopy();
    }
  };
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(import_jsx_runtime4.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(Code, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_react_copy_to_clipboard.default, { text: code, onCopy: onCopied, children: withDescription ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_material4.Button, { style: buttonStyle, startIcon: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_icons_material2.FileCopy, {}), children: "Copy to clipboard" }) : /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_material4.IconButton, { style: buttonStyle, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_icons_material2.FileCopy, {}) }) }),
      /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("span", { style: { whiteSpace: "pre-wrap", wordBreak: "break-word" }, children: code })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("p", { children: copied && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
  ] });
};

// src/dialogs/Log.tsx
var import_jsx_runtime5 = require("react/jsx-runtime");
var wrapperStyle = { marginRight: 10, display: "inline-block" };
var dialogTypes = {
  "deviceLog": {
    title: "Deployment log for device",
    filename: ({ device, releaseName, date }) => `deployment-log-${device}-${releaseName}-${date}.log`
  },
  "configUpdateLog": {
    title: "Config update log for device",
    filename: () => "configuration-update.log"
  }
};
var LogDialog = ({ context = {}, logData = "", onClose, type = "deviceLog" }) => {
  const [copied, setCopied] = (0, import_react3.useState)(false);
  const exportLog = () => (0, import_helpers.createFileDownload)(logData, dialogTypes[type].filename(context), "");
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(BaseDialog, { open: true, title: dialogTypes[type].title, maxWidth: "lg", onClose, children: [
    /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_material5.DialogContent, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(Code, { className: "log", children: logData }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("p", { style: { marginLeft: 24 }, children: copied && /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime5.jsxs)(import_material5.DialogActions, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)("div", { style: wrapperStyle, children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { onClick: onClose, children: "Cancel" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_react_copy_to_clipboard2.default, { style: wrapperStyle, text: logData, onCopy: () => setCopied(true), children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { children: "Copy to clipboard" }) }),
      /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(import_material5.Button, { variant: "contained", color: "primary", onClick: exportLog, children: "Export log" })
    ] })
  ] });
};

// src/dialogs/StartupNotification.tsx
var import_react4 = require("react");
var import_react_redux2 = require("react-redux");
var import_material6 = require("@mui/material");
var import_actions3 = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants3 = require("@northern.tech/store/constants");
var import_selectors = require("@northern.tech/store/selectors");
var import_thunks3 = require("@northern.tech/store/thunks");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// ../../assets/img/headerlogo.png
var headerlogo_default = "./headerlogo-QQW3XP5Y.png";

// ../../assets/img/whiteheaderlogo.png
var whiteheaderlogo_default = "./whiteheaderlogo-76DNCTF3.png";

// src/SupportLink.tsx
var import_jsx_runtime6 = require("react/jsx-runtime");
var variants = {
  email: "support@mender.io",
  ourTeam: "contact our team",
  support: "contact support",
  salesTeam: "contact our sales team"
};
var SupportLink = ({ className = "", variant }) => /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("a", { className, href: "mailto:support@mender.io", target: "_blank", rel: "noopener noreferrer", children: variants[variant] ?? variant });

// src/dialogs/StartupNotification.tsx
var import_jsx_runtime7 = require("react/jsx-runtime");
var { setShowStartupNotification } = import_actions3.default;
var OfflineThresholdContent = () => /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(import_jsx_runtime7.Fragment, { children: [
  "In our continuous efforts to enhance performance and to ensure the stability of our service, we have made adjustments to how granular device connectivity can be checked.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("h4", { children: "What's changing:" }),
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("ul", { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("li", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("i", { children: "Offline threshold" }),
    " setting: if a device no longer connects with the server, it may take up to 1 day until it is shown as an offline device in the UI."
  ] }) }),
  "More granular connectivity information will still be reflected in the device details.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("h4", { children: "Why are we changing this:" }),
  /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("ul", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("li", { children: "Performance Improvements: Less frequent updates allow us to better optimize the platform and improve overall performance." }),
    /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("li", { children: "Stability: This change helps ensure that our backend will remain stable while serving an ever growing number of devices and potential disruptions are minimized." })
  ] }),
  "We appreciate your understanding and cooperation as we implement these improvements. Our commitment to providing you with a reliable and high-performing platform remains our top priority.",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.Divider, { className: "margin-top-small margin-bottom-small" }),
  "If you have any questions or concerns regarding this change, please do not hesitate to ",
  /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(SupportLink, { variant: "ourTeam" }),
  "."
] });
var notifications = {
  offlineThreshold: {
    Content: OfflineThresholdContent,
    action: ({ dispatch }) => dispatch((0, import_thunks3.saveGlobalSettings)({ offlineThreshold: { interval: 1, intervalUnit: import_constants3.DEVICE_ONLINE_CUTOFF.intervalName } }))
  }
};
var StartupNotificationDialog = () => {
  const [isAllowedToClose] = (0, import_react4.useState)(false);
  const dispatch = (0, import_react_redux2.useDispatch)();
  const isDarkMode4 = (0, import_react_redux2.useSelector)(import_selectors.getIsDarkMode);
  const { action, Content } = notifications.offlineThreshold;
  const debouncedCloseGuard = (0, import_debouncehook.useDebounce)(isAllowedToClose, import_constants3.TIMEOUTS.fiveSeconds);
  const onClose = () => {
    action({ dispatch });
    dispatch(setShowStartupNotification(false));
  };
  const headerLogo = isDarkMode4 ? whiteheaderlogo_default : headerlogo_default;
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)(
    BaseDialog,
    {
      open: true,
      slotProps: {
        paper: {
          className: "padding-small",
          sx: { maxWidth: 720 }
        }
      },
      title: /* @__PURE__ */ (0, import_jsx_runtime7.jsxs)("div", { className: "flexbox center-aligned", children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("img", { src: headerLogo, style: { maxHeight: 75 } }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)("div", { className: "margin-left-small", children: "Welcome back!" })
      ] }),
      onClose,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.DialogContent, { className: "margin-left-small margin-right-small", children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(Content, {}) }),
        /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.DialogActions, { children: /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_material6.Button, { variant: "contained", disabled: debouncedCloseGuard, onClick: onClose, children: "Close" }) })
      ]
    }
  );
};

// src/forms/Autocomplete.tsx
var import_react_hook_form = require("react-hook-form");
var import_material7 = require("@mui/material");
var import_jsx_runtime8 = require("react/jsx-runtime");
var ControlledAutoComplete = ({ freeSolo, name, onChange, onInputChange, ...remainder }) => {
  const { control } = (0, import_react_hook_form.useFormContext)();
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
    import_react_hook_form.Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, ...props } }) => {
        const onChangeHandler = (e, data) => formOnChange(data);
        return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(import_material7.Autocomplete, { ...freeSolo ? { freeSolo, onInputChange: onChangeHandler } : { onChange: onChangeHandler }, ...props, ...remainder });
      }
    }
  );
};

// src/forms/ClickFilter.tsx
var import_jsx_runtime9 = require("react/jsx-runtime");
var ClickFilter = ({ disabled = false, children }) => disabled ? /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("div", { style: { pointerEvents: "none" }, children }) : /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_jsx_runtime9.Fragment, { children });

// src/forms/FileUpload.tsx
var import_react5 = require("react");
var import_react_dropzone = __toESM(require("react-dropzone"), 1);
var import_react_redux3 = require("react-redux");
var import_icons_material3 = require("@mui/icons-material");
var import_material8 = require("@mui/material");
var import_actions4 = __toESM(require("@northern.tech/store/actions"), 1);
var import_jsx_runtime10 = require("react/jsx-runtime");
var { setSnackbar } = import_actions4.default;
var FileUpload = ({ enableContentReading = true, fileNameSelection, onFileChange, onFileSelect = () => void 0, placeholder, style = {} }) => {
  const [filename, setFilename] = (0, import_react5.useState)(fileNameSelection);
  const dispatch = (0, import_react_redux3.useDispatch)();
  const onDrop = (acceptedFiles, rejectedFiles) => {
    if (acceptedFiles.length) {
      if (enableContentReading) {
        const reader = new FileReader();
        reader.readAsBinaryString(acceptedFiles[0]);
        reader.fileName = acceptedFiles[0].name;
        reader.onload = () => {
          const str = reader.result.replace(/\n|\r/g, "\n");
          onFileChange(str);
        };
        reader.onerror = (error) => {
          console.log("Error: ", error);
          setFilename();
        };
      }
      setFilename(acceptedFiles[0].name);
      onFileSelect(acceptedFiles[0]);
    }
    if (rejectedFiles.length) {
      dispatch(setSnackbar(`File '${rejectedFiles[0].name}' was rejected.`));
    }
  };
  const onClear = () => {
    onFileChange();
    onFileSelect();
    setFilename();
  };
  return filename ? /* @__PURE__ */ (0, import_jsx_runtime10.jsxs)("div", { style, children: [
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_material8.TextField, { id: "keyfile", value: filename, disabled: true, style: { color: "rgba(0, 0, 0, 0.8)", borderBottom: "1px solid rgb(224, 224, 224)" } }),
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_material8.IconButton, { style: { top: "6px" }, onClick: onClear, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_icons_material3.Clear, {}) })
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime10.jsx)("div", { style, children: /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_react_dropzone.default, { activeClassName: "active", rejectClassName: "active", multiple: false, onDrop, children: ({ getRootProps, getInputProps }) => /* @__PURE__ */ (0, import_jsx_runtime10.jsxs)("div", { ...getRootProps(), style: { padding: 15 }, className: "dropzone onboard dashboard-placeholder flexbox centered", children: [
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)("input", { ...getInputProps() }),
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(import_icons_material3.CloudUploadOutlined, { className: "icon", style: { height: 24, width: 24, verticalAlign: "middle", marginTop: "-2px" } }),
    /* @__PURE__ */ (0, import_jsx_runtime10.jsx)("div", { className: "margin-left-small", style: { fontSize: "11pt" }, children: placeholder })
  ] }) }) });
};

// src/forms/Filters.tsx
var import_react6 = require("react");
var import_react_hook_form2 = require("react-hook-form");
var import_mui3 = require("tss-react/mui");
var import_constants4 = require("@northern.tech/store/constants");
var import_debouncehook2 = require("@northern.tech/utils/debouncehook");
var import_jsx_runtime11 = require("react/jsx-runtime");
var useStyles3 = (0, import_mui3.makeStyles)()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    columnGap: theme.spacing(2),
    display: "flex",
    flexWrap: "wrap",
    padding: `10px ${theme.spacing(3)} ${theme.spacing(3)}`,
    rowGap: theme.spacing(2),
    ".filter-item": {
      display: "grid"
    },
    ".filter-item > div": {
      alignSelf: "end"
    }
  },
  filterReset: { right: theme.spacing(3) }
}));
var Filters = ({ className = "", defaultValues, filters = [], initialValues, onChange, fieldResetTrigger = "", dirtyField, clearDirty }) => {
  const { classes } = useStyles3();
  const [values, setValues] = (0, import_react6.useState)(initialValues);
  const methods = (0, import_react_hook_form2.useForm)({ mode: "onChange", defaultValues });
  const { formState, reset, resetField, watch, setValue, getValues } = methods;
  const { isDirty } = formState;
  (0, import_react6.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  (0, import_react6.useEffect)(() => {
    if (dirtyField && !formState.isDirty) {
      setValue(dirtyField, getValues(dirtyField), { shouldDirty: true });
      clearDirty("");
    }
  }, [clearDirty, dirtyField, formState, getValues, setValue]);
  (0, import_react6.useEffect)(() => {
    if (!fieldResetTrigger) {
      return;
    }
    resetField(fieldResetTrigger);
  }, [fieldResetTrigger, resetField]);
  watch(setValues);
  const debouncedValues = (0, import_debouncehook2.useDebounce)(values, import_constants4.TIMEOUTS.oneSecond);
  (0, import_react6.useEffect)(() => {
    onChange(debouncedValues);
  }, [JSON.stringify(debouncedValues), onChange]);
  return /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(import_react_hook_form2.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)("form", { className: `margin-bottom relative margin-top ${classes.filters} ${className}`, noValidate: true, children: [
    filters.map(({ key, title, Component, componentProps }) => /* @__PURE__ */ (0, import_jsx_runtime11.jsxs)("div", { className: "filter-item", children: [
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)("h5", { className: "margin-top-small margin-bottom-small muted", children: title }),
      /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(Component, { name: key, ...componentProps })
    ] }, key)),
    isDirty && /* @__PURE__ */ (0, import_jsx_runtime11.jsx)("span", { className: `link absolute ${classes.filterReset}`, onClick: () => reset(), children: "Clear filter" })
  ] }) });
};

// src/forms/Form.tsx
var import_react7 = require("react");
var import_react_hook_form3 = require("react-hook-form");
var import_material9 = require("@mui/material");
var import_mui4 = require("tss-react/mui");
var import_validator = __toESM(require("validator"), 1);
var import_jsx_runtime12 = require("react/jsx-runtime");
var validationMethods = {
  isAlpha: "This field must contain only letters",
  isAlphanumeric: "This field must contain only letters or numbers",
  isEmail: "Please enter a valid email address",
  isHexadecimal: "The secret has to be entered as a hexadecimal string",
  isNumeric: "Please enter a valid code",
  isURL: "Please enter a valid URL",
  isUUID: "Please enter a valid ID"
};
var getErrorMsg = (validateMethod, args) => {
  if (validationMethods[validateMethod]) {
    return validationMethods[validateMethod];
  }
  switch (validateMethod) {
    case "isLength":
      if (Number(args[0]) === 1) {
        return "This field is required";
      } else if (args[0] > 1) {
        return `Must be at least ${args[0]} characters long`;
      }
      break;
    case "isAlphanumericLocator":
      if (args[0] && import_validator.default.matches(args[0], /^[a-zA-Z0-9_-]+$/)) {
        return "";
      } else {
        return "This please only enter valid characters. Valid characters are a-z, A-Z, 0-9, _ and -";
      }
    case "isNot":
      if (args[0] === args[1]) {
        return `This field should have a value other than ${args[0]}`;
      }
      break;
    default:
      return "There is an error with this field";
  }
};
var tryApplyValidationEntry = (value, validations = [], validationResults = []) => {
  const validation = validations.shift();
  if (!validation) {
    return validationResults.pop();
  }
  let args = validation.split(":");
  const validateMethod = args.shift();
  const tmpArgs = args;
  args = [value].concat(args);
  try {
    if (!import_validator.default[validateMethod](...args)) {
      return tryApplyValidationEntry(value, validations, [...validationResults, { errortext: getErrorMsg(validateMethod, tmpArgs), isValid: false }]);
    }
  } catch {
    const errortext = getErrorMsg(validateMethod, args) || "";
    return tryApplyValidationEntry(value, validations, [...validationResults, { errortext, isValid: !errortext }]);
  }
  return { errortext: "", isValid: true };
};
var tryApplyValidations = (value, validations, initialValidationResult) => validations.split(",").reduce((accu, validation) => {
  if (!accu.isValid || !validation) {
    return accu;
  }
  const alternatives = validation.split("||");
  return tryApplyValidationEntry(value, alternatives, [accu]);
}, initialValidationResult);
var runPasswordValidations = ({ required, value, validations, isValid, errortext }) => {
  if (required && !value) {
    return { isValid: false, errortext: "Password is required" };
  } else if (required || value) {
    const { isValid: validatedIsValid, errortext: validatedErrortext } = tryApplyValidations(value, validations, { isValid, errortext });
    return { isValid: validatedIsValid, errortext: !validatedIsValid ? validatedErrortext ? validatedErrortext : "Password too weak" : errortext };
  }
  return { isValid, errortext };
};
var runValidations = ({ required, value, id, validations, wasMaybeTouched }) => {
  const isValid = true;
  const errortext = "";
  if (id && id.includes("password")) {
    return runPasswordValidations({ required, value, validations, isValid, errortext });
  } else {
    if (value || required || wasMaybeTouched && validations.includes("isLength:1")) {
      return tryApplyValidations(validations.includes("trim") ? value.trim() : value, validations, { isValid, errortext });
    }
  }
  return { isValid, errortext };
};
var useStyles4 = (0, import_mui4.makeStyles)()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));
var Form = ({
  autocomplete,
  buttonColor,
  children,
  className = "",
  classes = { buttonWrapper: "", cancelButton: "" },
  defaultValues = {},
  handleCancel,
  id,
  initialValues = {},
  onSubmit,
  showButtons,
  submitLabel,
  submitRef
}) => {
  const { classes: internalClasses } = useStyles4();
  const methods = (0, import_react_hook_form3.useForm)({ mode: "onChange", defaultValues });
  const {
    handleSubmit,
    formState: { isValid },
    setValue
  } = methods;
  (0, import_react7.useEffect)(() => {
    if (submitRef) {
      submitRef.current = handleSubmit(onSubmit);
    }
  }, [handleSubmit, onSubmit, submitRef]);
  (0, import_react7.useEffect)(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  return /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_react_hook_form3.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime12.jsxs)("form", { autoComplete: autocomplete, className, id, noValidate: true, onSubmit: handleSubmit(onSubmit), children: [
    children,
    !!showButtons && /* @__PURE__ */ (0, import_jsx_runtime12.jsxs)("div", { className: `button-wrapper ${internalClasses.buttonWrapper} ${classes.buttonWrapper}`, children: [
      !!handleCancel && /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_material9.Button, { className: `${internalClasses.cancelButton} ${classes.cancelButton}`, onClick: handleCancel, children: "Cancel" }, "cancel"),
      /* @__PURE__ */ (0, import_jsx_runtime12.jsx)(import_material9.Button, { variant: "contained", type: "submit", disabled: !isValid, color: buttonColor, children: submitLabel })
    ] })
  ] }) });
};
var Form_default = Form;

// src/forms/FormCheckbox.tsx
var import_react_hook_form4 = require("react-hook-form");
var import_material10 = require("@mui/material");
var import_jsx_runtime13 = require("react/jsx-runtime");
var FormCheckbox = ({ className, control, disabled, id, handleClick, style, label, required }) => /* @__PURE__ */ (0, import_jsx_runtime13.jsx)(
  import_react_hook_form4.Controller,
  {
    name: id,
    rules: { required },
    control,
    render: ({ field: { value = false, onChange } }) => /* @__PURE__ */ (0, import_jsx_runtime13.jsx)(
      import_material10.FormControlLabel,
      {
        className,
        control: /* @__PURE__ */ (0, import_jsx_runtime13.jsx)(import_material10.Checkbox, { name: id, onClick: handleClick, disabled, checked: value, style, color: "primary", onChange: () => onChange(!value) }),
        label
      }
    )
  }
);

// src/forms/KeyValueEditor.tsx
var import_react8 = require("react");
var import_react_hook_form5 = require("react-hook-form");
var import_icons_material4 = require("@mui/icons-material");
var import_material11 = require("@mui/material");
var import_mui5 = require("tss-react/mui");
var import_jsx_runtime14 = require("react/jsx-runtime");
var emptyInput = { helptip: null, key: "", value: "" };
var reducePairs = (pairs) => (pairs || []).reduce((accu, item) => ({ ...accu, ...item.value ? { [item.key]: item.value } : {} }), {});
var useStyles5 = (0, import_mui5.makeStyles)()((theme) => ({
  spacer: { minWidth: theme.spacing(30) },
  helptip: { left: -35, top: 15, position: "absolute" },
  keyValueContainer: {
    display: "grid",
    gridTemplateColumns: "min-content min-content max-content",
    columnGap: theme.spacing(2),
    alignItems: "baseline",
    justifyItems: "baseline",
    "> div": {
      marginTop: 10
    }
  }
}));
var KeyValueFields = ({ disabled, errortext, inputHelpTipsMap, onInputChange }) => {
  const { classes } = useStyles5();
  const {
    control,
    watch,
    setValue,
    formState: { errors },
    trigger
  } = (0, import_react_hook_form5.useFormContext)();
  const { fields, append, remove, replace } = (0, import_react_hook_form5.useFieldArray)({
    control,
    name: "inputs",
    rules: {
      validate: {
        noDuplicates: (inputs2) => {
          const keys = (inputs2 || []).map((item) => item.key).filter(Boolean);
          return new Set(keys).size === keys.length || "Duplicate keys exist, only the last set value will be submitted";
        }
      }
    }
  });
  const inputs = watch("inputs");
  (0, import_react8.useEffect)(() => {
    const inputObject = reducePairs(inputs);
    onInputChange(inputObject);
  }, [JSON.stringify(inputs), onInputChange]);
  const onClearClick = () => replace([{ ...emptyInput }]);
  const addKeyValue = () => append({ ...emptyInput });
  const updateField = (index, field, value) => {
    setValue(`inputs.${index}.${field}`, value);
    if (field === "key") {
      const normalizedKey = value.toLowerCase();
      setValue(`inputs.${index}.helptip`, inputHelpTipsMap[normalizedKey]);
    }
    trigger();
  };
  return /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)("div", { children: [
    fields.map((field, index) => {
      const hasError = Boolean(index === fields.length - 1 && (errortext || errors?.inputs?.root?.message));
      const hasRemovalDisabled = !(inputs?.[index]?.key && inputs?.[index]?.value);
      const { component: Helptip = null, props: helptipProps = {} } = inputs[index].helptip ?? {};
      return /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)("div", { className: `${classes.keyValueContainer} relative`, children: [
        /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)(import_material11.FormControl, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
            import_material11.OutlinedInput,
            {
              disabled,
              value: inputs?.[index]?.key || "",
              placeholder: "Key",
              onChange: (e) => updateField(index, "key", e.target.value),
              type: "text"
            }
          ),
          hasError && /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_material11.FormHelperText, { children: errortext || errors?.inputs?.root?.message })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_material11.FormControl, { children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
          import_material11.OutlinedInput,
          {
            disabled,
            value: inputs?.[index]?.value || "",
            placeholder: "Value",
            onChange: (e) => updateField(index, "value", e.target.value),
            type: "text"
          }
        ) }),
        fields.length > 1 && !hasRemovalDisabled ? /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_material11.IconButton, { disabled, onClick: () => remove(index), size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_icons_material4.Clear, { fontSize: "small" }) }) : /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("span", {}),
        Helptip && /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(Helptip, { className: classes.helptip, ...helptipProps })
      ] }, field.id);
    }),
    /* @__PURE__ */ (0, import_jsx_runtime14.jsxs)("div", { className: classes.keyValueContainer, children: [
      /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("div", { className: classes.spacer, children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(
        import_material11.Fab,
        {
          disabled: disabled || !inputs?.[fields.length - 1]?.key || !inputs?.[fields.length - 1]?.value,
          style: { marginBottom: 10 },
          color: "secondary",
          size: "small",
          onClick: addKeyValue,
          children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(import_icons_material4.Add, {})
        }
      ) }),
      /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("div", { className: classes.spacer }),
      inputs.length > 1 ? /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("a", { onClick: onClearClick, children: "clear all" }) : /* @__PURE__ */ (0, import_jsx_runtime14.jsx)("div", {})
    ] })
  ] });
};
var KeyValueEditor = ({ disabled, errortext, initialInput = {}, inputHelpTipsMap = {}, onInputChange }) => {
  const defaultValues = {
    inputs: Object.keys(initialInput).length ? Object.entries(initialInput).map(([key, value]) => ({ helptip: inputHelpTipsMap[key.toLowerCase()], key, value })) : [{ ...emptyInput }]
  };
  const [initialValues] = (0, import_react8.useState)(defaultValues);
  const onFormSubmit = (data) => onInputChange(reducePairs(data.inputs));
  return /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(Form_default, { autocomplete: "off", defaultValues, id: "key-value-editor", initialValues, onSubmit: onFormSubmit, children: /* @__PURE__ */ (0, import_jsx_runtime14.jsx)(KeyValueFields, { disabled, errortext, inputHelpTipsMap, onInputChange }) });
};

// src/forms/PasswordInput.tsx
var import_react9 = __toESM(require("react"), 1);
var import_react_hook_form6 = require("react-hook-form");
var import_icons_material5 = require("@mui/icons-material");
var import_material12 = require("@mui/material");
var import_constants5 = require("@northern.tech/store/constants");
var import_helpers2 = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard = __toESM(require("copy-to-clipboard"), 1);
var import_generate_password_browser = __toESM(require("generate-password-browser"), 1);
var import_jsx_runtime15 = require("react/jsx-runtime");
var PasswordGenerateButtons = ({ clearPass, edit, generatePass, disabled }) => /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)("div", { className: "pass-buttons", children: [
  /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.Button, { color: "primary", onClick: generatePass, disabled, children: "Generate" }),
  edit ? /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.Button, { onClick: clearPass, children: "Cancel" }) : null
] });
var SCORE_THRESHOLD = 3;
var PasswordGenerationControls = ({ score, feedback }) => /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)(import_jsx_runtime15.Fragment, { children: [
  /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)("div", { className: "help-text", id: "pass-strength", children: [
    "Strength: ",
    /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("meter", { max: 4, min: 0, value: score, high: 3.9, optimum: 4, low: 2.5 }),
    score > SCORE_THRESHOLD ? /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_icons_material5.CheckCircle, { className: "fadeIn green", style: { height: 18, marginTop: -3, marginBottom: -3 } }) : null
  ] }),
  !!feedback.length && /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("p", { className: "help-text", children: feedback.map((message, index) => /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)(import_react9.default.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("span", { children: message }),
    /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("br", {})
  ] }, `feedback-${index}`)) })
] });
var PasswordInput = ({
  autocomplete,
  className,
  control,
  create,
  defaultValue,
  disabled,
  edit,
  generate,
  id,
  InputLabelProps = {},
  label,
  onClear,
  placeholder,
  required,
  validations = ""
}) => {
  const [score, setScore] = (0, import_react9.useState)(0);
  const [visible, setVisible] = (0, import_react9.useState)(false);
  const [copied, setCopied] = (0, import_react9.useState)(false);
  const [feedback, setFeedback] = (0, import_react9.useState)([]);
  const [confirmationId] = (0, import_react9.useState)(id.includes("current") ? "" : ["password", "password_confirmation"].find((thing) => thing !== id));
  const timer = (0, import_react9.useRef)();
  const {
    clearErrors,
    formState: { errors },
    setError,
    setValue,
    trigger,
    getValues
  } = (0, import_react_hook_form6.useFormContext)();
  const confirmation = (0, import_react_hook_form6.useWatch)({ name: confirmationId });
  const errorKey = `${id}`;
  const { message } = errors[errorKey] ?? {};
  (0, import_react9.useEffect)(() => {
    if (confirmationId === "password" && !message) {
      trigger(confirmationId);
    }
  }, [confirmationId, message, trigger]);
  (0, import_react9.useEffect)(() => () => {
    clearTimeout(timer.current);
  });
  const clearPassClick = () => {
    setValue(id, "");
    onClear();
    setCopied(false);
  };
  const generatePassClick = () => {
    const password = import_generate_password_browser.default.generate({ length: 16, numbers: true });
    setValue(id, password);
    const form = getValues();
    if (form.hasOwnProperty(`${id}_confirmation`)) {
      setValue(`${id}_confirmation`, password);
    }
    (0, import_copy_to_clipboard.default)(password);
    setCopied(true);
    setVisible(true);
    timer.current = setTimeout(() => setCopied(false), import_constants5.TIMEOUTS.fiveSeconds);
    trigger();
  };
  const validate = async (value = "") => {
    if (disabled) {
      return true;
    }
    let { isValid, errortext } = runValidations({ id, required, validations, value });
    if (confirmation && value !== confirmation) {
      isValid = false;
      errortext = "The passwords you provided do not match, please check again.";
    }
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    const { default: zxcvbn } = await import(
      /* webpackChunkName: "zxcvbn" */
      "zxcvbn"
    );
    const strength = zxcvbn(value);
    const score2 = strength.score;
    setScore(score2);
    if (!create || !required && !value) {
      return isValid || errortext;
    }
    setFeedback(strength.feedback.suggestions || []);
    return score2 > SCORE_THRESHOLD && isValid || errortext;
  };
  const showAsNotched = label && typeof label !== "string" ? { notched: true } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)("div", { className, children: [
    /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)("div", { className: "password-wrapper", children: [
      /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(
        import_react_hook_form6.Controller,
        {
          name: id,
          control,
          rules: { required, validate },
          render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)(import_material12.FormControl, { className: required ? "required" : "", error: Boolean((error || errors[errorKey])?.message), style: { width: 400 }, children: [
            /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
            /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(
              import_material12.OutlinedInput,
              {
                autoComplete: autocomplete,
                id,
                label,
                name: id,
                type: visible ? "text" : "password",
                defaultValue,
                placeholder,
                value: value ?? "",
                disabled,
                inputRef: ref,
                required,
                onChange: ({ target: { value: value2 } }) => {
                  setValue(id, value2);
                  onChange(value2);
                },
                onBlur,
                endAdornment: /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.InputAdornment, { position: "end", children: /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.IconButton, { onClick: () => setVisible(import_helpers2.toggle), size: "large", children: visible ? /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_icons_material5.Visibility, {}) : /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_icons_material5.VisibilityOff, {}) }) }),
                ...showAsNotched
              }
            ),
            /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(import_material12.FormHelperText, { children: (errors[errorKey] || error)?.message })
          ] })
        }
      ),
      generate && !required && /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] }),
    copied ? /* @__PURE__ */ (0, import_jsx_runtime15.jsx)("div", { className: "green fadeIn margin-bottom-small", children: "Copied to clipboard" }) : null,
    create && /* @__PURE__ */ (0, import_jsx_runtime15.jsxs)(import_jsx_runtime15.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(PasswordGenerationControls, { feedback, score }),
      generate && required && /* @__PURE__ */ (0, import_jsx_runtime15.jsx)(PasswordGenerateButtons, { disabled, clearPass: clearPassClick, edit, generatePass: generatePassClick })
    ] })
  ] });
};

// src/forms/TextInput.tsx
var import_react_hook_form7 = require("react-hook-form");
var import_material13 = require("@mui/material");
var import_jsx_runtime16 = require("react/jsx-runtime");
var TextInput = ({
  autocomplete,
  className = "",
  control,
  controlRef,
  disabled,
  hint,
  id,
  InputLabelProps = {},
  InputProps = {},
  label,
  required,
  type,
  validations = "",
  numericValidations = {},
  value: passedValue = ""
}) => {
  const {
    clearErrors,
    formState: { errors },
    setError
  } = (0, import_react_hook_form7.useFormContext)();
  const errorKey = `${id}-error`;
  const validate = (value) => {
    if (disabled) {
      return true;
    }
    const { isValid, errortext } = runValidations({ id, required, validations, value, wasMaybeTouched: !!errors[id] });
    if (isValid) {
      clearErrors(errorKey);
    } else {
      setError(errorKey, { type: "validate", message: errortext });
    }
    return isValid || errortext;
  };
  return /* @__PURE__ */ (0, import_jsx_runtime16.jsx)(
    import_react_hook_form7.Controller,
    {
      name: id,
      control,
      rules: { required, validate, ...numericValidations },
      render: ({ field: { value, onChange, onBlur, ref }, fieldState: { error } }) => /* @__PURE__ */ (0, import_jsx_runtime16.jsxs)(import_material13.FormControl, { className: `${className} ${required ? "required" : ""}`, error: Boolean(error?.message || errors[errorKey]), style: { width: 400 }, children: [
        /* @__PURE__ */ (0, import_jsx_runtime16.jsx)(import_material13.InputLabel, { htmlFor: id, ...InputLabelProps, children: label }),
        /* @__PURE__ */ (0, import_jsx_runtime16.jsx)(
          import_material13.OutlinedInput,
          {
            autoComplete: autocomplete,
            id,
            label,
            name: id,
            disabled,
            inputRef: (inputRef) => {
              ref(inputRef);
              if (controlRef) {
                controlRef.current = inputRef;
              }
            },
            value: value ?? passedValue,
            onChange: ({ target: { value: value2 } }) => onChange(value2),
            onBlur,
            placeholder: hint,
            type,
            ...InputProps
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime16.jsx)(import_material13.FormHelperText, { children: (errors[errorKey] || error)?.message })
      ] })
    }
  );
};

// src/forms/TimeframePicker.tsx
var import_react10 = require("react");
var import_react_hook_form8 = require("react-hook-form");
var import_DatePicker = require("@mui/x-date-pickers/DatePicker");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_jsx_runtime17 = require("react/jsx-runtime");
var ensureStartOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T00:00:00.000`;
};
var ensureEndOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T23:59:59.999`;
};
var TimeframePicker = ({
  tonight: propsTonight,
  format = "YYYY-MM-DD",
  fromLabel = "From",
  toLabel = "To",
  slotProps = {},
  fallbackValue = (0, import_dayjs.default)()
}) => {
  const [tonight] = (0, import_react10.useState)((0, import_dayjs.default)(propsTonight));
  const [maxStartDate, setMaxStartDate] = (0, import_react10.useState)(tonight);
  const [minEndDate, setMinEndDate] = (0, import_react10.useState)(tonight);
  const { control, setValue, watch, getValues } = (0, import_react_hook_form8.useFormContext)();
  const startDate = watch("startDate");
  const endDate = watch("endDate");
  (0, import_react10.useEffect)(() => {
    const currentEndDate = getValues("endDate");
    const now = (/* @__PURE__ */ new Date()).toISOString().replace("Z", "");
    if (startDate > currentEndDate) {
      setValue("endDate", ensureEndOfDay(startDate));
    } else if (currentEndDate > now) {
      setValue("endDate", now);
    }
    setMinEndDate((0, import_dayjs.default)(startDate));
  }, [startDate, getValues, setValue]);
  (0, import_react10.useEffect)(() => {
    const currentStartDate = getValues("startDate");
    if (endDate < currentStartDate) {
      setValue("startDate", ensureStartOfDay(endDate));
    }
    setMaxStartDate((0, import_dayjs.default)(endDate));
  }, [endDate, getValues, setValue]);
  const handleChangeStartDate = (date) => ensureStartOfDay(date);
  const handleChangeEndDate = (date) => ensureEndOfDay(date);
  return /* @__PURE__ */ (0, import_jsx_runtime17.jsxs)("div", { className: "flexbox", style: { flexWrap: "wrap", gap: 15 }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime17.jsx)(
      import_react_hook_form8.Controller,
      {
        name: "startDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime17.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "From"
                }
              })
            },
            yearsOrder: "desc",
            label: fromLabel,
            maxDate: maxStartDate,
            onChange: (e) => onChange(handleChangeStartDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime17.jsx)(
      import_react_hook_form8.Controller,
      {
        name: "endDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime17.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "To"
                }
              })
            },
            yearsOrder: "desc",
            label: toLabel,
            minDate: minEndDate,
            onChange: (e) => onChange(handleChangeEndDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    )
  ] });
};

// src/ConfirmModal.tsx
var import_react11 = require("react");
var import_material14 = require("@mui/material");
var import_jsx_runtime18 = require("react/jsx-runtime");
var ConfirmModal = (props) => {
  const { close, onConfirm, className = "", toType, header, description, open, maxWidth = "xs" } = props;
  const [inputValue, setInputValue] = (0, import_react11.useState)("");
  return /* @__PURE__ */ (0, import_jsx_runtime18.jsxs)(
    BaseDialog,
    {
      title: header,
      className,
      open,
      onClose: close,
      maxWidth,
      slotProps: {
        paper: {
          component: "form",
          onSubmit: (event) => {
            event.preventDefault();
            onConfirm();
            close();
          }
        }
      },
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime18.jsxs)(import_material14.DialogContent, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime18.jsx)(import_material14.DialogContentText, { className: "margin-bottom-small", children: description }),
          /* @__PURE__ */ (0, import_jsx_runtime18.jsxs)(import_material14.DialogContentText, { className: "margin-bottom-small", children: [
            "Type '",
            toType,
            "' below to continue"
          ] }),
          /* @__PURE__ */ (0, import_jsx_runtime18.jsx)(
            import_material14.TextField,
            {
              value: inputValue,
              onChange: (e) => setInputValue(e.target.value),
              autoFocus: true,
              required: true,
              name: "confirmation-text",
              id: "confirmation-text",
              label: toType,
              type: "text"
            }
          )
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime18.jsxs)(import_material14.DialogActions, { children: [
          /* @__PURE__ */ (0, import_jsx_runtime18.jsx)(import_material14.Button, { onClick: close, size: "small", children: "Cancel" }),
          /* @__PURE__ */ (0, import_jsx_runtime18.jsx)(import_material14.Button, { color: "secondary", type: "submit", variant: "contained", disabled: inputValue !== toType, size: "small", children: "Confirm" })
        ] })
      ]
    }
  );
};

// src/Alert.tsx
var import_jsx_runtime19 = require("react/jsx-runtime");
var Alert = ({ children, className = "", style }) => /* @__PURE__ */ (0, import_jsx_runtime19.jsx)("div", { className, style, children });
var Alert_default = Alert;

// src/AsyncAutocomplete.tsx
var import_react12 = require("react");
var import_material15 = require("@mui/material");
var import_constants6 = require("@northern.tech/store/constants");
var import_debouncehook3 = require("@northern.tech/utils/debouncehook");

// src/Loader.tsx
var import_jsx_runtime20 = require("react/jsx-runtime");
var Loader = (props) => {
  const { fade, show, small, style, table, waiting } = props;
  const hideClass = fade ? "hidden" : "loaderContainer shrunk";
  const showClass = table ? "miniLoaderContainer" : "loaderContainer";
  return /* @__PURE__ */ (0, import_jsx_runtime20.jsx)("div", { style, className: show ? showClass : hideClass, children: /* @__PURE__ */ (0, import_jsx_runtime20.jsxs)("div", { className: `${small ? "small" : ""} ${waiting ? "waiting-loader" : ""} loader`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime20.jsx)("span", { className: "dot dot_1" }),
    /* @__PURE__ */ (0, import_jsx_runtime20.jsx)("span", { className: "dot dot_2" }),
    /* @__PURE__ */ (0, import_jsx_runtime20.jsx)("span", { className: "dot dot_3" }),
    /* @__PURE__ */ (0, import_jsx_runtime20.jsx)("span", { className: "dot dot_4" })
  ] }) });
};
var Loader_default = Loader;

// src/AsyncAutocomplete.tsx
var import_jsx_runtime21 = require("react/jsx-runtime");
var AsyncAutocomplete = ({
  id,
  initialValue,
  isLoading,
  label,
  placeholder,
  styles,
  selectionAttribute,
  labelAttribute,
  onChange,
  onChangeSelection,
  options
}) => {
  const theme = (0, import_material15.useTheme)();
  const [open, setOpen] = (0, import_react12.useState)(false);
  const [inputValue, setInputValue] = (0, import_react12.useState)(initialValue);
  const loading = open && isLoading;
  const debouncedValue = (0, import_debouncehook3.useDebounce)(inputValue, import_constants6.TIMEOUTS.debounceShort);
  (0, import_react12.useEffect)(() => {
    if (debouncedValue === void 0) {
      return;
    }
    const selection = options.find((option) => option[selectionAttribute] === debouncedValue);
    if (selection) {
      onChangeSelection(selection);
    } else {
      onChange(debouncedValue);
    }
  }, [debouncedValue, JSON.stringify(options), onChange, onChangeSelection, selectionAttribute]);
  const onInputChange = (e, value, reason) => {
    if (reason === "clear") {
      setInputValue("");
      return onChangeSelection();
    } else if (reason === "reset" && !e || reason === "blur") {
      return;
    }
    setInputValue(value);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime21.jsx)(
    import_material15.Autocomplete,
    {
      autoHighlight: true,
      freeSolo: true,
      getOptionLabel: (option) => option[labelAttribute],
      isOptionEqualToValue: (option, value) => option[selectionAttribute] === value[selectionAttribute],
      id,
      inputValue: inputValue || "",
      loading,
      onClose: () => setOpen(false),
      onInputChange,
      onOpen: () => setOpen(true),
      open,
      openOnFocus: true,
      options,
      renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime21.jsx)(
        import_material15.TextField,
        {
          ...params,
          label,
          placeholder,
          style: styles.textField,
          slotProps: {
            input: {
              ...params.InputProps,
              endAdornment: /* @__PURE__ */ (0, import_jsx_runtime21.jsxs)(import_jsx_runtime21.Fragment, { children: [
                loading && /* @__PURE__ */ (0, import_jsx_runtime21.jsx)(Loader_default, { show: true, small: true, table: true, style: { marginTop: theme.spacing(-4) } }),
                params.InputProps.endAdornment
              ] })
            }
          }
        }
      )
    }
  );
};

// src/ChipSelect.tsx
var import_react13 = require("react");
var import_react_hook_form9 = require("react-hook-form");
var import_icons_material6 = require("@mui/icons-material");
var import_material16 = require("@mui/material");
var import_helpers3 = require("@northern.tech/utils/helpers");
var import_jsx_runtime22 = require("react/jsx-runtime");
var import_react14 = require("react");
var ChipSelect = ({ className = "", name, disabled = false, helperText, inputRef, label = "", options = [], placeholder = "" }) => {
  const [value, setValue] = (0, import_react13.useState)("");
  const { control, getValues } = (0, import_react_hook_form9.useFormContext)();
  const onTextInputChange = (inputValue, reason, setCurrentSelection) => {
    const value2 = inputValue || "";
    if (reason === "clear") {
      setValue("");
      return setCurrentSelection([]);
    } else if (reason === "reset") {
      return setValue("");
    }
    const lastIndex = value2.lastIndexOf(",");
    const possibleSelection = value2.substring(0, lastIndex).split(",").filter(import_helpers3.duplicateFilter);
    const currentValue = value2.substring(lastIndex + 1);
    const selection = getValues(name);
    const nextSelection = (0, import_helpers3.unionizeStrings)(selection, possibleSelection);
    setValue(currentValue);
    setCurrentSelection(nextSelection);
  };
  const onTextInputLeave = (value2, setCurrentSelection) => {
    const selection = getValues(name);
    const nextSelection = (0, import_helpers3.unionizeStrings)(selection, [value2]);
    setCurrentSelection(nextSelection);
    setValue("");
  };
  return /* @__PURE__ */ (0, import_jsx_runtime22.jsx)(
    import_react_hook_form9.Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, value: currentSelection, ref, ...props } }) => /* @__PURE__ */ (0, import_jsx_runtime22.jsx)(
        import_material16.Autocomplete,
        {
          id: `${name}-chip-select`,
          value: currentSelection,
          className,
          filterSelectedOptions: true,
          freeSolo: true,
          includeInputInList: true,
          multiple: true,
          onChange: (e, value2) => e.key !== "Backspace" ? formOnChange(value2) : null,
          onInputChange: (e, v, reason) => onTextInputChange(null, reason, formOnChange),
          options,
          readOnly: disabled,
          ref,
          renderTags: (values, getTagProps) => values.map((option, index) => {
            const { key, onDelete, ...tagProps } = getTagProps({ index });
            return /* @__PURE__ */ (0, import_jsx_runtime22.jsx)(import_material16.Chip, { label: option, onDelete, deleteIcon: /* @__PURE__ */ (0, import_jsx_runtime22.jsx)(import_icons_material6.Cancel, { onClick: onDelete, "aria-label": `${name}-delete` }), ...tagProps }, key);
          }),
          renderInput: (params) => /* @__PURE__ */ (0, import_react14.createElement)(
            import_material16.TextField,
            {
              ...params,
              fullWidth: true,
              slotProps: {
                htmlInput: { ...params.inputProps, value },
                input: params.InputProps
              },
              key: `${name}-input`,
              label,
              variant: disabled ? "standard" : "outlined",
              onBlur: (e) => onTextInputLeave(e.target.value, formOnChange),
              onChange: (e) => onTextInputChange(e.target.value, "input", formOnChange),
              placeholder: currentSelection.length ? "" : placeholder,
              helperText,
              inputRef
            }
          ),
          ...props
        }
      )
    }
  );
};

// src/ConfigurationObject.tsx
var import_react15 = __toESM(require("react"), 1);
var import_icons_material7 = require("@mui/icons-material");
var import_material17 = require("@mui/material");
var import_mui6 = require("tss-react/mui");
var import_copy_to_clipboard2 = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime23 = require("react/jsx-runtime");
var useStyles6 = (0, import_mui6.makeStyles)()((theme) => ({
  root: {
    [".key > b"]: {
      backgroundColor: theme.palette.grey[400],
      color: theme.palette.getContrastText(theme.palette.grey[400])
    }
  }
}));
var cutoffLength = 100;
var ValueColumn = ({ value = "", setSnackbar: setSnackbar2 }) => {
  const [tooltipVisible, setTooltipVisible] = (0, import_react15.useState)(false);
  const isComponent = import_react15.default.isValidElement(value);
  const onClick = () => {
    if (setSnackbar2) {
      let copyable = value;
      if (isComponent) {
        copyable = value.props.value;
      }
      (0, import_copy_to_clipboard2.default)(copyable);
      setSnackbar2("Value copied to clipboard");
    }
  };
  let shownValue = value;
  if (!isComponent) {
    shownValue = /* @__PURE__ */ (0, import_jsx_runtime23.jsx)("div", { title: value, children: value.length > cutoffLength ? `${value.substring(0, cutoffLength - 3)}...` : value });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime23.jsxs)(
    "div",
    {
      className: `flexbox ${setSnackbar2 ? "clickable" : ""}`,
      onClick,
      onMouseEnter: () => setTooltipVisible(true),
      onMouseLeave: () => setTooltipVisible(false),
      children: [
        shownValue,
        setSnackbar2 && /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(import_material17.Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(import_icons_material7.FileCopyOutlined, { color: "primary", className: `margin-left-small ${tooltipVisible ? "fadeIn" : "fadeOut"}`, fontSize: "small" }) })
      ]
    }
  );
};
var KeyColumn = ({ value, chipLikeKey }) => /* @__PURE__ */ (0, import_jsx_runtime23.jsx)("div", { className: `align-right ${chipLikeKey ? "key" : ""} muted`, children: /* @__PURE__ */ (0, import_jsx_runtime23.jsx)("b", { children: value }) });
var TwoColumns = ({
  className = "",
  children = void 0,
  chipLikeKey = true,
  compact = false,
  items = {},
  KeyComponent = KeyColumn,
  KeyProps = {},
  setSnackbar: setSnackbar2,
  style = {},
  ValueComponent = ValueColumn,
  ValueProps = {}
}) => {
  const { classes } = useStyles6();
  return /* @__PURE__ */ (0, import_jsx_runtime23.jsx)("div", { className: `break-all two-columns ${classes.root} ${compact ? "compact" : ""} ${className}`, style, children: children ? children : Object.entries(items).map(([key, value]) => /* @__PURE__ */ (0, import_jsx_runtime23.jsxs)(import_react15.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(KeyComponent, { chipLikeKey, value: key, ...KeyProps }),
    /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(ValueComponent, { setSnackbar: setSnackbar2, value, ...ValueProps })
  ] }, key)) });
};
var TwoColumnData = ({ className = "", config, ...props }) => /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(TwoColumns, { className: `column-data ${className}`, items: config, ...props });
var TwoColumnDataMultiple = ({ className = "", config, style, ...props }) => /* @__PURE__ */ (0, import_jsx_runtime23.jsx)("div", { className: `two-columns-multiple ${className}`, style: { ...style }, children: Object.entries(config).map(([key, value]) => /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(TwoColumnData, { className: "multiple", config: { [key]: value }, compact: true, ...props }, key)) });
var ConfigurationObject = ({ config, ...props }) => {
  const content = Object.entries(config).reduce((accu, [key, value]) => {
    accu[key] = `${value}`;
    return accu;
  }, {});
  return /* @__PURE__ */ (0, import_jsx_runtime23.jsx)(TwoColumnData, { ...props, config: content });
};

// src/Confirm.tsx
var import_react16 = require("react");
var import_icons_material8 = require("@mui/icons-material");
var import_material18 = require("@mui/material");
var import_jsx_runtime24 = require("react/jsx-runtime");
var defaultRemoving = "Removing...";
var confirmationType = {
  retry: {
    loading: "Creating new deployment...",
    message: "Confirm retry?"
  },
  abort: {
    loading: "Aborting...",
    message: "Confirm abort?"
  },
  chartRemoval: {
    loading: defaultRemoving,
    message: "Remove this chart?"
  },
  decommissioning: {
    loading: "Decommissioning...",
    message: "Decommission this device and remove all of its data from the server. This cannot be undone. Are you sure?"
  },
  deploymentContinuation: {
    loading: "Continuing...",
    message: "All devices with no errors will continue to the next step of the updates. Confirm continue?"
  },
  deploymentAbort: {
    loading: "Aborting...",
    message: "This will abort the deployment and attempt to roll back all devices. Confirm abort?"
  },
  integrationRemoval: {
    loading: defaultRemoving,
    message: "Remove the ingration. Are you sure?"
  },
  webhooksRemoval: {
    loading: defaultRemoving,
    message: "Delete all webhooks?"
  }
};
var Confirm = ({ action, cancel, classes = "", message = "", style = {}, type }) => {
  const [className, setClassName] = (0, import_react16.useState)("fadeIn");
  const [loading, setLoading] = (0, import_react16.useState)(false);
  const handleCancel = () => {
    setClassName("fadeOut");
    cancel();
  };
  const handleConfirm = () => {
    setLoading(true);
    action();
  };
  let notification = message;
  if (confirmationType[type]) {
    notification = loading ? confirmationType[type].loading : confirmationType[type].message;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime24.jsxs)("div", { className: `flexbox center-aligned ${className} ${classes}`, style: { marginRight: "12px", justifyContent: "flex-end", ...style }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime24.jsx)("span", { className: "bold", children: notification }),
    /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_material18.IconButton, { id: "confirmAbort", onClick: handleConfirm, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_icons_material8.CheckCircle, { className: "green" }) }),
    /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_material18.IconButton, { onClick: handleCancel, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_icons_material8.Cancel, { className: "red" }) })
  ] });
};
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_material18.Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_icons_material8.Edit, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ (0, import_jsx_runtime24.jsxs)("div", { className: "flexbox", children: [
  /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_material18.IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_icons_material8.Check, { color: "disabled" }) }),
  /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_material18.IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ (0, import_jsx_runtime24.jsx)(import_icons_material8.Close, { color: "disabled" }) })
] });

// src/CopyText.tsx
var import_react17 = require("react");
var import_react_copy_to_clipboard3 = __toESM(require("react-copy-to-clipboard"), 1);
var import_icons_material9 = require("@mui/icons-material");
var import_material19 = require("@mui/material");
var import_mui7 = require("tss-react/mui");
var import_constants7 = require("@northern.tech/store/constants");
var import_jsx_runtime25 = require("react/jsx-runtime");
var useStyles7 = (0, import_mui7.makeStyles)()(() => ({
  copyNotification: { height: 15 }
}));
var CopyTextToClipboard = ({ notify = true, onCopy = import_constants7.yes, token }) => {
  const [copied, setCopied] = (0, import_react17.useState)(false);
  const { classes } = useStyles7();
  const timer = (0, import_react17.useRef)(void 0);
  (0, import_react17.useEffect)(() => () => clearTimeout(timer.current), []);
  const onCopied = () => {
    setCopied(true);
    onCopy();
    timer.current = setTimeout(() => setCopied(false), import_constants7.TIMEOUTS.fiveSeconds);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime25.jsxs)("div", { children: [
    /* @__PURE__ */ (0, import_jsx_runtime25.jsx)(import_react_copy_to_clipboard3.default, { text: token, onCopy: onCopied, children: /* @__PURE__ */ (0, import_jsx_runtime25.jsx)(import_material19.Button, { startIcon: /* @__PURE__ */ (0, import_jsx_runtime25.jsx)(import_icons_material9.FileCopy, {}), children: "Copy to clipboard" }) }),
    notify && /* @__PURE__ */ (0, import_jsx_runtime25.jsx)("p", { className: classes.copyNotification, children: copied && /* @__PURE__ */ (0, import_jsx_runtime25.jsx)("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
  ] });
};

// src/DetailsIndicator.tsx
var import_icons_material10 = require("@mui/icons-material");
var import_jsx_runtime26 = require("react/jsx-runtime");
var defaultClasses = { icon: "", wrapper: "" };
var DetailsIndicator = ({ classes = defaultClasses }) => {
  const { icon = "", wrapper = "" } = classes;
  return /* @__PURE__ */ (0, import_jsx_runtime26.jsxs)("div", { className: `bold flexbox center-aligned link-color nowrap ${wrapper}`, children: [
    "View details",
    /* @__PURE__ */ (0, import_jsx_runtime26.jsx)(import_icons_material10.ArrowForward, { className: `margin-left-xsmall ${icon}`, fontSize: "small" })
  ] });
};

// src/DetailsTable.tsx
var import_icons_material11 = require("@mui/icons-material");
var import_material20 = require("@mui/material");
var import_mui8 = require("tss-react/mui");
var import_constants8 = require("@northern.tech/store/constants");
var import_jsx_runtime27 = require("react/jsx-runtime");
var useStyles8 = (0, import_mui8.makeStyles)()(() => ({
  header: {
    ".columnHeader": {
      display: "table-cell"
    },
    ".columnHeader .sortIcon": {
      marginBottom: -6
    },
    ".nonSortable": { cursor: "initial" }
  }
}));
var DetailsTable = ({
  className = "",
  columns,
  items,
  onChangeSorting,
  onItemClick,
  sort = {},
  style = {},
  tableRef,
  onRowSelected,
  selectedRows = []
}) => {
  const { classes } = useStyles8();
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRows];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    onRowSelected(updatedSelection);
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: items.length }, (_, index) => index);
    if (selectedRows.length && selectedRows.length <= items.length) {
      newSelectedRows = [];
    }
    onRowSelected(newSelectedRows);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime27.jsxs)(import_material20.Table, { className: `margin-bottom ${className}`, style, ref: tableRef, children: [
    /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.TableHead, { className: classes.header, children: /* @__PURE__ */ (0, import_jsx_runtime27.jsxs)(import_material20.TableRow, { children: [
      onRowSelected !== void 0 && /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.TableCell, { children: /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.Checkbox, { indeterminate: false, checked: selectedRows.length === items.length, onChange: onSelectAllClick }) }),
      columns.map(({ extras, key, renderTitle, sortable, title }) => /* @__PURE__ */ (0, import_jsx_runtime27.jsxs)(import_material20.TableCell, { className: `columnHeader ${sortable ? "" : "nonSortable"}`, onClick: () => sortable ? onChangeSorting(key) : null, children: [
        renderTitle ? renderTitle(extras) : title,
        sortable && /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_icons_material11.Sort, { className: `sortIcon ${sort.key === key ? "selected" : ""} ${(sort.direction === import_constants8.SORTING_OPTIONS.desc).toString()}` })
      ] }, key))
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.TableBody, { children: items.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime27.jsxs)(import_material20.TableRow, { className: onItemClick ? "clickable" : "", hover: true, children: [
      onRowSelected !== void 0 && /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.TableCell, { children: /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.Checkbox, { checked: selectedRows.includes(index), onChange: () => onRowSelection(index) }) }),
      columns.map((column) => /* @__PURE__ */ (0, import_jsx_runtime27.jsx)(import_material20.TableCell, { className: "relative", onClick: () => onItemClick ? onItemClick(item) : null, children: column.render(item, column.extras) }, column.key))
    ] }, item.id || index)) })
  ] });
};

// src/DeviceIdentity.tsx
var import_react19 = require("react");
var import_react_redux4 = require("react-redux");
var import_mui10 = require("tss-react/mui");
var import_selectors2 = require("@northern.tech/store/selectors");
var import_helpers4 = require("@northern.tech/utils/helpers");

// ../../assets/img/gateway-connection.svg
var gateway_connection_default = "./gateway-connection-TS7NBQVB.svg";

// ../../assets/img/gateway.svg
var gateway_default = "./gateway-XAJR5DH4.svg";

// src/DeviceNameInput.tsx
var import_react18 = require("react");
var import_material21 = require("@mui/material");
var import_mui9 = require("tss-react/mui");
var import_store2 = require("@northern.tech/store/store");
var import_thunks4 = require("@northern.tech/store/thunks");
var import_jsx_runtime28 = require("react/jsx-runtime");
var useStyles9 = (0, import_mui9.makeStyles)()((theme) => ({
  icon: {
    fontSize: "1.25rem"
  },
  input: {
    color: theme.palette.text.primary,
    fontSize: "0.8125rem"
  }
}));
var DeviceNameInput = ({ device, isHovered }) => {
  const [isEditing, setIsEditing] = (0, import_react18.useState)(false);
  const [value, setValue] = (0, import_react18.useState)("");
  const { classes } = useStyles9();
  const inputRef = (0, import_react18.useRef)(void 0);
  const dispatch = (0, import_store2.useAppDispatch)();
  const { id = "", tags = {} } = device;
  const { name = "" } = tags;
  (0, import_react18.useEffect)(() => {
    if (!isEditing && name !== value) {
      setValue(name);
    }
  }, [device, isEditing, name, value]);
  (0, import_react18.useEffect)(() => {
    if (!isEditing || !inputRef.current) {
      return;
    }
    inputRef.current.focus();
  }, [isEditing]);
  const onSubmit = () => dispatch((0, import_thunks4.setDeviceTags)({ deviceId: id, tags: { ...tags, name: value } })).then(() => setIsEditing(false));
  const onCancel = () => {
    setValue(name);
    setIsEditing(false);
  };
  const onStartEdit = (e) => {
    e.stopPropagation();
    setIsEditing(true);
  };
  const onInputClick = (e) => e.stopPropagation();
  return /* @__PURE__ */ (0, import_jsx_runtime28.jsx)(
    import_material21.OutlinedInput,
    {
      id: `${device.id}-id-input`,
      className: classes.input,
      disabled: !isEditing,
      inputRef,
      value,
      placeholder: `${id.substring(0, 6)}...`,
      onClick: onInputClick,
      onChange: ({ target: { value: value2 } }) => setValue(value2),
      type: "text",
      endAdornment: (isHovered || isEditing) && /* @__PURE__ */ (0, import_jsx_runtime28.jsx)(import_material21.InputAdornment, { position: "end", children: isEditing ? /* @__PURE__ */ (0, import_jsx_runtime28.jsx)(ConfirmationButtons, { onCancel, onConfirm: onSubmit }) : /* @__PURE__ */ (0, import_jsx_runtime28.jsx)(EditButton, { onClick: onStartEdit }) })
    }
  );
};
var DeviceNameInput_default = DeviceNameInput;

// src/DeviceIdentity.tsx
var import_jsx_runtime29 = require("react/jsx-runtime");
var useStyles10 = (0, import_mui10.makeStyles)()((theme) => ({
  container: {
    gridTemplateColumns: "1fr max-content",
    columnGap: theme.spacing()
  },
  gatewayIcon: {
    color: theme.palette.grey[400],
    width: "max-content",
    marginRight: theme.spacing()
  }
}));
var propertyNameMap = {
  inventory: "attributes",
  identity: "identity_data",
  system: "system",
  monitor: "monitor",
  tags: "tags"
};
var defaultTextRender = ({ column, device }) => {
  const propertyName = propertyNameMap[column.attribute.scope] ?? column.attribute.scope;
  const accessorTarget = device[propertyName] ?? device;
  const attributeValue = accessorTarget[column.attribute.name] || device[column.attribute.name];
  return (typeof attributeValue === "object" ? JSON.stringify(attributeValue) : attributeValue) ?? "-";
};
var getDeviceIdentityText = ({ device = {}, idAttribute }) => {
  const { id = "", identity_data = {}, tags = {} } = device;
  const { status, ...remainingIds } = identity_data;
  const nonIdKey = Object.keys(remainingIds)[0];
  if (!idAttribute || idAttribute === "id" || idAttribute === "Device ID") {
    return id;
  } else if (typeof idAttribute === "string" || !Object.keys(idAttribute).length) {
    return identity_data[idAttribute] ?? identity_data[nonIdKey] ?? id;
  }
  const { attribute, scope } = idAttribute;
  if (attribute === "name" && scope === "tags") {
    return tags[attribute] ?? `${id.substring(0, 6)}...`;
  }
  return defaultTextRender({ column: { attribute: { name: attribute, scope } }, device });
};
var DeviceIdComponent = ({ style = {}, value }) => /* @__PURE__ */ (0, import_jsx_runtime29.jsx)("div", { style, children: value });
var attributeComponentMap = {
  default: DeviceIdComponent,
  name: DeviceNameInput_default
};
var adornments = [
  {
    component: gateway_connection_default,
    isApplicable: ({ attributes = {} }) => !(0, import_helpers4.stringToBoolean)(attributes.mender_is_gateway) && !!attributes.mender_gateway_system_id
  },
  { component: gateway_default, isApplicable: ({ attributes = {} }) => (0, import_helpers4.stringToBoolean)(attributes.mender_is_gateway) }
];
var DeviceIdentityDisplay = (props) => {
  const { device = {}, isEditable = true, hasAdornment = true } = props;
  const idAttribute = (0, import_react_redux4.useSelector)(import_selectors2.getIdAttribute);
  const { attribute, scope } = idAttribute;
  const stateDevice = (0, import_react_redux4.useSelector)((state) => (0, import_selectors2.getDeviceById)(state, device.id));
  const idValue = getDeviceIdentityText({ device: { ...device, ...stateDevice }, idAttribute });
  const { classes } = useStyles10();
  let Component = attributeComponentMap.default;
  if (attribute === "name" && scope === "tags") {
    Component = isEditable ? attributeComponentMap.name : Component;
  }
  const { attributes = {} } = device;
  const EndAdornment = (0, import_react19.useMemo)(
    () => adornments.find((item) => item.isApplicable(device))?.component,
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [attributes.mender_is_gateway, attributes.mender_gateway_system_id]
  );
  return (
    // due to the specificity of the deviceListRow child class, applying the display styling through the container class doesn't work, thus the inline style in addition here
    /* @__PURE__ */ (0, import_jsx_runtime29.jsxs)("div", { className: classes.container, style: { display: "grid" }, children: [
      /* @__PURE__ */ (0, import_jsx_runtime29.jsx)(Component, { ...props, value: idValue }),
      hasAdornment && EndAdornment && /* @__PURE__ */ (0, import_jsx_runtime29.jsx)(EndAdornment, { className: classes.gatewayIcon })
    ] })
  );
};

// src/DocsLink.tsx
var import_react21 = require("react");
var import_react_redux5 = require("react-redux");
var import_icons_material12 = require("@mui/icons-material");
var import_material23 = require("@mui/material");
var import_mui12 = require("tss-react/mui");
var import_constants9 = require("@northern.tech/store/constants");
var import_selectors3 = require("@northern.tech/store/selectors");
var import_debouncehook4 = require("@northern.tech/utils/debouncehook");

// src/helptips/MenderTooltip.tsx
var import_react20 = require("react");
var import_material22 = require("@mui/material");
var import_mui11 = require("tss-react/mui");
var import_helpers5 = require("@northern.tech/utils/helpers");
var import_jsx_runtime30 = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui11.withStyles)(import_material22.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltipClickable = ({
  children,
  onboarding,
  startOpen = false,
  visibility = startOpen,
  onOpenChange,
  tooltipComponent = MenderTooltip,
  ...remainingProps
}) => {
  const [open, setOpen] = (0, import_react20.useState)(startOpen || false);
  (0, import_react20.useEffect)(() => {
    setOpen(visibility);
  }, [visibility]);
  (0, import_react20.useEffect)(() => {
    if (!onOpenChange) {
      return;
    }
    onOpenChange(open);
  }, [open, onOpenChange]);
  const toggleVisibility = () => setOpen(import_helpers5.toggle);
  const hide = () => setOpen(false);
  const Component = tooltipComponent;
  const extraProps = onboarding ? {
    PopperProps: {
      disablePortal: true,
      popperOptions: {
        strategy: "fixed",
        modifiers: [
          { name: "flip", enabled: false },
          { name: "preventOverflow", enabled: true, options: { boundary: window, altBoundary: false } }
        ]
      }
    }
  } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime30.jsx)(import_material22.ClickAwayListener, { onClickAway: hide, children: /* @__PURE__ */ (0, import_jsx_runtime30.jsx)(
    Component,
    {
      arrow: !onboarding,
      open,
      disableFocusListener: true,
      disableHoverListener: true,
      disableTouchListener: true,
      onOpen: () => setOpen(true),
      ...extraProps,
      ...remainingProps,
      children: /* @__PURE__ */ (0, import_jsx_runtime30.jsx)("div", { onClick: toggleVisibility, children })
    }
  ) });
};
var MenderTooltip_default = MenderTooltip;

// src/DocsLink.tsx
var import_jsx_runtime31 = require("react/jsx-runtime");
var useStyles11 = (0, import_mui12.makeStyles)()((theme) => ({
  iconAura: {
    position: "absolute",
    top: -6,
    bottom: -4,
    left: -7,
    right: -6.5,
    border: `1px dashed ${theme.palette.text.disabled}`,
    borderRadius: "50%",
    "&.hovering": {
      borderColor: "transparent"
    }
  },
  chip: {
    borderStyle: "dashed",
    [`.${import_material23.chipClasses.deleteIcon}`]: {
      fontSize: "smaller"
    },
    "&.not-hovering": {
      borderColor: "transparent",
      color: theme.palette.text.disabled,
      [`.${import_material23.chipClasses.deleteIcon}`]: {
        color: theme.palette.text.disabled
      },
      [`.${import_material23.chipClasses.label}`]: {
        paddingLeft: 0,
        visibility: "collapse"
      }
    }
  }
}));
var DOCSTIPS = {
  deviceConfig: { id: "deviceConfig", path: "add-ons/configure" },
  dynamicGroups: { id: "dynamicGroups", path: "overview/device-group#dynamic-group" },
  limitedDeployments: { id: "limitedDeployments", path: "overview/deployment#deployment-to-dynamic-groups" },
  phasedDeployments: { id: "phasedDeployments", path: "overview/customize-the-update-process" },
  pausedDeployments: { id: "pausedDeployments", path: "overview/customize-the-update-process#synchronized-updates" },
  retryDeployments: { id: "retryDeployments", path: "overview/deployment" },
  releases: { id: "releases", path: "overview/artifact" },
  rbac: { id: "rbac", path: "overview/role.based.access.control" },
  webhookSecret: { id: "webhookSecret", path: "server-integration/webhooks#signature-header" }
};
var DocsTooltip = ({ anchor = {}, id = "", ...props }) => {
  const [isHovering, setIsHovering] = (0, import_react21.useState)(false);
  const debouncedHovering = (0, import_debouncehook4.useDebounce)(isHovering, import_constants9.TIMEOUTS.debounceDefault);
  const docsVersion = (0, import_react_redux5.useSelector)(import_selectors3.getDocsVersion);
  const { isHosted } = (0, import_react_redux5.useSelector)(import_selectors3.getFeatures);
  const { classes } = useStyles11();
  const { content, path } = DOCSTIPS[id] || {};
  const target = `https://docs.mender.io/${docsVersion}${path}`;
  const onClick = () => {
    const docsParams = { headers: { "x-mender-docs": docsVersion } };
    fetch(target, isHosted ? {} : docsParams);
    window.open(target, "_blank");
  };
  const hoverClass = debouncedHovering ? "hovering" : "not-hovering";
  return /* @__PURE__ */ (0, import_jsx_runtime31.jsx)(
    MenderTooltipClickable,
    {
      placement: "bottom-start",
      disableFocusListener: false,
      disableHoverListener: false,
      disableTouchListener: false,
      style: anchor,
      title: content,
      ...props,
      children: /* @__PURE__ */ (0, import_jsx_runtime31.jsx)(
        import_material23.Chip,
        {
          color: "primary",
          className: `${classes.chip} ${hoverClass}`,
          label: /* @__PURE__ */ (0, import_jsx_runtime31.jsx)(import_material23.Collapse, { in: debouncedHovering, orientation: "horizontal", children: "Learn more" }),
          deleteIcon: /* @__PURE__ */ (0, import_jsx_runtime31.jsxs)("div", { className: "relative", children: [
            /* @__PURE__ */ (0, import_jsx_runtime31.jsx)(import_icons_material12.Description, { fontSize: "small" }),
            /* @__PURE__ */ (0, import_jsx_runtime31.jsx)("div", { className: `${classes.iconAura} ${hoverClass}` })
          ] }),
          onClick,
          onDelete: onClick,
          onMouseOver: () => setIsHovering(true),
          onMouseOut: () => setIsHovering(false),
          variant: "outlined"
        }
      )
    }
  );
};
var DocsLink = (0, import_react21.forwardRef)(({ children, className = "", path, title = "", ...remainder }, ref) => {
  const docsVersion = (0, import_react_redux5.useSelector)(import_selectors3.getDocsVersion);
  const { isHosted } = (0, import_react_redux5.useSelector)(import_selectors3.getFeatures);
  const target = `https://docs.mender.io/${path}`;
  const onClickHandler = () => {
    const docsParams = { headers: { "x-mender-docs": docsVersion } };
    fetch(target, isHosted ? {} : docsParams);
  };
  return (
    // eslint-disable-next-line react/jsx-no-target-blank
    /* @__PURE__ */ (0, import_jsx_runtime31.jsx)("a", { className, ...remainder, href: target, onClick: onClickHandler, ref, target: "_blank", rel: isHosted ? "noopener" : "", children: children ? children : title })
  );
});
DocsLink.displayName = "DocsLink";

// src/DrawerTitle.tsx
var import_icons_material13 = require("@mui/icons-material");
var import_material24 = require("@mui/material");
var import_jsx_runtime32 = require("react/jsx-runtime");
var DrawerTitle = ({ onClose, onLinkCopy, postTitle, preCloser, title }) => /* @__PURE__ */ (0, import_jsx_runtime32.jsxs)("div", { className: "flexbox margin-bottom-small space-between", children: [
  /* @__PURE__ */ (0, import_jsx_runtime32.jsxs)("div", { className: "flexbox center-aligned", children: [
    /* @__PURE__ */ (0, import_jsx_runtime32.jsx)("h3", { className: "capitalized-start flexbox center-aligned", children: title }),
    onLinkCopy && /* @__PURE__ */ (0, import_jsx_runtime32.jsx)(import_material24.IconButton, { onClick: onLinkCopy, size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime32.jsx)(import_icons_material13.Link, {}) }),
    postTitle
  ] }),
  /* @__PURE__ */ (0, import_jsx_runtime32.jsxs)("div", { className: "flexbox center-aligned", children: [
    preCloser,
    /* @__PURE__ */ (0, import_jsx_runtime32.jsx)(import_material24.IconButton, { onClick: onClose, "aria-label": "close", size: "large", children: /* @__PURE__ */ (0, import_jsx_runtime32.jsx)(import_icons_material13.Close, {}) })
  ] })
] });

// src/EditableLongText.tsx
var import_react23 = require("react");
var import_material26 = require("@mui/material");
var import_mui13 = require("tss-react/mui");
var import_helpers7 = require("@northern.tech/utils/helpers");

// src/ExpandableAttribute.tsx
var import_react22 = require("react");
var import_icons_material14 = require("@mui/icons-material");
var import_material25 = require("@mui/material");
var import_helpers6 = require("@northern.tech/utils/helpers");
var import_copy_to_clipboard3 = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime33 = require("react/jsx-runtime");
var defaultClasses2 = { root: "attributes" };
var ExpandableAttribute = ({
  className = "",
  copyToClipboard,
  dividerDisabled,
  onExpansion,
  primary,
  secondary,
  secondaryTypographyProps = {},
  setSnackbar: setSnackbar2,
  style,
  textClasses,
  ...remainder
}) => {
  const textContent = (0, import_react22.useRef)(null);
  const [expanded, setExpanded] = (0, import_react22.useState)(false);
  const [overflowActive, setOverflowActive] = (0, import_react22.useState)(false);
  const [tooltipVisible, setTooltipVisible] = (0, import_react22.useState)(false);
  (0, import_react22.useEffect)(() => {
    if (textContent.current) {
      const overflowActiveCurrently = textContent.current.scrollWidth > textContent.current.clientWidth || textContent.current.scrollHeight > textContent.current.clientHeight;
      if (overflowActive !== overflowActiveCurrently && !expanded) {
        setOverflowActive(overflowActiveCurrently);
      }
    }
  }, [expanded, overflowActive, textContent]);
  const onClick = (0, import_react22.useCallback)(() => {
    if (copyToClipboard && setSnackbar2) {
      (0, import_copy_to_clipboard3.default)(secondary);
      setSnackbar2("Value copied to clipboard");
    }
    if (!expanded && !!onExpansion) {
      onExpansion();
    }
    setExpanded(import_helpers6.toggle);
  }, [copyToClipboard, expanded, onExpansion, secondary, setSnackbar2]);
  const currentTextClasses = `${textClasses ? textClasses.secondary : "inventory-text"}${expanded && overflowActive ? " expanded-attribute" : ""}`;
  const secondaryText = /* @__PURE__ */ (0, import_jsx_runtime33.jsxs)(import_jsx_runtime33.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime33.jsx)("span", { className: currentTextClasses, ref: textContent, children: secondary }),
    " ",
    overflowActive ? /* @__PURE__ */ (0, import_jsx_runtime33.jsxs)("a", { children: [
      "show ",
      expanded ? "less" : "more"
    ] }) : null
  ] });
  const cssClasses = { ...defaultClasses2, root: `${defaultClasses2.root} ${copyToClipboard ? "copy-to-clipboard" : ""}`.trim() };
  return /* @__PURE__ */ (0, import_jsx_runtime33.jsx)("div", { className, onClick, onMouseEnter: () => setTooltipVisible(true), onMouseLeave: () => setTooltipVisible(false), style, children: /* @__PURE__ */ (0, import_jsx_runtime33.jsxs)(import_material25.ListItem, { classes: cssClasses, divider: !dividerDisabled, ...remainder, children: [
    /* @__PURE__ */ (0, import_jsx_runtime33.jsx)(
      import_material25.ListItemText,
      {
        primary,
        secondary: secondaryText,
        secondaryTypographyProps: { title: secondary, component: "div", ...secondaryTypographyProps }
      }
    ),
    copyToClipboard ? /* @__PURE__ */ (0, import_jsx_runtime33.jsx)(import_material25.Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ (0, import_jsx_runtime33.jsx)(import_icons_material14.FileCopyOutlined, { fontSize: "small" }) }) : null
  ] }) });
};
var ExpandableAttribute_default = ExpandableAttribute;

// src/EditableLongText.tsx
var import_jsx_runtime34 = require("react/jsx-runtime");
var useStyles12 = (0, import_mui13.makeStyles)()((theme) => ({
  notes: { display: "block", whiteSpace: "pre-wrap" },
  // @ts-expect-error: type misalignment in styleOverride root type
  notesWrapper: { minWidth: theme.components?.MuiFormControl?.styleOverrides?.root?.minWidth }
}));
var EditableLongText = ({ contentFallback = "", fullWidth, original, onChange, placeholder = "-" }) => {
  const [isEditing, setIsEditing] = (0, import_react23.useState)(false);
  const [value, setValue] = (0, import_react23.useState)(original);
  const { classes } = useStyles12();
  (0, import_react23.useEffect)(() => {
    setValue(original);
  }, [original]);
  const onCancelClick = () => {
    setValue(original);
    setIsEditing(false);
  };
  const onEdit = ({ target: { value: value2 } }) => setValue(value2);
  const onEditClick = () => setIsEditing(true);
  const onToggleEditing = (0, import_react23.useCallback)(
    (event) => {
      event.stopPropagation();
      if (event.key && (event.key !== "Enter" || event.shiftKey)) {
        return;
      }
      if (isEditing) {
        onChange(value);
      }
      setIsEditing(import_helpers7.toggle);
    },
    [isEditing, onChange, value]
  );
  const fullWidthClass = fullWidth ? "full-width" : "";
  return /* @__PURE__ */ (0, import_jsx_runtime34.jsx)("div", { className: "flexbox", style: { alignItems: "end" }, children: isEditing ? /* @__PURE__ */ (0, import_jsx_runtime34.jsxs)(import_jsx_runtime34.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime34.jsx)(
      import_material26.TextField,
      {
        className: `margin-right ${fullWidthClass}`,
        multiline: true,
        onChange: onEdit,
        onKeyDown: onToggleEditing,
        placeholder,
        value
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime34.jsx)(ConfirmationButtons, { onCancel: onCancelClick, onConfirm: onToggleEditing })
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime34.jsxs)(import_jsx_runtime34.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime34.jsx)(
      ExpandableAttribute_default,
      {
        className: `${fullWidthClass} margin-right ${classes.notesWrapper}`,
        component: "div",
        dense: true,
        disableGutters: true,
        primary: "",
        secondary: original || value || contentFallback,
        textClasses: { secondary: classes.notes }
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime34.jsx)(EditButton, { onClick: onEditClick })
  ] }) });
};

// src/EnterpriseNotification.tsx
var import_react24 = require("react");
var import_react_redux6 = require("react-redux");
var import_react_router_dom = require("react-router-dom");
var import_material27 = require("@mui/material");
var import_mui14 = require("tss-react/mui");
var import_constants10 = require("@northern.tech/store/constants");
var import_selectors4 = require("@northern.tech/store/selectors");
var import_helpers8 = require("@northern.tech/utils/helpers");
var import_jsx_runtime35 = require("react/jsx-runtime");
var PlansTooltip = (0, import_mui14.withStyles)(MenderTooltip_default, ({ palette }) => ({
  arrow: {
    color: palette.tooltip?.tierTipBackground ?? palette.grey[100]
  },
  tooltip: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    maxWidth: 300
  }
}));
var PlanChip = (0, import_mui14.withStyles)(import_material27.Chip, ({ palette }) => ({
  root: {
    backgroundColor: palette.tooltip?.tierTipBackground ?? palette.grey[100],
    color: palette.text.disabled,
    textTransform: "uppercase",
    "&:hover": {
      fontWeight: "bold"
    }
  }
}));
var DefaultUpgradeNotification = (props) => /* @__PURE__ */ (0, import_jsx_runtime35.jsxs)("div", { ...props, children: [
  "This feature is not available on your plan. ",
  /* @__PURE__ */ (0, import_jsx_runtime35.jsx)(import_react_router_dom.Link, { to: "/subscription", children: "Upgrade" }),
  " to enable it"
] });
var EnterpriseNotification = ({ className = "", id = import_constants10.BENEFITS.default.id }) => {
  const [isOpen, setIsOpen] = (0, import_react24.useState)(false);
  const tenantCapabilities = (0, import_react_redux6.useSelector)(import_selectors4.getTenantCapabilities);
  const { isEnterprise, plan: currentPlan } = tenantCapabilities;
  const { benefit, requiredAddon = "", requiredPlan = import_constants10.PLANS.os.id } = import_constants10.BENEFITS[id];
  const hasAddon = requiredAddon ? import_constants10.ADDONS[requiredAddon].needs.every((need) => tenantCapabilities[need]) : false;
  const currentPlanIndex = Object.keys(import_constants10.PLANS).indexOf(currentPlan);
  const requiredPlanIndex = Object.keys(import_constants10.PLANS).indexOf(requiredPlan);
  const shouldShow = requiredPlanIndex > currentPlanIndex;
  if (isEnterprise || import_constants10.BENEFITS[id].requiredPlan && !shouldShow || requiredAddon && hasAddon) {
    return null;
  }
  const content = requiredAddon ? /* @__PURE__ */ (0, import_jsx_runtime35.jsxs)(import_jsx_runtime35.Fragment, { children: [
    "Add the ",
    /* @__PURE__ */ (0, import_jsx_runtime35.jsx)("b", { children: import_constants10.ADDONS[requiredAddon].title }),
    " add-on to ",
    benefit,
    "."
  ] }) : /* @__PURE__ */ (0, import_jsx_runtime35.jsxs)(import_jsx_runtime35.Fragment, { children: [
    "Upgrade to the ",
    /* @__PURE__ */ (0, import_jsx_runtime35.jsx)("b", { children: import_constants10.PLANS[requiredPlan].name }),
    " plan ",
    requiredPlanIndex === Object.keys(import_constants10.PLANS).length - 1 ? "" : "or higher ",
    "to gain access to ",
    benefit,
    "."
  ] });
  return /* @__PURE__ */ (0, import_jsx_runtime35.jsx)(
    MenderTooltipClickable,
    {
      onOpenChange: setIsOpen,
      title: /* @__PURE__ */ (0, import_jsx_runtime35.jsxs)("div", { children: [
        content,
        /* @__PURE__ */ (0, import_jsx_runtime35.jsxs)("div", { className: "flexbox space-between margin-top-small", children: [
          /* @__PURE__ */ (0, import_jsx_runtime35.jsx)(import_react_router_dom.Link, { to: "/subscription", children: "Upgrade now" }),
          /* @__PURE__ */ (0, import_jsx_runtime35.jsx)("span", { className: "link", onClick: () => setIsOpen(false), children: "Close" })
        ] })
      ] }),
      tooltipComponent: PlansTooltip,
      visibility: isOpen,
      children: /* @__PURE__ */ (0, import_jsx_runtime35.jsx)(PlanChip, { className, onClick: import_helpers8.yes, label: import_constants10.PLANS[requiredPlan].name })
    }
  );
};
var EnterpriseNotification_default = EnterpriseNotification;

// src/InfoHint.tsx
var import_icons_material15 = require("@mui/icons-material");
var import_mui16 = require("tss-react/mui");

// src/InfoText.tsx
var import_mui15 = require("tss-react/mui");
var import_jsx_runtime36 = require("react/jsx-runtime");
var useStyles13 = (0, import_mui15.makeStyles)()((theme) => ({
  default: { color: theme.palette.text.disabled, margin: "15px 0" }
}));
var InfoText = ({ children, className = "", variant, ...props }) => {
  const { classes } = useStyles13();
  const Component = variant === "dense" ? "span" : "p";
  return /* @__PURE__ */ (0, import_jsx_runtime36.jsx)(Component, { className: `${classes.default} ${className}`, ...props, children });
};
var InfoText_default = InfoText;

// src/InfoHint.tsx
var import_jsx_runtime37 = require("react/jsx-runtime");
var useStyles14 = (0, import_mui16.makeStyles)()((theme) => ({
  container: { gap: theme.spacing(2) },
  default: { gap: theme.spacing() }
}));
var InfoHint = ({ className = "", content, ...props }) => {
  const { classes } = useStyles14();
  return /* @__PURE__ */ (0, import_jsx_runtime37.jsxs)(InfoText_default, { className: `icon flexbox center-aligned ${classes.default} ${className}`, ...props, children: [
    /* @__PURE__ */ (0, import_jsx_runtime37.jsx)(import_icons_material15.InfoOutlined, { fontSize: "small" }),
    content
  ] });
};
var InfoHintContainer = ({ children, className = "margin-left-small", ...props }) => {
  const { classes } = useStyles14();
  return /* @__PURE__ */ (0, import_jsx_runtime37.jsx)("div", { className: `flexbox center-aligned ${className} ${classes.container}`, ...props, children });
};

// src/LeftNav.tsx
var import_react25 = __toESM(require("react"), 1);
var import_react_router_dom2 = require("react-router-dom");
var import_material28 = require("@mui/material");
var import_ListItemText = require("@mui/material/ListItemText");
var import_mui17 = require("tss-react/mui");
var import_utils2 = require("@northern.tech/store/utils");
var import_jsx_runtime38 = require("react/jsx-runtime");
var useStyles15 = (0, import_mui17.makeStyles)()((theme) => ({
  list: {
    [`&.navLink .${import_ListItemText.listItemTextClasses.root}`]: {
      color: (0, import_utils2.isDarkMode)(theme.palette.mode) ? theme.palette.text.primary : theme.palette.grey[900]
    },
    [`&.navLink.active .${import_ListItemText.listItemTextClasses.root}`]: {
      color: (0, import_utils2.isDarkMode)(theme.palette.mode) ? theme.palette.grey[900] : theme.palette.text.primary
    },
    "&.active": {
      background: theme.palette.grey[400]
    }
  },
  listItem: {
    [`.${import_ListItemText.listItemTextClasses.primary}`]: {
      fontSize: "0.8rem",
      "&:hover": {
        color: theme.palette.primary.main
      }
    }
  }
}));
var LeftNav = ({ sections }) => {
  const { classes } = useStyles15();
  return /* @__PURE__ */ (0, import_jsx_runtime38.jsx)(import_material28.List, { className: "leftFixed", children: sections.map(({ itemClass = "", items = [], title = "" }, index) => /* @__PURE__ */ (0, import_jsx_runtime38.jsxs)(import_react25.default.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime38.jsx)(import_material28.ListSubheader, { disableSticky: true, children: title }),
    items.map(({ exact, path, icon = null, style = {}, title: title2 = "", url }) => {
      const props = url ? { component: "a", exact: `${exact}`, href: url, rel: "noopener", target: "_blank", to: url } : { component: import_react_router_dom2.NavLink, end: exact, to: path };
      return /* @__PURE__ */ (0, import_jsx_runtime38.jsxs)(import_material28.ListItem, { className: `navLink ${itemClass} ${classes.list}`, style, ...props, children: [
        /* @__PURE__ */ (0, import_jsx_runtime38.jsx)(import_material28.ListItemText, { className: classes.listItem, primary: title2, url }),
        !!icon && /* @__PURE__ */ (0, import_jsx_runtime38.jsx)(import_material28.ListItemIcon, { children: icon })
      ] }, path);
    })
  ] }, `${itemClass}-${index}`)) });
};

// src/LinedHeader.tsx
var import_mui18 = require("tss-react/mui");
var import_jsx_runtime39 = require("react/jsx-runtime");
var useStyles16 = (0, import_mui18.makeStyles)()((theme) => ({
  border: {
    borderBottom: `1px solid ${theme.palette.grey[50]}`,
    span: {
      background: theme.palette.background.default
    }
  },
  groupBorder: {
    background: theme.palette.grey[50]
  },
  groupHeading: {
    background: theme.palette.background.default
  }
}));
var LinedHeader = ({ className = "", heading, innerStyle = {}, innerRef, style = {} }) => {
  const { classes } = useStyles16();
  return /* @__PURE__ */ (0, import_jsx_runtime39.jsx)("h4", { className: `dashboard-header ${classes.border} ${className}`, ref: innerRef, style, children: /* @__PURE__ */ (0, import_jsx_runtime39.jsx)("span", { style: innerStyle, children: heading }) });
};
var LinedGroupHeader = ({ heading }) => {
  const { classes } = useStyles16();
  return /* @__PURE__ */ (0, import_jsx_runtime39.jsxs)(import_jsx_runtime39.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime39.jsx)("span", { className: classes.groupHeading, children: heading }),
    /* @__PURE__ */ (0, import_jsx_runtime39.jsx)("div", { className: classes.groupBorder })
  ] });
};
var LinedHeader_default = LinedHeader;

// src/List.tsx
var import_react27 = require("react");
var import_icons_material17 = require("@mui/icons-material");
var import_material30 = require("@mui/material");
var import_mui19 = require("tss-react/mui");
var import_constants12 = require("@northern.tech/store/constants");
var import_utils3 = require("@northern.tech/store/utils");
var import_helpers9 = require("@northern.tech/utils/helpers");
var import_resizehook = require("@northern.tech/utils/resizehook");

// src/Pagination.tsx
var import_react26 = require("react");
var import_icons_material16 = require("@mui/icons-material");
var import_material29 = require("@mui/material");
var import_constants11 = require("@northern.tech/store/constants");
var import_debouncehook5 = require("@northern.tech/utils/debouncehook");
var import_jsx_runtime40 = require("react/jsx-runtime");
var defaultRowsPerPageOptions = [10, 20, import_constants11.DEVICE_LIST_MAXIMUM_LENGTH];
var { perPage: defaultPerPage } = import_constants11.DEVICE_LIST_DEFAULTS;
var paginationIndex = 1;
var paginationLimit = 1e4;
var MaybeWrapper = ({ children, disabled }) => disabled ? /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(MenderTooltip_default, { arrow: true, placement: "top", title: "Please refine your filter criteria first in order to proceed.", children: /* @__PURE__ */ (0, import_jsx_runtime40.jsx)("div", { children }) }) : /* @__PURE__ */ (0, import_jsx_runtime40.jsx)("div", { children });
var TablePaginationActions = ({ count, page = 0, onPageChange, rowsPerPage = defaultPerPage, showCountInfo = true }) => {
  const [pageNo, setPageNo] = (0, import_react26.useState)(page + paginationIndex);
  (0, import_react26.useEffect)(() => {
    setPageNo(page + paginationIndex);
  }, [page, rowsPerPage, count]);
  const debouncedPage = (0, import_debouncehook5.useDebounce)(pageNo, import_constants11.TIMEOUTS.debounceShort);
  (0, import_react26.useEffect)(() => {
    const newPage = Math.min(Math.max(paginationIndex, debouncedPage), Math.max(paginationIndex, Math.ceil(count / rowsPerPage)));
    if (newPage !== page + paginationIndex) {
      onPageChange(newPage);
    }
  }, [count, debouncedPage, onPageChange, page, rowsPerPage]);
  const pages = Math.ceil(count / rowsPerPage);
  const isAtPaginationLimit = pageNo >= paginationLimit / rowsPerPage;
  return /* @__PURE__ */ (0, import_jsx_runtime40.jsxs)("div", { className: "flexbox center-aligned", children: [
    showCountInfo && /* @__PURE__ */ (0, import_jsx_runtime40.jsx)("div", { children: `${(pageNo - paginationIndex) * rowsPerPage + 1}-${Math.min(pageNo * rowsPerPage, count)} of ${count}` }),
    /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(import_material29.IconButton, { onClick: () => setPageNo(pageNo - 1), disabled: pageNo === paginationIndex, size: "large", "aria-label": "prev", children: /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(import_icons_material16.KeyboardArrowLeft, {}) }),
    /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(MaybeWrapper, { disabled: isAtPaginationLimit, children: /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(import_material29.IconButton, { onClick: () => setPageNo(pageNo + 1), disabled: pageNo >= pages || isAtPaginationLimit, size: "large", "aria-label": "next", children: /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(import_icons_material16.KeyboardArrowRight, {}) }) })
  ] });
};
var Pagination = (props) => {
  const { className, onChangeRowsPerPage, onChangePage, page = 0, rowsPerPageOptions = defaultRowsPerPageOptions, showCountInfo, ...remainingProps } = props;
  const propsPage = Math.max(page - paginationIndex, 0);
  return /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(
    import_material29.TablePagination,
    {
      className: `flexbox margin-top ${className || ""}`,
      classes: { spacer: "flexbox no-basis" },
      component: "div",
      labelDisplayedRows: () => "",
      labelRowsPerPage: "Rows",
      slotProps: { select: { name: "pagination" } },
      rowsPerPageOptions,
      onRowsPerPageChange: (e) => onChangeRowsPerPage(e.target.value),
      page: propsPage,
      onPageChange: onChangePage,
      ActionsComponent: (actionProps) => /* @__PURE__ */ (0, import_jsx_runtime40.jsx)(TablePaginationActions, { ...actionProps, showCountInfo }),
      ...remainingProps
    }
  );
};
var areEqual = (prevProps, nextProps) => Math.floor(prevProps.count / prevProps.rowsPerPage) === Math.floor(nextProps.count / nextProps.rowsPerPage) && prevProps.page === nextProps.page && prevProps.rowsPerPage === nextProps.rowsPerPage && prevProps.disabled === nextProps.disabled;
var Pagination_default = (0, import_react26.memo)(Pagination, areEqual);

// src/List.tsx
var import_jsx_runtime41 = require("react/jsx-runtime");
var { page: defaultPage, perPage: defaultPerPage2 } = import_constants12.DEVICE_LIST_DEFAULTS;
var useStyles17 = (0, import_mui19.makeStyles)()((theme) => ({
  header: {
    // @ts-ignore
    color: theme.palette.text.hint
  },
  resizer: {
    cursor: "col-resize",
    paddingLeft: 5,
    paddingRight: 5
  },
  resizeHandle: {
    width: 4,
    background: "initial",
    ["&.hovering"]: {
      background: theme.palette.grey[600]
    },
    ["&.resizing"]: {
      background: (0, import_utils3.isDarkMode)(theme.palette.mode) ? theme.palette.grey[200] : theme.palette.grey[900]
    }
  }
}));
var minCellWidth = 150;
var calculateResizeChange = ({ columnElements, columnHeaders, e, index, prev, selectable }) => {
  const isShrinkage = prev > e.clientX ? -1 : 1;
  const columnDelta = Math.abs(e.clientX - prev) * isShrinkage;
  const relevantColumns = getRelevantColumns(columnElements, selectable);
  const canModifyNextColumn = index + 1 < columnHeaders.length - 1;
  return relevantColumns.reduce((accu, element, columnIndex) => {
    const currentWidth = element.offsetWidth;
    const column = { attribute: columnHeaders[columnIndex + 1].attribute, size: currentWidth };
    if (canModifyNextColumn && index === columnIndex) {
      column.size = currentWidth + columnDelta;
    } else if (canModifyNextColumn && index + 1 === columnIndex) {
      column.size = currentWidth - columnDelta;
    }
    accu.push(column);
    return accu;
  }, []);
};
var getRelevantColumns = (columnElements, selectable) => [...columnElements].slice(selectable ? 1 : 0, columnElements.length - 1);
var getTemplateColumns = (columns, selectable) => selectable ? `52px ${columns} minmax(${minCellWidth}px, 1fr)` : `${columns} minmax(${minCellWidth}px, 1fr)`;
var getColumnsStyle = (columns, defaultSize, selectable) => {
  const template = columns.map(({ size }) => `minmax(${minCellWidth}px, ${size ? `${size}px` : defaultSize})`);
  return getTemplateColumns(template.join(" "), selectable);
};
var CommonList = (props) => {
  const {
    columnHeaders,
    customColumnSizes = [],
    listItems,
    listState,
    idAttribute,
    onChangeRowsPerPage,
    PaginationProps = {},
    onExpandClick,
    onResizeColumns,
    onPageChange,
    onSelect,
    onSort = () => {
    },
    pageLoading,
    sortingNotes,
    ListItemComponent
  } = props;
  const { page: pageNo = defaultPage, perPage: pageLength = defaultPerPage2, selection: selectedRows = [], sort = {}, total: pageTotal = 1 } = listState;
  const { direction: sortDown = import_constants12.SORTING_OPTIONS.desc, key: sortCol } = sort;
  const listRef = (0, import_react27.useRef)(null);
  const selectedRowsRef = (0, import_react27.useRef)(selectedRows);
  const initRef = (0, import_react27.useRef)(null);
  const [resizeTrigger, setResizeTrigger] = (0, import_react27.useState)(false);
  const size = (0, import_resizehook.useWindowSize)();
  const selectable = !!onSelect;
  const { classes } = useStyles17();
  (0, import_react27.useEffect)(() => {
    selectedRowsRef.current = selectedRows;
  }, [selectedRows]);
  (0, import_react27.useEffect)(() => {
    if (!listRef.current) {
      return;
    }
    const relevantColumns = getRelevantColumns(listRef.current?.querySelector(".deviceListRow")?.children, selectable);
    listRef.current.style.gridTemplateColumns = getColumnsStyle(
      customColumnSizes.length && customColumnSizes.length === relevantColumns.length ? customColumnSizes : relevantColumns,
      "1.5fr",
      selectable
    );
  }, [customColumnSizes, columnHeaders, selectable, resizeTrigger, size.width]);
  (0, import_react27.useEffect)(() => {
    clearTimeout(initRef.current || void 0);
    initRef.current = setTimeout(() => setResizeTrigger(import_helpers9.toggle), import_constants12.TIMEOUTS.debounceDefault);
    return () => {
      clearTimeout(initRef?.current || void 0);
    };
  }, [customColumnSizes.length]);
  const onRowSelection = (selectedRow) => {
    const updatedSelection = [...selectedRowsRef.current];
    const selectedIndex = updatedSelection.indexOf(selectedRow);
    if (selectedIndex === -1) {
      updatedSelection.push(selectedRow);
    } else {
      updatedSelection.splice(selectedIndex, 1);
    }
    if (onSelect) {
      onSelect(updatedSelection);
    }
  };
  const onSelectAllClick = () => {
    let newSelectedRows = Array.from({ length: listItems.length }, (_, i) => i);
    if (selectedRows.length && selectedRows.length <= listItems.length) {
      newSelectedRows = [];
    }
    if (onSelect) {
      onSelect(newSelectedRows);
    }
  };
  const handleResizeChange = (0, import_react27.useCallback)(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: [...ref.current.parentElement.children],
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (listRef.current) listRef.current.style.gridTemplateColumns = getColumnsStyle(changedColumns, void 0, selectable);
    },
    [columnHeaders, selectable]
  );
  const handleResizeFinish = (0, import_react27.useCallback)(
    (e, { index, prev, ref }) => {
      const changedColumns = calculateResizeChange({
        columnElements: ref.current.parentElement.children,
        columnHeaders,
        e,
        index,
        prev,
        selectable
      });
      if (onResizeColumns) {
        onResizeColumns(changedColumns);
      }
    },
    [columnHeaders, onResizeColumns, selectable]
  );
  const numSelected = (selectedRows || []).length;
  return /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: `deviceList ${selectable ? "selectable" : ""}`, ref: listRef, children: [
    /* @__PURE__ */ (0, import_jsx_runtime41.jsx)("div", { className: `header ${classes.header}`, children: /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: "deviceListRow", children: [
      selectable && /* @__PURE__ */ (0, import_jsx_runtime41.jsx)("div", { children: /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(
        import_material30.Checkbox,
        {
          indeterminate: numSelected > 0 && numSelected < listItems.length,
          checked: numSelected === listItems.length,
          onChange: onSelectAllClick
        }
      ) }),
      columnHeaders.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(
        HeaderItem,
        {
          column: item,
          columnCount: columnHeaders.length,
          index,
          onSort,
          resizable: !!onResizeColumns,
          sortCol,
          sortDown,
          onResizeChange: handleResizeChange,
          onResizeFinish: handleResizeFinish,
          sortingNotes
        },
        `columnHeader-${index}`
      ))
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime41.jsx)("div", { className: "body", children: listItems.map((item, index) => /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(
      ListItemComponent,
      {
        columnHeaders,
        listItem: item,
        listState,
        idAttribute,
        index,
        onClick: onExpandClick,
        onRowSelect: onRowSelection,
        selectable,
        selected: selectedRows.indexOf(index) !== -1
      },
      item.id
    )) }),
    /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: "footer flexbox margin-top", children: [
      /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(
        Pagination_default,
        {
          className: "margin-top-none",
          count: pageTotal,
          rowsPerPage: pageLength,
          onChangeRowsPerPage,
          page: pageNo,
          onChangePage: onPageChange,
          ...PaginationProps
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(Loader_default, { show: pageLoading, small: true })
    ] })
  ] });
};
var HeaderItem = (props) => {
  const { sortingNotes, column, columnCount, index, sortCol, sortDown = void 0, onSort, onResizeChange, onResizeFinish, resizable } = props;
  const [isHovering, setIsHovering] = (0, import_react27.useState)(false);
  const [shouldRemoveListeners, setShouldRemoveListeners] = (0, import_react27.useState)(false);
  const resizeRef = (0, import_react27.useRef)(null);
  const ref = (0, import_react27.useRef)(null);
  const { classes } = useStyles17();
  const onMouseOut = () => setIsHovering(false);
  const onMouseOver = () => setIsHovering(true);
  const mouseMove = (0, import_react27.useCallback)(
    (e) => {
      if (resizable && resizeRef.current) {
        onResizeChange(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = e.clientX;
      }
    },
    [index, onResizeChange, resizable]
  );
  const mouseUp = (0, import_react27.useCallback)(
    (e) => {
      if (resizeRef.current) {
        onResizeFinish(e, { index, prev: resizeRef.current, ref });
        resizeRef.current = null;
        setShouldRemoveListeners(true);
      }
    },
    [index, onResizeFinish]
  );
  const mouseDown = (e) => resizeRef.current = e.clientX;
  (0, import_react27.useEffect)(() => {
    window.addEventListener("mousemove", mouseMove);
    window.addEventListener("mouseup", mouseUp);
    return () => {
      setShouldRemoveListeners(!!resizeRef.current);
    };
  }, [mouseMove, mouseUp]);
  (0, import_react27.useEffect)(() => {
    if (shouldRemoveListeners) {
      window.removeEventListener("mousemove", mouseMove);
      window.removeEventListener("mouseup", mouseUp);
      setShouldRemoveListeners(false);
    }
  }, [shouldRemoveListeners, mouseMove, mouseUp]);
  let resizeHandleClassName = resizable && isHovering ? "hovering" : "";
  resizeHandleClassName = resizeRef.current ? "resizing" : resizeHandleClassName;
  const header = /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: "columnHeader flexbox space-between relative", style: column.style, onMouseEnter: onMouseOver, onMouseLeave: onMouseOut, ref, children: [
    /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: "flexbox center-aligned", onClick: () => onSort(column.attribute ? column.attribute : {}), children: [
      column.title,
      column.sortable && /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(
        import_icons_material17.Sort,
        {
          className: `sortIcon ${sortCol === column.attribute.name ? "selected" : ""} ${(sortDown === import_constants12.SORTING_OPTIONS.desc).toString()}`,
          style: { fontSize: 16 }
        }
      )
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime41.jsxs)("div", { className: "flexbox center-aligned full-height", children: [
      column.customize && /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(import_icons_material17.Settings, { onClick: column.customize, style: { fontSize: 16 } }),
      index < columnCount - 2 && resizable && /* @__PURE__ */ (0, import_jsx_runtime41.jsx)("div", { onMouseDown: mouseDown, className: `${classes.resizer} full-height`, children: /* @__PURE__ */ (0, import_jsx_runtime41.jsx)("div", { className: `full-height ${classes.resizeHandle} ${resizeHandleClassName}` }) })
    ] })
  ] });
  return column.sortable && sortingNotes && sortingNotes[column.attribute.name] ? /* @__PURE__ */ (0, import_jsx_runtime41.jsx)(MenderTooltip_default, { title: sortingNotes[column.attribute.name], placement: "top-start", children: header }) : header;
};

// src/MaterialDesignIcon.tsx
var import_material31 = require("@mui/material");
var import_js = require("@mdi/js");
var import_jsx_runtime42 = require("react/jsx-runtime");
var MaterialDesignIcon = ({ className = "", path = import_js.mdiImageBrokenVariant, style = {} }) => /* @__PURE__ */ (0, import_jsx_runtime42.jsx)(import_material31.SvgIcon, { className, fontSize: "inherit", style, children: /* @__PURE__ */ (0, import_jsx_runtime42.jsx)("path", { d: path }) });
var MaterialDesignIcon_default = MaterialDesignIcon;

// src/Search.tsx
var import_react28 = require("react");
var import_react_hook_form10 = require("react-hook-form");
var import_icons_material18 = require("@mui/icons-material");
var import_material32 = require("@mui/material");
var import_constants13 = require("@northern.tech/store/constants");
var import_debouncehook6 = require("@northern.tech/utils/debouncehook");
var import_jsx_runtime43 = require("react/jsx-runtime");
var endAdornment = /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(import_material32.InputAdornment, { position: "end", children: /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(Loader_default, { show: true, small: true, style: { marginTop: -10 } }) });
var startAdornment = /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(import_material32.InputAdornment, { position: "start", children: /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(import_icons_material18.Search, { color: "disabled", fontSize: "small" }) });
var MINIMUM_SEARCH_LENGTH = 2;
var ControlledSearch = ({ className = "", isSearching, name = "search", onSearch, placeholder = "Search devices", style = {} }) => {
  const { control, watch } = (0, import_react_hook_form10.useFormContext)();
  const inputRef = (0, import_react28.useRef)();
  const focusLockRef = (0, import_react28.useRef)(true);
  const timer = (0, import_react28.useRef)();
  const triggerDebounceRef = (0, import_react28.useRef)(false);
  const searchValue = watch(name, "");
  const debouncedSearchTerm = (0, import_debouncehook6.useDebounce)(searchValue, import_constants13.TIMEOUTS.debounceDefault);
  const focusAndLock = () => {
    focusLockRef.current = false;
    inputRef.current.focus();
    clearTimeout(timer.current);
    triggerDebounceRef.current = false;
    timer.current = setTimeout(() => focusLockRef.current = true, import_constants13.TIMEOUTS.oneSecond);
  };
  (0, import_react28.useEffect)(
    () => () => {
      clearTimeout(timer.current);
    },
    []
  );
  (0, import_react28.useEffect)(() => {
    if (debouncedSearchTerm.length < MINIMUM_SEARCH_LENGTH || triggerDebounceRef.current) {
      return;
    }
    triggerDebounceRef.current = true;
    onSearch(debouncedSearchTerm).then(focusAndLock);
  }, [debouncedSearchTerm, onSearch]);
  const onTriggerSearch = (0, import_react28.useCallback)(
    ({ key }) => {
      if (key === "Enter" && (!debouncedSearchTerm || debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH)) {
        onSearch(debouncedSearchTerm).then(focusAndLock);
      }
    },
    [debouncedSearchTerm, onSearch]
  );
  const onFocus = (0, import_react28.useCallback)(() => {
    if (focusLockRef.current && debouncedSearchTerm.length >= MINIMUM_SEARCH_LENGTH) {
      onSearch(debouncedSearchTerm).then(focusAndLock);
    }
  }, [debouncedSearchTerm, onSearch]);
  const adornments2 = isSearching ? { startAdornment, endAdornment } : { startAdornment };
  return /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(
    import_react_hook_form10.Controller,
    {
      name,
      control,
      render: ({ field }) => /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(
        import_material32.TextField,
        {
          className,
          slotProps: { input: adornments2 },
          onKeyUp: onTriggerSearch,
          onFocus,
          placeholder,
          inputRef,
          size: "small",
          style,
          ...field
        }
      )
    }
  );
};
ControlledSearch.displayName = "ConnectedSearch";
var Search = (props) => {
  const { className = "", searchTerm, onSearch, trigger } = props;
  const methods = (0, import_react_hook_form10.useForm)({ mode: "onChange", defaultValues: { search: searchTerm ?? "" } });
  const { handleSubmit } = methods;
  const onSubmit = (0, import_react28.useCallback)((search) => onSearch(search, !trigger), [onSearch, trigger]);
  return /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(import_react_hook_form10.FormProvider, { ...methods, children: /* @__PURE__ */ (0, import_jsx_runtime43.jsxs)("form", { className, noValidate: true, onSubmit: handleSubmit(({ search }) => onSearch(search, !trigger)), children: [
    /* @__PURE__ */ (0, import_jsx_runtime43.jsx)(ControlledSearch, { ...props, onSearch: onSubmit }),
    /* @__PURE__ */ (0, import_jsx_runtime43.jsx)("input", { className: "hidden", type: "submit" })
  ] }) });
};
var Search_default = Search;

// src/SharedSnackbar.tsx
var import_react29 = require("react");
var import_material33 = require("@mui/material");
var import_copy_to_clipboard4 = __toESM(require("copy-to-clipboard"), 1);
var import_jsx_runtime44 = require("react/jsx-runtime");
var SharedSnackbar = ({ setSnackbar: setSnackbar2, snackbar }) => {
  const handleActionClick = () => {
    (0, import_copy_to_clipboard4.default)(snackbar.message);
    setSnackbar2("Copied to clipboard");
  };
  const onCloseSnackbar = (_, reason) => {
    const { onClose = false } = snackbar;
    if (onClose && reason === "clickaway") {
      return;
    }
    setSnackbar2("");
  };
  const { preventClickToCopy, ...snackProps } = snackbar;
  return /* @__PURE__ */ (0, import_jsx_runtime44.jsx)(
    import_material33.Snackbar,
    {
      ...snackProps,
      anchorOrigin: { vertical: "bottom", horizontal: "center" },
      style: { maxWidth: 900, height: "auto", lineHeight: "28px", padding: 24, whiteSpace: "pre-line" },
      onClick: preventClickToCopy ? void 0 : handleActionClick,
      onClose: onCloseSnackbar
    }
  );
};
var areEqual2 = (prevProps, nextProps) => {
  if (prevProps.snackbar.open != nextProps.snackbar.open || prevProps.snackbar.message != nextProps.snackbar.message) {
    return false;
  }
  return prevProps.snackbar.children != nextProps.snackbar.children;
};
var SharedSnackbar_default = (0, import_react29.memo)(SharedSnackbar, areEqual2);

// src/Time.tsx
var import_react30 = require("react");
var import_material34 = require("@mui/material");
var import_dayjs2 = __toESM(require("dayjs"), 1);
var import_relativeTime = __toESM(require("dayjs/plugin/relativeTime.js"), 1);
var import_pluralize = __toESM(require("pluralize"), 1);
var import_jsx_runtime45 = require("react/jsx-runtime");
var defaultDateFormat = "YYYY-MM-DD";
var defaultTimeFormat = `${defaultDateFormat} HH:mm`;
import_dayjs2.default.extend(import_relativeTime.default);
var Time = ({ value, relative, format = defaultTimeFormat, valueFormat, titleFormat = defaultTimeFormat, Component = "time", ...remainingProps }) => {
  if (!value) {
    value = (0, import_dayjs2.default)();
  }
  value = (0, import_dayjs2.default)(value, valueFormat, true);
  const machineReadable = value.format("YYYY-MM-DDTHH:mm:ssZ");
  const humanReadable = relative ? value.fromNow() : value.format(format);
  return /* @__PURE__ */ (0, import_jsx_runtime45.jsx)(Component, { title: relative ? value.format(titleFormat) : null, ...remainingProps, dateTime: machineReadable, children: humanReadable });
};
var MaybeTime = ({ className = "", value, ...remainingProps }) => value ? /* @__PURE__ */ (0, import_jsx_runtime45.jsx)(Time, { value, ...remainingProps }) : /* @__PURE__ */ (0, import_jsx_runtime45.jsx)("div", { className, children: "-" });
var cutoff = -5 * 60;
var RelativeTime = ({ className, shouldCount = "both", updateTime }) => {
  const [updatedTime, setUpdatedTime] = (0, import_react30.useState)();
  (0, import_react30.useEffect)(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? (0, import_dayjs2.default)(updateTime) : updatedTime2);
  }, [updateTime]);
  let timeDisplay = /* @__PURE__ */ (0, import_jsx_runtime45.jsx)(MaybeTime, { className, value: updatedTime });
  const diffSeconds = updatedTime ? updatedTime.diff((0, import_dayjs2.default)(), "seconds") : 0;
  if (updatedTime && diffSeconds > cutoff && (shouldCount === "both" || shouldCount === "up" && diffSeconds > 0 || shouldCount === "down" && diffSeconds < 0)) {
    timeDisplay = /* @__PURE__ */ (0, import_jsx_runtime45.jsx)("time", { className, dateTime: updatedTime, children: updatedTime.fromNow() });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime45.jsx)(import_material34.Tooltip, { title: updatedTime ? updatedTime.toDate().toString().slice(0, 33) : "", arrow: true, enterDelay: 500, children: /* @__PURE__ */ (0, import_jsx_runtime45.jsx)("span", { children: timeDisplay }) });
};
var cutoffDays = 14;
var ApproximateRelativeDate = ({ className, updateTime }) => {
  const [updatedTime, setUpdatedTime] = (0, import_react30.useState)();
  (0, import_react30.useEffect)(() => {
    setUpdatedTime((updatedTime2) => updateTime !== updatedTime2 ? (0, import_dayjs2.default)(updateTime) : updatedTime2);
  }, [updateTime]);
  const diff = updatedTime ? Math.abs(updatedTime.diff((0, import_dayjs2.default)(), "days")) : 0;
  if (updatedTime && diff <= cutoffDays) {
    return /* @__PURE__ */ (0, import_jsx_runtime45.jsx)("time", { className, dateTime: updatedTime.format(defaultDateFormat), children: diff !== 0 ? `${diff} ${(0, import_pluralize.default)("day", diff)} ago` : "today" });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime45.jsx)(MaybeTime, { className, value: updatedTime, format: defaultDateFormat, titleFormat: defaultDateFormat });
};

// src/xterm.tsx
var import_react31 = require("react");
var import_addon_fit = require("@xterm/addon-fit");
var import_addon_search = require("@xterm/addon-search");
var import_xterm = require("@xterm/xterm");
var import_xterm2 = require("@xterm/xterm/css/xterm.css");
var import_jsx_runtime46 = require("react/jsx-runtime");
var searchAddon = new import_addon_search.SearchAddon();
var fitAddon = new import_addon_fit.FitAddon();
var addons = [fitAddon, searchAddon];
var defaultOptions = { allowProposedApi: true, scrollback: 5e3 };
var Xterm = ({ className, customKeyEventHandler, options = {}, onResize, style, triggerResize, xtermRef, ...remainingProps }) => {
  (0, import_react31.useEffect)(() => {
    const { terminal, terminalRef } = xtermRef.current;
    terminal.current = new import_xterm.Terminal({ ...defaultOptions, ...options });
    addons.forEach((addon) => terminal.current.loadAddon(addon));
    Object.entries(remainingProps).forEach(([key, value]) => value ? terminal.current[key](value) : void 0);
    if (customKeyEventHandler) {
      terminal.current.attachCustomKeyEventHandler(customKeyEventHandler);
    }
    if (terminalRef.current) {
      terminal.current.open(terminalRef.current);
    }
    return () => {
      terminal.current.dispose();
    };
  }, [addons, customKeyEventHandler, JSON.stringify(options), Object.keys(remainingProps).join("")]);
  (0, import_react31.useEffect)(() => {
    if (!xtermRef.current.terminalRef.current) {
      return;
    }
    try {
      fitAddon.fit();
      const { rows = 40, cols = 80 } = fitAddon.proposeDimensions() || {};
      if (onResize) {
        onResize({ rows, cols });
      }
    } catch {
    }
  }, [triggerResize]);
  return /* @__PURE__ */ (0, import_jsx_runtime46.jsx)("div", { className, ref: xtermRef.current.terminalRef, style });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Alert,
  ApproximateRelativeDate,
  AsyncAutocomplete,
  ChipSelect,
  ClickFilter,
  Code,
  CommonList,
  ConfigurationObject,
  Confirm,
  ConfirmDismissHelptips,
  ConfirmModal,
  ConfirmationButtons,
  ControlledAutoComplete,
  ControlledSearch,
  CopyCode,
  CopyTextToClipboard,
  DOCSTIPS,
  DefaultUpgradeNotification,
  DetailsIndicator,
  DetailsTable,
  DeviceIdentityDisplay,
  DeviceNameInput,
  DocsLink,
  DocsTooltip,
  DrawerTitle,
  EditButton,
  EditableLongText,
  EnterpriseNotification,
  ExpandableAttribute,
  FeedbackDialog,
  FileUpload,
  Filters,
  Form,
  FormCheckbox,
  InfoHint,
  InfoHintContainer,
  InfoText,
  KeyValueEditor,
  LeftNav,
  LinedGroupHeader,
  LinedHeader,
  Loader,
  LogDialog,
  MaterialDesignIcon,
  MaybeTime,
  Pagination,
  PasswordInput,
  RelativeTime,
  Search,
  SharedSnackbar,
  StartupNotificationDialog,
  TablePaginationActions,
  TextInput,
  Time,
  TimeframePicker,
  TwoColumnData,
  TwoColumnDataMultiple,
  TwoColumns,
  Xterm,
  calculateResizeChange,
  confirmationType,
  defaultTextRender,
  getDeviceIdentityText,
  minCellWidth,
  runValidations
});
//# sourceMappingURL=index.cjs.map