import { Artifact } from './Artifact.cjs';
import { Deployment } from './Deployment.cjs';
import { Device } from './Device.cjs';
import { Tenant } from './Tenant.cjs';
import { User } from './User.cjs';
import './ArtifactInfo.cjs';
import './Update.cjs';
import './ArtifactTypeInfo.cjs';
import './UpdateFile.cjs';
import './DeploymentPhase.cjs';
import './DeploymentStatistics.cjs';
import './DeploymentStatusStatistics.cjs';
import './Filter.cjs';
import './FilterPredicate.cjs';
import './DeviceStatus.cjs';
import './TenantV1.cjs';
import './Addon.cjs';
import './Plan.cjs';
import './Features.cjs';
import './TenantAdditionalInfo.cjs';
import './TenantApiLimits.cjs';
import './ApiLimits.cjs';
import './ApiBurst.cjs';
import './ApiQuota.cjs';

/**
 * Various types of objects are supported.
 * Depending on the type of object different information will be available.
 */
type AuditLogObject = {
    /**
     * A unique identifier of the object.
     */
    id: string;
    /**
     * The type of the object.
     */
    type: AuditLogObject.type;
    tenant?: Tenant;
    user?: User;
    deployment?: Deployment;
    artifact?: Artifact;
    device?: Device;
};
declare namespace AuditLogObject {
    /**
     * The type of the object.
     */
    enum type {
        TENANT = "tenant",
        USER = "user",
        DEPLOYMENT = "deployment",
        ARTIFACT = "artifact",
        DEVICE = "device"
    }
}

export { AuditLogObject };
