"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Tracking: () => tracking_default,
  attributeDuplicateFilter: () => attributeDuplicateFilter,
  blobToString: () => blobToString,
  byteArrayToString: () => byteArrayToString,
  canAccess: () => canAccess,
  clearAllRetryTimers: () => clearAllRetryTimers,
  clearRetryTimer: () => clearRetryTimer,
  createDownload: () => createDownload,
  createFileDownload: () => createFileDownload,
  customSort: () => customSort,
  dateRangeToUnix: () => dateRangeToUnix,
  deepCompare: () => deepCompare,
  detectOsIdentifier: () => detectOsIdentifier,
  duplicateFilter: () => duplicateFilter,
  extractErrorMessage: () => extractErrorMessage,
  extractSoftware: () => extractSoftware,
  extractSoftwareItem: () => extractSoftwareItem,
  formatTime: () => formatTime,
  fullyDecodeURI: () => fullyDecodeURI,
  getDebConfigurationCode: () => getDebConfigurationCode,
  getDemoDeviceAddress: () => getDemoDeviceAddress,
  getFormattedSize: () => getFormattedSize,
  getISOStringBoundaries: () => getISOStringBoundaries,
  getSnackbarMessage: () => getSnackbarMessage,
  isEmpty: () => isEmpty,
  preformatWithRequestID: () => preformatWithRequestID,
  setRetryTimer: () => setRetryTimer,
  standardizePhases: () => standardizePhases,
  stringToBoolean: () => stringToBoolean,
  toggle: () => toggle,
  unionizeStrings: () => unionizeStrings,
  useDebounce: () => useDebounce,
  useWindowSize: () => useWindowSize,
  versionCompare: () => versionCompare,
  yes: () => yes
});
module.exports = __toCommonJS(index_exports);

// src/debouncehook.ts
var import_react = require("react");
var useDebounce = (value, delay) => {
  const [debouncedValue, setDebouncedValue] = (0, import_react.useState)(value);
  (0, import_react.useEffect)(() => {
    const timer = setTimeout(() => {
      setDebouncedValue(value);
    }, delay);
    return () => clearTimeout(timer);
  }, [value, delay]);
  return debouncedValue;
};

// src/helpers.ts
var import_dayjs = __toESM(require("dayjs"), 1);
var import_utc = __toESM(require("dayjs/plugin/utc.js"), 1);
var import_pluralize = __toESM(require("pluralize"), 1);
var import_universal_cookie = __toESM(require("universal-cookie"), 1);
import_dayjs.default.extend(import_utc.default);
var isEncoded = (uri = "") => uri !== decodeURIComponent(uri);
var fullyDecodeURI = (uri) => {
  while (isEncoded(uri)) {
    uri = decodeURIComponent(uri);
  }
  return uri;
};
var isEmpty = (obj) => {
  for (const _ in obj) {
    return false;
  }
  return true;
};
var yes = () => true;
var canAccess = yes;
var versionCompare = (v1, v2) => {
  const partsV1 = `${v1}`.split(".");
  const partsV2 = `${v2}`.split(".");
  for (let index = 0; index < partsV1.length; index++) {
    const numberV1 = partsV1[index];
    const numberV2 = partsV2[index];
    if (numberV1 > numberV2) {
      return 1;
    }
    if (numberV2 > numberV1) {
      return -1;
    }
  }
  return 0;
};
function deepCompare(...args) {
  let i, l, leftChain, rightChain;
  function compare2Objects(x, y) {
    let p;
    if (isNaN(x) && isNaN(y) && typeof x === "number" && typeof y === "number") {
      return true;
    }
    if (x === y) {
      return true;
    }
    if (typeof x === "function" && typeof y === "function" || x instanceof Date && y instanceof Date || x instanceof RegExp && y instanceof RegExp || x instanceof String && y instanceof String || x instanceof Number && y instanceof Number) {
      return x.toString() === y.toString();
    }
    if (!(x instanceof Object && y instanceof Object)) {
      return false;
    }
    if (x.isPrototypeOf(y) || y.isPrototypeOf(x)) {
      return false;
    }
    if (x.constructor !== y.constructor) {
      return false;
    }
    if (x.prototype !== y.prototype) {
      return false;
    }
    if (leftChain.indexOf(x) > -1 || rightChain.indexOf(y) > -1) {
      return false;
    }
    for (p in y) {
      if (y.hasOwnProperty(p) !== x.hasOwnProperty(p) || typeof y[p] !== typeof x[p]) {
        return false;
      }
    }
    for (p in x) {
      if (y.hasOwnProperty(p) !== x.hasOwnProperty(p) || typeof y[p] !== typeof x[p]) {
        return false;
      }
      switch (typeof x[p]) {
        case "object":
        case "function":
          leftChain.push(x);
          rightChain.push(y);
          if (!compare2Objects(x[p], y[p])) {
            return false;
          }
          leftChain.pop();
          rightChain.pop();
          break;
        default:
          if (x[p] !== y[p]) {
            return false;
          }
          break;
      }
    }
    return true;
  }
  if (args.length < 1) {
    return true;
  }
  for (i = 1, l = args.length; i < l; i++) {
    leftChain = [];
    rightChain = [];
    if (!compare2Objects(args[0], args[i])) {
      return false;
    }
  }
  return true;
}
var stringToBoolean = (content) => {
  if (!content) {
    return false;
  }
  const string = content + "";
  switch (string.trim().toLowerCase()) {
    case "true":
    case "yes":
    case "1":
      return true;
    case "false":
    case "no":
    case "0":
    case null:
      return false;
    default:
      return Boolean(string);
  }
};
var toggle = (current) => !current;
var formatTime = (date) => {
  if (date && Object.prototype.toString.call(date) === "[object Date]" && !isNaN(date)) {
    return date.toISOString().slice(0, -1);
  } else if (date) {
    return date.replace(" ", "T").replace(/ /g, "").replace("UTC", "");
  }
};
var customSort = (direction, field) => (a, b) => {
  if (typeof a[field] === "string") {
    const result = a[field].localeCompare(b[field], navigator.language, { sensitivity: "case" });
    return direction ? result * -1 : result;
  }
  if (a[field] > b[field]) return direction ? -1 : 1;
  if (a[field] < b[field]) return direction ? 1 : -1;
  return 0;
};
var duplicateFilter = (item, index, array) => array.indexOf(item) == index;
var attributeDuplicateFilter = (filterableArray, attributeName = "key") => filterableArray.filter(
  (item, index, array) => array.findIndex((filter) => filter[attributeName] === item[attributeName] && filter.scope === item.scope) == index
);
var unionizeStrings = (someStrings, someOtherStrings) => {
  const startingPoint = new Set(someStrings.filter((item) => item.length));
  const uniqueStrings = someOtherStrings.length ? someOtherStrings.reduce((accu, item) => {
    if (item.trim().length) {
      accu.add(item.trim());
    }
    return accu;
  }, startingPoint) : startingPoint;
  return [...uniqueStrings];
};
var getFormattedSize = (bytes) => {
  const suffixes = ["Bytes", "KB", "MB", "GB"];
  const i = Math.floor(Math.log(bytes) / Math.log(1024));
  if (!bytes) {
    return "0 Bytes";
  }
  return `${(bytes / Math.pow(1024, i)).toFixed(2)} ${suffixes[i]}`;
};
var collectAddressesFrom = (devices) => devices.reduce((collector, { attributes = {} }) => {
  const ips = Object.entries(attributes).reduce((accu, [name, value]) => {
    if (name.startsWith("ipv4")) {
      if (Array.isArray(value)) {
        const texts = value.map((text) => text.slice(0, text.indexOf("/")));
        accu.push(...texts);
      } else {
        const text = value.slice(0, value.indexOf("/"));
        accu.push(text);
      }
    }
    return accu;
  }, []);
  collector.push(...ips);
  return collector;
}, []);
var getDemoDeviceAddress = (devices, onboardingApproach) => {
  const defaultVitualizedIp = "10.0.2.15";
  const addresses = collectAddressesFrom(devices);
  const address = addresses.reduce((accu, item) => {
    if (accu && item === defaultVitualizedIp) {
      return accu;
    }
    return item;
  }, null);
  if (!address || onboardingApproach === "virtual" && (navigator.appVersion.indexOf("Win") != -1 || navigator.appVersion.indexOf("Mac") != -1)) {
    return "localhost";
  }
  return address;
};
var detectOsIdentifier = () => {
  if (navigator.appVersion.indexOf("Win") != -1) return "Windows";
  if (navigator.appVersion.indexOf("Mac") != -1) return "MacOs";
  if (navigator.appVersion.indexOf("X11") != -1) return "Unix";
  return "Linux";
};
var standardizePhases = (phases) => phases.map((phase, index) => {
  const standardizedPhase = { batch_size: phase.batch_size, start_ts: index };
  if (phase.delay) {
    standardizedPhase.delay = phase.delay;
    standardizedPhase.delayUnit = phase.delayUnit || "hours";
  }
  if (index === 0) {
    delete standardizedPhase.start_ts;
  }
  return standardizedPhase;
});
var getInstallScriptArgs = ({ isHosted, isPreRelease, hasMonitor }) => {
  let installScriptArgs = "--demo";
  installScriptArgs = isPreRelease ? `${installScriptArgs} -c experimental` : installScriptArgs;
  installScriptArgs = isHosted && hasMonitor ? `${installScriptArgs} --commercial` : installScriptArgs;
  installScriptArgs = isHosted ? `${installScriptArgs} --jwt-token $JWT_TOKEN` : installScriptArgs;
  return installScriptArgs;
};
var getSetupArgs = ({ deviceType = "generic-armv6", ipAddress, isDemoMode, tenantToken, isOnboarding }) => {
  let menderSetupArgs = `--quiet --device-type "${deviceType}"`;
  menderSetupArgs = tenantToken ? `${menderSetupArgs} --tenant-token $TENANT_TOKEN` : menderSetupArgs;
  menderSetupArgs = isDemoMode || isOnboarding ? `${menderSetupArgs} --demo` : `${menderSetupArgs} --retry-poll 300 --update-poll 1800 --inventory-poll 28800`;
  if (isDemoMode) {
    menderSetupArgs = `${menderSetupArgs}${ipAddress ? ` --server-ip ${ipAddress}` : ""}`;
  } else {
    menderSetupArgs = `${menderSetupArgs} --server-url https://${window.location.hostname} --server-cert=""`;
  }
  return menderSetupArgs;
};
var installComponents = "--force-mender-client4";
var getDebConfigurationCode = (props) => {
  const { tenantToken, token, isPreRelease } = props;
  const envVars = tenantToken ? `JWT_TOKEN="${token}"
TENANT_TOKEN="${tenantToken}"
` : "";
  const installScriptArgs = getInstallScriptArgs(props);
  const scriptUrl = isPreRelease ? "https://get.mender.io/staging" : "https://get.mender.io";
  const menderSetupArgs = getSetupArgs(props);
  return `${envVars}wget -O- ${scriptUrl} | sudo bash -s -- ${installScriptArgs} ${installComponents} -- ${menderSetupArgs}`;
};
var getSnackbarMessage = (skipped, done) => {
  import_pluralize.default.addIrregularRule("its", "their");
  const skipText = skipped ? `${skipped} ${(0, import_pluralize.default)("devices", skipped)} ${(0, import_pluralize.default)("have", skipped)} more than one pending authset. Expand ${(0, import_pluralize.default)(
    "this",
    skipped
  )} ${(0, import_pluralize.default)("device", skipped)} to individually adjust ${(0, import_pluralize.default)("their", skipped)} authorization status. ` : "";
  const doneText = done ? `${done} ${(0, import_pluralize.default)("device", done)} ${(0, import_pluralize.default)("was", done)} updated successfully. ` : "";
  return `${doneText}${skipText}`;
};
var extractSoftware = (attributes = {}) => {
  const softwareKeys = Object.keys(attributes).reduce((accu, item) => {
    if (item.endsWith(".version")) {
      accu.push(item.substring(0, item.lastIndexOf(".")));
    }
    return accu;
  }, []);
  return Object.entries(attributes).reduce(
    (accu, item) => {
      if (softwareKeys.some((key) => item[0].startsWith(key))) {
        accu.software.push(item);
      } else {
        accu.nonSoftware.push(item);
      }
      return accu;
    },
    { software: [], nonSoftware: [] }
  );
};
var extractSoftwareItem = (artifactProvides = {}) => {
  const { software } = extractSoftware(artifactProvides);
  return software.reduce((accu, item) => {
    const infoItems = item[0].split(".");
    if (infoItems[infoItems.length - 1] !== "version") {
      return accu;
    }
    accu.push({
      key: infoItems[0],
      name: infoItems.slice(1, infoItems.length - 1).join("."),
      version: item[1],
      nestingLevel: infoItems.length
    });
    return accu;
  }, []).sort((a, b) => a.nestingLevel - b.nestingLevel).reduce((accu, item) => accu ?? item, void 0);
};
var cookies = new import_universal_cookie.default();
var createDownload = (target, filename, token) => {
  const link = document.createElement("a");
  link.setAttribute("href", target);
  link.setAttribute("download", filename);
  link.style.display = "none";
  document.body.appendChild(link);
  cookies.set("JWT", token, {
    path: "/",
    secure: true,
    sameSite: "strict",
    maxAge: 5
  });
  link.click();
  document.body.removeChild(link);
};
var createFileDownload = (content, filename, token) => createDownload("data:text/plain;charset=utf-8," + encodeURIComponent(content), filename, token);
var getISOStringBoundaries = (currentDate) => {
  const date = [currentDate.getUTCFullYear(), `0${currentDate.getUTCMonth() + 1}`.slice(-2), `0${currentDate.getUTCDate()}`.slice(-2)].join("-");
  return { start: `${date}T00:00:00.000`, end: `${date}T23:59:59.999` };
};
var extractErrorMessage = (err, fallback = "") => err.response?.data?.error?.message || err.response?.data?.error || err.error || err.message || fallback;
var preformatWithRequestID = (res, failMsg) => {
  if (failMsg.length > 100) failMsg = `${failMsg.substring(0, 220)}...`;
  try {
    if (res?.data && Object.keys(res.data).includes("request_id")) {
      const shortRequestUUID = res.data["request_id"].substring(0, 8);
      return `${failMsg} [Request ID: ${shortRequestUUID}]`;
    }
  } catch (e) {
    console.log("failed to extract request id:", e);
  }
  return failMsg;
};
var dateRangeToUnix = (startDate = null, endDate = null) => {
  const unixRange = { start: null, end: null };
  const format = "YYYY-MM-DD";
  if (startDate !== null) {
    const start = import_dayjs.default.utc((0, import_dayjs.default)(startDate).format(format));
    if (start.isValid()) {
      unixRange.start = start.startOf("day").unix();
    }
  }
  if (endDate !== null) {
    const end = import_dayjs.default.utc((0, import_dayjs.default)(endDate).format(format));
    if (end.isValid()) {
      unixRange.end = end.endOf("day").unix();
    }
  }
  return unixRange;
};
var byteArrayToString = (body) => String.fromCharCode(...body);
var blobToString = (blob) => new Promise((resolve) => {
  const fr = new FileReader();
  fr.onload = () => {
    resolve(fr.result);
  };
  fr.readAsArrayBuffer(blob);
});

// src/resizehook.ts
var import_react2 = require("react");
var halfASecond = 500;
var useWindowSize = () => {
  const [size, setSize] = (0, import_react2.useState)({ height: window.innerHeight, width: window.innerWidth });
  const timer = (0, import_react2.useRef)(void 0);
  (0, import_react2.useLayoutEffect)(() => {
    const handleResize = () => {
      timer.current = setTimeout(() => setSize({ height: window.innerHeight, width: window.innerWidth }), halfASecond);
    };
    window.addEventListener("resize", handleResize);
    handleResize();
    return () => {
      clearTimeout(timer.current);
      window.removeEventListener("resize", handleResize);
    };
  }, []);
  return size;
};

// src/retrytimer.ts
var oneSecond = 1e3;
var timers = {};
function setRetryTimer(err, service, errorContext, timeLeft, setSnackbar) {
  if (timers[service]) {
    return;
  }
  let remaining = timeLeft - oneSecond;
  timers[service] = setInterval(() => {
    remaining -= oneSecond;
    const errMsg = extractErrorMessage(err, "Please check your connection.");
    return remaining > 0 ? setSnackbar(preformatWithRequestID(err.response, `${errorContext} ${errMsg} Retrying in ${remaining / 1e3} seconds`)) : clearRetryTimer(service, setSnackbar);
  }, oneSecond);
}
function clearRetryTimer(service, setSnackbar) {
  if (timers[service]) {
    clearInterval(timers[service]);
    delete timers[service];
    setSnackbar("");
  }
}
function clearAllRetryTimers(setSnackbar) {
  Object.keys(timers).map((service) => clearRetryTimer(service, setSnackbar));
  setSnackbar("");
}

// src/tracking.ts
var import_react_ga4 = __toESM(require("react-ga4"), 1);
var cookieConsentCSS = "https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.css";
var cookieConsentJS = "https://cdn.jsdelivr.net/npm/cookieconsent@3/build/cookieconsent.min.js";
var ReactGA = import_react_ga4.default.default;
var Tracker = class {
  constructor() {
    this.initialized = false;
    this.trackingEnabled = true;
    this.currentPageView = null;
    this.currentOrganizationUser = null;
  }
  cookieconsent() {
    return new Promise((resolve) => {
      const style = document.createElement("link");
      style.href = cookieConsentCSS;
      style.rel = "stylesheet";
      style.async = true;
      document.head.appendChild(style);
      const script = document.createElement("script");
      script.src = cookieConsentJS;
      script.async = false;
      script.addEventListener("load", () => {
        window.cookieconsent.initialise({
          palette: {
            popup: {
              background: "#5d0f43",
              text: "#ffffff"
            },
            button: {
              background: "#73a4ad",
              text: "#ffffff"
            }
          },
          position: "bottom-left",
          type: "opt-out",
          content: {
            message: "We use cookies to analyze our traffic so we can improve our website and give you a better experience.",
            link: "View our cookie policy",
            href: "https://northern.tech/legal/cookies"
          },
          autoOpen: true,
          revokable: false,
          law: {
            regionalLaw: false
          },
          onStatusChange: (status) => {
            const hasConsented = status == "allow";
            resolve({ trackingConsentGiven: hasConsented });
          }
        });
      });
      document.body.appendChild(script);
    });
  }
  event(data) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.event(data);
    }
  }
  exception(error) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.event("error", error);
    }
  }
  initialize(trackingCode) {
    if (this.initialized && this.trackingEnabled) {
      return false;
    }
    ReactGA.initialize(trackingCode);
    this.initialized = true;
    return true;
  }
  pageview(data) {
    if (data) {
      this.currentPageView = data;
    }
  }
  set(value) {
    if (this.initialized && this.trackingEnabled) {
      ReactGA.set(value);
    }
  }
  setOrganizationUser(organization, user) {
    if (this.initialized && this.trackingEnabled && this.currentOrganizationUser != { organization, user }) {
      this.currentOrganizationUser = { organization, user };
      this.set({ dimension1: organization.plan });
      this.set({ dimension2: organization.id });
      this.set({ dimension3: user.id });
      this.set({ userId: user.id });
    }
  }
  setTrackingEnabled(trackingEnabled) {
    this.trackingEnabled = trackingEnabled;
  }
};
var Tracking = new Tracker();
var tracking_default = Tracking;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Tracking,
  attributeDuplicateFilter,
  blobToString,
  byteArrayToString,
  canAccess,
  clearAllRetryTimers,
  clearRetryTimer,
  createDownload,
  createFileDownload,
  customSort,
  dateRangeToUnix,
  deepCompare,
  detectOsIdentifier,
  duplicateFilter,
  extractErrorMessage,
  extractSoftware,
  extractSoftwareItem,
  formatTime,
  fullyDecodeURI,
  getDebConfigurationCode,
  getDemoDeviceAddress,
  getFormattedSize,
  getISOStringBoundaries,
  getSnackbarMessage,
  isEmpty,
  preformatWithRequestID,
  setRetryTimer,
  standardizePhases,
  stringToBoolean,
  toggle,
  unionizeStrings,
  useDebounce,
  useWindowSize,
  versionCompare,
  yes
});
//# sourceMappingURL=index.cjs.map