// src/auditlogs/eventdetails/DeviceDetails.tsx
import { Link } from "react-router-dom";
import { Launch as LaunchIcon } from "@mui/icons-material";
import { makeStyles } from "tss-react/mui";
import { TwoColumns } from "@northern.tech/common-ui/ConfigurationObject";
import DeviceIdentityDisplay from "@northern.tech/common-ui/DeviceIdentity";
import { AUDIT_LOGS_TYPES, BEGINNING_OF_TIME, rootfsImageVersion } from "@northern.tech/store/constants";
import { formatAuditlogs } from "@northern.tech/store/locationutils";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  eventDetails: { gridTemplateColumns: "minmax(max-content, 150px) max-content", rowGap: theme.spacing(2.5) },
  deviceLink: { color: theme.palette.text.secondary, fontWeight: "initial" }
}));
var DetailInformation = ({ title, details }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsxs("div", { className: "flexbox column margin-top-small", children: [
    /* @__PURE__ */ jsxs("b", { className: "margin-bottom-small capitalized-start", children: [
      title,
      " details"
    ] }),
    /* @__PURE__ */ jsx(TwoColumns, { className: classes.eventDetails, items: details })
  ] }, `${title}-details`);
};
var deviceAuditlogType = AUDIT_LOGS_TYPES.find((type) => type.value === "device");
var DeviceDetails = ({ device, idAttribute, onClose }) => {
  const { classes } = useStyles();
  const { attributes, id: deviceId } = device;
  const { name, device_type: deviceTypes, artifact_name } = attributes || {};
  const { attribute } = idAttribute;
  const usesId = attribute === "id" || attribute === "Device ID";
  const nameContainer = name ? { Name: name } : {};
  const deviceDetails = {
    ...nameContainer,
    [usesId ? "Device ID" : attribute]: /* @__PURE__ */ jsxs(Link, { className: `flexbox center-aligned ${classes.deviceLink}`, to: `/devices?id=${deviceId}`, children: [
      /* @__PURE__ */ jsx(DeviceIdentityDisplay, { device, isEditable: false }),
      /* @__PURE__ */ jsx(LaunchIcon, { className: "margin-left-small link-color", fontSize: "small" })
    ] }),
    "Device type": deviceTypes,
    "Operating system version": device[rootfsImageVersion] || artifact_name || "-",
    " ": /* @__PURE__ */ jsx(
      Link,
      {
        to: `/auditlog?${formatAuditlogs({ pageState: { type: deviceAuditlogType, detail: deviceId, startDate: BEGINNING_OF_TIME } }, {})}`,
        onClick: onClose,
        children: "List all log entries for this device"
      }
    )
  };
  return /* @__PURE__ */ jsx(DetailInformation, { title: "device", details: deviceDetails });
};
var DeviceDetails_default = DeviceDetails;

export {
  DetailInformation,
  DeviceDetails,
  DeviceDetails_default
};
//# sourceMappingURL=chunk-LHTCZWYC.js.map