import {
  DetailInformation,
  DeviceDetails_default
} from "./chunk-LHTCZWYC.js";

// src/auditlogs/eventdetails/DeviceConfiguration.tsx
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useTheme } from "@mui/material/styles";
import Loader from "@northern.tech/common-ui/Loader";
import { getAuditlogDevice, getIdAttribute, getUserCapabilities } from "@northern.tech/store/selectors";
import { getDeviceById } from "@northern.tech/store/thunks";
import { jsx, jsxs } from "react/jsx-runtime";
var DeviceConfiguration = ({ item, onClose }) => {
  const { object = {} } = item;
  const { canReadDevices } = useSelector(getUserCapabilities);
  const device = useSelector(getAuditlogDevice);
  const idAttribute = useSelector(getIdAttribute);
  const dispatch = useDispatch();
  const theme = useTheme();
  useEffect(() => {
    if (canReadDevices) {
      dispatch(getDeviceById(object.id));
    }
  }, [canReadDevices, dispatch, object.id]);
  if (canReadDevices && !device.id) {
    return /* @__PURE__ */ jsx(Loader, { show: true });
  }
  const { actor, change } = item;
  let config;
  try {
    config = JSON.parse(change);
  } catch (error) {
    config = { error: `An error occurred processing the changed config:
${error}` };
  }
  return /* @__PURE__ */ jsxs("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
    canReadDevices && /* @__PURE__ */ jsx(DeviceDetails_default, { device, idAttribute, onClose }),
    /* @__PURE__ */ jsx(DetailInformation, { title: "changed configuration", details: config }),
    /* @__PURE__ */ jsx(DetailInformation, { title: "change", details: { User: actor.email } })
  ] });
};
var DeviceConfiguration_default = DeviceConfiguration;

export {
  DeviceConfiguration,
  DeviceConfiguration_default
};
//# sourceMappingURL=chunk-RYIX3CGY.js.map