"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/auditlogs/ColumnComponents.tsx
var ColumnComponents_exports = {};
__export(ColumnComponents_exports, {
  ActionDescriptor: () => ActionDescriptor,
  ChangeDescriptor: () => ChangeDescriptor,
  ChangeDetailsDescriptor: () => ChangeDetailsDescriptor,
  TimeWrapper: () => TimeWrapper,
  TypeDescriptor: () => TypeDescriptor,
  UserDescriptor: () => UserDescriptor,
  ViewDetails: () => ViewDetails
});
module.exports = __toCommonJS(ColumnComponents_exports);
var import_react_router_dom = require("react-router-dom");
var import_DetailsIndicator = __toESM(require("@northern.tech/common-ui/DetailsIndicator"), 1);
var import_DeviceIdentity = __toESM(require("@northern.tech/common-ui/DeviceIdentity"), 1);
var import_Time = __toESM(require("@northern.tech/common-ui/Time"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var ArtifactLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_router_dom.Link, { to: `/releases/${item.object.artifact.name}`, children: "View artifact" });
var DeploymentLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_router_dom.Link, { to: `${import_constants.DEPLOYMENT_ROUTES.finished.route}?open=true&id=${item.object.id}`, children: "View deployment" });
var DeviceLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_router_dom.Link, { to: `/devices?id=${item.object.id}`, children: "View device" });
var DeviceRejectedLink = ({ item }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_react_router_dom.Link, { to: `/devices/rejected?id=${item.object.id}`, children: "View device" });
var TerminalSessionLink = () => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("a", { children: "View session log" });
var ChangeFallback = (props) => {
  const {
    item: { change = "-" }
  } = props;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "text-overflow", children: change });
};
var FallbackFormatter = (props) => {
  let result = "";
  try {
    result = JSON.stringify(props);
  } catch (error) {
    console.log(error);
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: result });
};
var ArtifactFormatter = ({ artifact }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: artifact.name });
var DeploymentFormatter = ({ deployment }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: deployment.name });
var DeviceFormatter = ({ id }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DeviceIdentity.default, { device: { id } });
var UserFormatter = ({ user }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: user.email });
var TenantFormatter = ({ tenant }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: tenant.name });
var defaultAccess = import_constants.canAccess;
var changeMap = {
  default: { component: "div", actionFormatter: FallbackFormatter, title: "defaultTitle", accessCheck: defaultAccess },
  artifact: { actionFormatter: ArtifactFormatter, component: ArtifactLink, accessCheck: ({ canReadReleases }) => canReadReleases },
  deployment: {
    actionFormatter: DeploymentFormatter,
    component: DeploymentLink,
    accessCheck: ({ canReadDeployments }) => canReadDeployments
  },
  deviceDecommissioned: { actionFormatter: DeviceFormatter, component: "div", accessCheck: defaultAccess },
  deviceRejected: { actionFormatter: DeviceFormatter, component: DeviceRejectedLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceGeneral: { actionFormatter: DeviceFormatter, component: DeviceLink, accessCheck: ({ canReadDevices }) => canReadDevices },
  deviceTerminalSession: { actionFormatter: DeviceFormatter, component: TerminalSessionLink, accessCheck: defaultAccess },
  user: { actionFormatter: UserFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  user_access_token: { actionFormatter: FallbackFormatter, component: ChangeFallback, accessCheck: defaultAccess },
  tenant: { actionFormatter: TenantFormatter, component: ChangeFallback, accessCheck: defaultAccess }
};
var mapChangeToContent = (item) => {
  let content = changeMap[item.object.type];
  if (content) {
    return content;
  } else if (item.object.type === "device" && item.action.includes("terminal")) {
    content = changeMap.deviceTerminalSession;
  } else if (item.object.type === "device" && item.action.includes("reject")) {
    content = changeMap.deviceRejected;
  } else if (item.object.type === "device" && item.action.includes("decommission")) {
    content = changeMap.deviceDecommissioned;
  } else if (item.object.type === "device") {
    content = changeMap.deviceGeneral;
  } else {
    content = changeMap.default;
  }
  return content;
};
var actorMap = {
  user: "email",
  device: "id"
};
var generateKey = (item, index) => `${item.time}-${index}`;
var UserDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: item.actor[actorMap[item.actor.type]] }, generateKey(item, index));
var ActionDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "uppercased", children: item.action }, generateKey(item, index));
var TypeDescriptor = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "capitalized", children: import_constants.AUDIT_LOGS_TYPES[item.object.type]?.title ?? item.object.type }, generateKey(item, index));
var ChangeDescriptor = (item, index) => {
  const FormatterComponent = mapChangeToContent(item).actionFormatter;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(FormatterComponent, { ...item.object }, generateKey(item, index));
};
var ChangeDetailsDescriptor = (item, index, userCapabilities) => {
  const { component: Comp, accessCheck } = mapChangeToContent(item);
  const key = generateKey(item, index);
  return accessCheck(userCapabilities) ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Comp, { item }, key) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", {}, key);
};
var TimeWrapper = (item, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Time.default, { value: item.time }, generateKey(item, index));
var ViewDetails = ({ item, index, onIssueSelection = () => {
}, ViewComponent = import_DetailsIndicator.default }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "clickable", onClick: () => onIssueSelection(item), children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ViewComponent, {}) }, generateKey(item, index));
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ActionDescriptor,
  ChangeDescriptor,
  ChangeDetailsDescriptor,
  TimeWrapper,
  TypeDescriptor,
  UserDescriptor,
  ViewDetails
});
//# sourceMappingURL=ColumnComponents.cjs.map