import { DeploymentConfig } from './index.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';

declare const mockState: {
    byId: {
        d1: {
            id: string;
            name: string;
            artifact_name: string;
            artifacts: string[];
            created: string;
            device_count: number;
            devices: {
                a1: {
                    attributes: {};
                    id: string;
                    image: {
                        size: number;
                    };
                    status: string;
                };
            };
            filter: undefined;
            group: undefined;
            statistics: {
                status: {
                    downloading: number;
                    decommissioned: number;
                    failure: number;
                    installing: number;
                    noartifact: number;
                    pending: number;
                    rebooting: number;
                    success: number;
                    'already-installed': number;
                };
                total_size: number;
            };
        };
        d2: {
            id: string;
            name: string;
            artifact_name: string;
            artifacts: string[];
            created: string;
            device_count: number;
            devices: {
                b1: {
                    attributes: {};
                    id: string;
                    status: string;
                };
            };
            filter: undefined;
            group: undefined;
            statistics: {
                status: {
                    downloading: number;
                    decommissioned: number;
                    failure: number;
                    installing: number;
                    noartifact: number;
                    pending: number;
                    rebooting: number;
                    success: number;
                    'already-installed': number;
                };
            };
        };
        d3: {
            id: string;
            name: string;
            phases: ({
                id: string;
                batch_size: number;
                device_count: number;
                start_ts?: undefined;
            } | {
                id: string;
                start_ts: string;
                batch_size: number;
                device_count: number;
            })[];
            max_devices: number;
            created: string;
            devices: {};
            filter: undefined;
            group: undefined;
            stats: {
                pending: number;
                decommissioned: number;
                failure: number;
                pause_before_committing: number;
                pause_before_rebooting: number;
                installing: number;
                rebooting: number;
                'already-installed': number;
                pause_before_installing: number;
                downloading: number;
                success: number;
                aborted: number;
                noartifact: number;
            };
            statistics: {
                total_size: string;
            };
            status: string;
            active: boolean;
            device_count: number;
            retries: string;
            type: string;
        };
    };
    byStatus: {
        finished: {
            deploymentIds: string[];
            total: number;
        };
        inprogress: {
            deploymentIds: string[];
            total: number;
        };
        pending: {
            deploymentIds: string[];
            total: number;
        };
        scheduled: {
            deploymentIds: string[];
            total: number;
        };
    };
    deploymentDeviceLimit: number;
    selectedDeviceIds: never[];
    selectionState: {
        finished: {
            selection: string[];
            endDate: undefined;
            search: string;
            total: number;
            type: string;
            page?: number;
            perPage?: number;
            startDate?: string;
        };
        inprogress: {
            selection: string[];
            total: number;
            endDate?: string;
            page?: number;
            perPage?: number;
            search?: string;
            startDate?: string;
            type?: string;
        };
        pending: {
            selection: string[];
            total: number;
            endDate?: string;
            page?: number;
            perPage?: number;
            search?: string;
            startDate?: string;
            type?: string;
        };
        scheduled: {
            selection: string[];
            total: number;
            endDate?: string;
            page?: number;
            perPage?: number;
            search?: string;
            startDate?: string;
            type?: string;
        };
        general: {
            state: string;
            showCreationDialog: boolean;
            showReportDialog: boolean;
            reportType: null;
        };
        selectedId: string;
    };
    config: DeploymentConfig;
};

export { mockState };
