import { ArtifactInfo } from './ArtifactInfo.cjs';
import { Update } from './Update.cjs';
import './ArtifactTypeInfo.cjs';
import './UpdateFile.cjs';

/**
 * Detailed artifact.
 */
type Artifact = {
    id: string;
    name: string;
    description: string;
    /**
     * An array of compatible device types.
     */
    device_types_compatible: Array<string>;
    info?: ArtifactInfo;
    /**
     * Idicates if artifact is signed or not.
     */
    signed?: boolean;
    updates?: Array<Update>;
    /**
     * List of Artifact provides.
     *
     * Map of key/value pairs, where both keys and values are strings.
     */
    artifact_provides?: Record<string, string>;
    /**
     * List of Artifact depends.
     *
     * Map of key/value pairs, where keys are strings and values are lists of strings.
     */
    artifact_depends?: Record<string, Array<string>>;
    /**
     * List of Clear Artifact provides.
     */
    clears_artifact_provides?: Array<string>;
    /**
     * Artifact total size in bytes - the size of the actual file that will be transferred to the device (compressed).
     */
    size?: number;
    /**
     * Represents creation / last edition of any of the artifact properties.
     */
    modified: string;
};

export type { Artifact };
