import { useRef } from "react";
/** Like react's useMemo but with guarantee that the fn
 * won't be invoked again if deps hasn't change */
export function useGuaranteedMemo(fn, deps) {
    var _a;
    const ref = useRef();
    if (!ref.current ||
        deps.length !== ((_a = ref.current.prevDeps) === null || _a === void 0 ? void 0 : _a.length) ||
        ref.current.prevDeps.map((v, i) => v === deps[i]).indexOf(false) >= 0) {
        ref.current = {
            "v": fn(),
            "prevDeps": [...deps]
        };
    }
    return ref.current.v;
}
