// src/forms/FileUpload.tsx
import { useState } from "react";
import Dropzone from "react-dropzone";
import { useDispatch } from "react-redux";
import { Clear as ClearIcon, CloudUploadOutlined as FileIcon } from "@mui/icons-material";
import { IconButton, TextField } from "@mui/material";
import storeActions from "@northern.tech/store/actions";
import { jsx, jsxs } from "react/jsx-runtime";
var { setSnackbar } = storeActions;
var FileUpload = ({ enableContentReading = true, fileNameSelection, onFileChange, onFileSelect = () => void 0, placeholder, style = {} }) => {
  const [filename, setFilename] = useState(fileNameSelection);
  const dispatch = useDispatch();
  const onDrop = (acceptedFiles, rejectedFiles) => {
    if (acceptedFiles.length) {
      if (enableContentReading) {
        const reader = new FileReader();
        reader.readAsBinaryString(acceptedFiles[0]);
        reader.fileName = acceptedFiles[0].name;
        reader.onload = () => {
          const str = reader.result.replace(/\n|\r/g, "\n");
          onFileChange(str);
        };
        reader.onerror = (error) => {
          console.log("Error: ", error);
          setFilename();
        };
      }
      setFilename(acceptedFiles[0].name);
      onFileSelect(acceptedFiles[0]);
    }
    if (rejectedFiles.length) {
      dispatch(setSnackbar(`File '${rejectedFiles[0].name}' was rejected.`));
    }
  };
  const onClear = () => {
    onFileChange();
    onFileSelect();
    setFilename();
  };
  return filename ? /* @__PURE__ */ jsxs("div", { style, children: [
    /* @__PURE__ */ jsx(TextField, { id: "keyfile", value: filename, disabled: true, style: { color: "rgba(0, 0, 0, 0.8)", borderBottom: "1px solid rgb(224, 224, 224)" } }),
    /* @__PURE__ */ jsx(IconButton, { style: { top: "6px" }, onClick: onClear, size: "large", children: /* @__PURE__ */ jsx(ClearIcon, {}) })
  ] }) : /* @__PURE__ */ jsx("div", { style, children: /* @__PURE__ */ jsx(Dropzone, { activeClassName: "active", rejectClassName: "active", multiple: false, onDrop, children: ({ getRootProps, getInputProps }) => /* @__PURE__ */ jsxs("div", { ...getRootProps(), style: { padding: 15 }, className: "dropzone onboard dashboard-placeholder flexbox centered", children: [
    /* @__PURE__ */ jsx("input", { ...getInputProps() }),
    /* @__PURE__ */ jsx(FileIcon, { className: "icon", style: { height: 24, width: 24, verticalAlign: "middle", marginTop: "-2px" } }),
    /* @__PURE__ */ jsx("div", { className: "margin-left-small", style: { fontSize: "11pt" }, children: placeholder })
  ] }) }) });
};
var FileUpload_default = FileUpload;

export {
  FileUpload,
  FileUpload_default
};
//# sourceMappingURL=chunk-3HK4LYED.js.map