"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/auditlogs/AuditLogsList.tsx
var AuditLogsList_exports = {};
__export(AuditLogsList_exports, {
  AuditLogsList: () => AuditLogsList,
  default: () => AuditLogsList_default,
  defaultRowsPerPage: () => defaultRowsPerPage
});
module.exports = __toCommonJS(AuditLogsList_exports);
var import_icons_material = require("@mui/icons-material");
var import_mui = require("tss-react/mui");
var import_DetailsIndicator = __toESM(require("@northern.tech/common-ui/DetailsIndicator"), 1);
var import_Loader = __toESM(require("@northern.tech/common-ui/Loader"), 1);
var import_Pagination = __toESM(require("@northern.tech/common-ui/Pagination"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_jsx_runtime = require("react/jsx-runtime");
var defaultRowsPerPage = 20;
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  auditlogsList: {
    "& .auditlogs-list-item": {
      display: "grid",
      gridTemplateColumns: "2fr 1fr 1fr 2fr 2fr 1.75fr 120px",
      gridColumnGap: theme.spacing(4),
      padding: `5px ${theme.spacing(2)}`,
      borderBottom: `1px solid ${theme.palette.border.main}`,
      height: theme.spacing(6),
      minHeight: theme.spacing(6),
      maxHeight: theme.spacing(6),
      alignItems: "center",
      "&:last-of-type": {
        borderBottom: "transparent"
      },
      "& > *": {
        display: "flex",
        alignItems: "center",
        maxHeight: theme.spacing(6),
        overflow: "hidden"
      },
      "> .text-overflow": {
        display: "block"
      },
      "&.auditlogs-list-item-header": {
        borderBottom: "transparent",
        cursor: "initial",
        padding: `10px ${theme.spacing(2)}`,
        position: "relative"
      }
    }
  }
}));
var AuditLogsList = ({
  items,
  onChangePage,
  onChangeRowsPerPage,
  onChangeSorting,
  selectionState,
  userCapabilities,
  auditLogColumns,
  onIssueSelection
}) => {
  const { page, perPage, sort = {}, total: count, isLoading } = selectionState;
  const { classes } = useStyles();
  return !!items.length && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `fadeIn deploy-table-contain auditlogs-list ${classes.auditlogsList}`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "auditlogs-list-item auditlogs-list-item-header muted", children: [
      auditLogColumns.map((column, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
        "div",
        {
          className: "columnHeader",
          onClick: () => column.sortable ? onChangeSorting() : null,
          style: column.sortable ? {} : { cursor: "initial" },
          children: [
            column.title,
            column.sortable ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Sort, { className: `sortIcon selected ${(sort.direction === import_constants.SORTING_OPTIONS.desc).toString()}` }) : null
          ]
        },
        `columnHeader-${index}`
      )),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "auditlogs-list", children: items.map((item) => {
      const allowsExpansion = onIssueSelection && (!!item.change || item.action.includes("terminal") || item.action.includes("portforward"));
      return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
        "div",
        {
          className: `auditlogs-list-item ${allowsExpansion ? "clickable" : ""}`,
          onClick: () => onIssueSelection ? onIssueSelection(allowsExpansion ? item : void 0) : null,
          children: [
            auditLogColumns.map((column, index) => column.render(item, index, userCapabilities)),
            allowsExpansion ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_DetailsIndicator.default, {}) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", {})
          ]
        },
        `event-${item.time}`
      );
    }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox margin-top", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Pagination.default,
        {
          className: "margin-top-none",
          count,
          rowsPerPage: perPage,
          onChangeRowsPerPage,
          page,
          onChangePage
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Loader.default, { show: isLoading, small: true })
    ] })
  ] });
};
var AuditLogsList_default = AuditLogsList;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AuditLogsList,
  defaultRowsPerPage
});
//# sourceMappingURL=AuditLogsList.cjs.map