import { SnackbarContent, Upload } from './appSlice/index.js';
import * as _northern_tech_types_DeviceWithImage from '@northern.tech/types/DeviceWithImage';
import { Deployment, DeploymentByStatusKey, SelectionState, DeploymentConfig } from './deploymentsSlice/index.js';
import { DeviceGroup, DeviceListState, Device, DeviceFilter, DeviceStatus } from './devicesSlice/index.js';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { OnboardingApproach } from './onboardingSlice/index.js';
import * as _northern_tech_types_Event from '@northern.tech/types/Event';
import * as _northern_tech_types_Integration from '@northern.tech/types/Integration';
import * as _northern_tech_types_BillingProfile from '@northern.tech/types/BillingProfile';
import { AuditLogSelectionState, Card, Organization, TenantList, SSOConfig } from './organizationSlice/types.js';
import * as _northern_tech_types_AuditLog from '@northern.tech/types/AuditLog';
import { Release, ReleasesList } from './releasesSlice/index.js';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { AlertChannelKey } from './monitorSlice/constants.js';
import { ReadState } from './usersSlice/constants.js';
import { UserSession, User, CustomColumn, GlobalSettings, UserSettings } from './usersSlice/index.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import 'redux';
import 'immer';
import '@mui/material';
import '@northern.tech/types/MenderTypes';
import './commonConstants.js';
import 'react/jsx-runtime';
import './devicesSlice/constants.js';
import './appSlice/constants.js';
import '@mui/material/OverridableComponent';
import './organizationSlice/constants.js';

declare const _default: {
    receivedQrCode: _reduxjs_toolkit.ActionCreatorWithPayload<string | null, "users/receivedQrCode">;
    successfullyLoggedIn: _reduxjs_toolkit.ActionCreatorWithPayload<UserSession, "users/successfullyLoggedIn">;
    receivedUserList: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, User>, "users/receivedUserList">;
    receivedActivationCode: _reduxjs_toolkit.ActionCreatorWithPayload<string, "users/receivedActivationCode">;
    receivedUser: _reduxjs_toolkit.ActionCreatorWithPayload<User, "users/receivedUser">;
    removedUser: _reduxjs_toolkit.ActionCreatorWithPayload<string, "users/removedUser">;
    updatedUser: _reduxjs_toolkit.ActionCreatorWithPayload<Partial<User> & {
        id: string;
    }, "users/updatedUser">;
    receivedPermissionSets: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, _northern_tech_utils_constants.PermissionSet>, "users/receivedPermissionSets">;
    receivedRoles: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, _northern_tech_utils_constants.Role>, "users/receivedRoles">;
    finishedRoleInitialization: _reduxjs_toolkit.ActionCreatorWithPayload<any, "users/finishedRoleInitialization">;
    createdRole: _reduxjs_toolkit.ActionCreatorWithPayload<_northern_tech_utils_constants.Role, "users/createdRole">;
    removedRole: _reduxjs_toolkit.ActionCreatorWithPayload<string, "users/removedRole">;
    setCustomColumns: _reduxjs_toolkit.ActionCreatorWithPayload<CustomColumn[], "users/setCustomColumns">;
    setGlobalSettings: _reduxjs_toolkit.ActionCreatorWithPayload<GlobalSettings, "users/setGlobalSettings">;
    setUserSettings: _reduxjs_toolkit.ActionCreatorWithPayload<UserSettings, "users/setUserSettings">;
    setTooltipState: _reduxjs_toolkit.ActionCreatorWithPayload<{
        id: string;
        readState: ReadState;
    }, "users/setTooltipState">;
    setTooltipsState: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, {
        readState: ReadState;
    }>, "users/setTooltipsState">;
    setShowFeedbackDialog: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "users/setShowFeedbackDialog">;
    setShowConnectingDialog: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "users/setShowConnectingDialog">;
    setShowStartupNotification: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "users/setShowStartupNotification">;
    receiveRelease: _reduxjs_toolkit.ActionCreatorWithPayload<Release, "releases/receiveRelease">;
    receiveReleases: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, Release>, "releases/receiveReleases">;
    receiveReleaseTags: _reduxjs_toolkit.ActionCreatorWithPayload<string[], "releases/receiveReleaseTags">;
    receiveReleaseTypes: _reduxjs_toolkit.ActionCreatorWithPayload<string[], "releases/receiveReleaseTypes">;
    removeRelease: _reduxjs_toolkit.ActionCreatorWithPayload<string, "releases/removeRelease">;
    selectedRelease: _reduxjs_toolkit.ActionCreatorWithPayload<string | null, "releases/selectedRelease">;
    setReleaseListState: _reduxjs_toolkit.ActionCreatorWithPayload<ReleasesList, "releases/setReleaseListState">;
    receiveAuditLogs: _reduxjs_toolkit.ActionCreatorWithPayload<{
        events: _northern_tech_types_AuditLog.AuditLog[];
        total: number;
    }, "organization/receiveAuditLogs">;
    setAuditLogState: _reduxjs_toolkit.ActionCreatorWithPayload<Partial<AuditLogSelectionState>, "organization/setAuditLogState">;
    receiveCurrentCard: _reduxjs_toolkit.ActionCreatorWithPayload<Card, "organization/receiveCurrentCard">;
    receiveSetupIntent: _reduxjs_toolkit.ActionCreatorWithPayload<string | null, "organization/receiveSetupIntent">;
    setOrganization: _reduxjs_toolkit.ActionCreatorWithPayload<Partial<Organization>, "organization/setOrganization">;
    setSubscription: _reduxjs_toolkit.ActionCreatorWithPayload<any, "organization/setSubscription">;
    setBillingProfile: _reduxjs_toolkit.ActionCreatorWithPayload<_northern_tech_types_BillingProfile.BillingProfile, "organization/setBillingProfile">;
    setTenantListState: _reduxjs_toolkit.ActionCreatorWithPayload<TenantList, "organization/setTenantListState">;
    receiveExternalDeviceIntegrations: _reduxjs_toolkit.ActionCreatorWithPayload<_northern_tech_types_Integration.Integration[], "organization/receiveExternalDeviceIntegrations">;
    receiveSsoConfigs: _reduxjs_toolkit.ActionCreatorWithPayload<SSOConfig[], "organization/receiveSsoConfigs">;
    receiveWebhookEvents: _reduxjs_toolkit.ActionCreatorWithPayload<{
        total: number;
        value: _northern_tech_types_Event.Event[];
    }, "organization/receiveWebhookEvents">;
    setOnboardingState: _reduxjs_toolkit.ActionCreatorWithPayload<Partial<{
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    }>, "onboarding/setOnboardingState">;
    setDemoArtifactPort: _reduxjs_toolkit.ActionCreatorWithPayload<number, "onboarding/setDemoArtifactPort">;
    setShowOnboardingHelp: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "onboarding/setShowOnboardingHelp">;
    setShowDismissOnboardingTipsDialog: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "onboarding/setShowDismissOnboardingTipsDialog">;
    setOnboardingComplete: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "onboarding/setOnboardingComplete">;
    setOnboardingProgress: _reduxjs_toolkit.ActionCreatorWithPayload<string, "onboarding/setOnboardingProgress">;
    setOnboardingDeviceType: _reduxjs_toolkit.ActionCreatorWithPayload<string | string[], "onboarding/setOnboardingDeviceType">;
    setOnboardingApproach: _reduxjs_toolkit.ActionCreatorWithPayload<OnboardingApproach, "onboarding/setOnboardingApproach">;
    changeAlertChannel: _reduxjs_toolkit.ActionCreatorWithPayload<{
        channel: AlertChannelKey;
        enabled: boolean;
    }, "monitor/changeAlertChannel">;
    receiveDeviceAlerts: _reduxjs_toolkit.ActionCreatorWithPayload<{
        alerts: (_northern_tech_types_Alert.Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    }, "monitor/receiveDeviceAlerts">;
    receiveLatestDeviceAlerts: _reduxjs_toolkit.ActionCreatorWithPayload<{
        alerts: (_northern_tech_types_Alert.Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    }, "monitor/receiveLatestDeviceAlerts">;
    receiveDeviceIssueCounts: _reduxjs_toolkit.ActionCreatorWithPayload<{
        counts: {
            filtered: number;
            total: number;
        };
        issueType: _northern_tech_utils_constants.DeviceIssueOptionKey;
    }, "monitor/receiveDeviceIssueCounts">;
    setAlertListState: _reduxjs_toolkit.ActionCreatorWithPayload<any, "monitor/setAlertListState">;
    receivedGroups: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, DeviceGroup>, "devices/receivedGroups">;
    addToGroup: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deviceIds: string[];
        group: string;
    }, "devices/addToGroup">;
    removeFromGroup: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deviceIds: string[];
        group: string;
    }, "devices/removeFromGroup">;
    addGroup: _reduxjs_toolkit.ActionCreatorWithPayload<{
        group: DeviceGroup;
        groupName: string;
    }, "devices/addGroup">;
    selectGroup: _reduxjs_toolkit.ActionCreatorWithOptionalPayload<string | undefined, "devices/selectGroup">;
    removeGroup: _reduxjs_toolkit.ActionCreatorWithPayload<string, "devices/removeGroup">;
    setDeviceListState: _reduxjs_toolkit.ActionCreatorWithPayload<Partial<DeviceListState>, "devices/setDeviceListState">;
    setFilterAttributes: _reduxjs_toolkit.ActionCreatorWithPayload<{
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: string[];
        tagAttributes: string[];
    }, "devices/setFilterAttributes">;
    setFilterablesConfig: _reduxjs_toolkit.ActionCreatorWithPayload<{
        attributes: Record<string, string[]>;
        count: number;
        limit: number;
    }, "devices/setFilterablesConfig">;
    receivedDevices: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, Device>, "devices/receivedDevices">;
    setDeviceFilters: _reduxjs_toolkit.ActionCreatorWithPayload<DeviceFilter[], "devices/setDeviceFilters">;
    setInactiveDevices: _reduxjs_toolkit.ActionCreatorWithPayload<{
        activeDeviceTotal: number;
        inactiveDeviceTotal: number;
    }, "devices/setInactiveDevices">;
    setDeviceReports: _reduxjs_toolkit.ActionCreatorWithPayload<{
        items: {
            count: number;
            key: string;
        }[];
        otherCount: number;
        total: number;
    }[], "devices/setDeviceReports">;
    setDevicesByStatus: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deviceIds: string[];
        forceUpdate?: boolean;
        status: DeviceStatus;
        total: number;
    }, "devices/setDevicesByStatus">;
    setDevicesCountByStatus: _reduxjs_toolkit.ActionCreatorWithPayload<{
        count: number;
        status: DeviceStatus;
    }, "devices/setDevicesCountByStatus">;
    setDeviceLimit: _reduxjs_toolkit.ActionCreatorWithPayload<number, "devices/setDeviceLimit">;
    receivedDevice: _reduxjs_toolkit.ActionCreatorWithPayload<{
        id: string;
    } & Partial<Device>, "devices/receivedDevice">;
    maybeUpdateDevicesByStatus: _reduxjs_toolkit.ActionCreatorWithPayload<{
        authId?: string;
        deviceId: string;
    }, "devices/maybeUpdateDevicesByStatus">;
    createdDeployment: _reduxjs_toolkit.ActionCreatorWithPayload<any, "deployments/createdDeployment">;
    removedDeployment: _reduxjs_toolkit.ActionCreatorWithPayload<string, "deployments/removedDeployment">;
    receivedDeployment: _reduxjs_toolkit.ActionCreatorWithPayload<Deployment, "deployments/receivedDeployment">;
    receivedDeploymentDeviceLog: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deviceId: string;
        id: string;
        log: boolean;
    }, "deployments/receivedDeploymentDeviceLog">;
    receivedDeploymentDevices: _reduxjs_toolkit.ActionCreatorWithPayload<{
        devices: Record<string, _northern_tech_types_DeviceWithImage.DeviceWithImage>;
        id: string;
        selectedDeviceIds: string[];
        totalDeviceCount: number;
    }, "deployments/receivedDeploymentDevices">;
    receivedDeployments: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, Deployment>, "deployments/receivedDeployments">;
    receivedDeploymentsForStatus: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }, "deployments/receivedDeploymentsForStatus">;
    selectDeploymentsForStatus: _reduxjs_toolkit.ActionCreatorWithPayload<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }, "deployments/selectDeploymentsForStatus">;
    setDeploymentsState: _reduxjs_toolkit.ActionCreatorWithPayload<SelectionState, "deployments/setDeploymentsState">;
    setDeploymentsConfig: _reduxjs_toolkit.ActionCreatorWithPayload<DeploymentConfig, "deployments/setDeploymentsConfig">;
    setFeatures: _reduxjs_toolkit.ActionCreatorWithPayload<Record<string, boolean>, "app/setFeatures">;
    setSnackbar: _reduxjs_toolkit.ActionCreatorWithPayload<string | SnackbarContent, "app/setSnackbar">;
    setFirstLoginAfterSignup: _reduxjs_toolkit.ActionCreatorWithPayload<boolean, "app/setFirstLoginAfterSignup">;
    setAnnouncement: _reduxjs_toolkit.ActionCreatorWithPayload<string, "app/setAnnouncement">;
    setSearchState: _reduxjs_toolkit.ActionCreatorWithPayload<any, "app/setSearchState">;
    setOfflineThreshold: _reduxjs_toolkit.ActionCreatorWithPayload<string, "app/setOfflineThreshold">;
    initUpload: _reduxjs_toolkit.ActionCreatorWithPayload<{
        id: string;
        upload: Upload;
    }, "app/initUpload">;
    uploadProgress: _reduxjs_toolkit.ActionCreatorWithPayload<{
        id: string;
        progress: number;
    }, "app/uploadProgress">;
    cleanUpUpload: _reduxjs_toolkit.ActionCreatorWithPayload<string, "app/cleanUpUpload">;
    setVersionInformation: _reduxjs_toolkit.ActionCreatorWithPayload<{
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }, "app/setVersionInformation">;
    setEnvironmentData: _reduxjs_toolkit.ActionCreatorWithPayload<any, "app/setEnvironmentData">;
};

export { _default as default };
