// src/CopyCode.tsx
import { useState } from "react";
import CopyToClipboard from "react-copy-to-clipboard";
import { FileCopy as CopyPasteIcon } from "@mui/icons-material";
import { Button, IconButton } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var buttonStyle = { float: "right", margin: "-20px 0 0 10px" };
var useStyles = makeStyles()((theme) => ({
  code: {
    border: "1px solid",
    borderColor: theme.palette.background.lightgrey,
    backgroundColor: theme.palette.background.lightgrey
  }
}));
var Code = ({ className = "", children, style = {} }) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsx("div", { className: `code ${classes.code} ${className}`, style, children });
};
var CopyCode = ({ code, onCopy, withDescription }) => {
  const [copied, setCopied] = useState(false);
  const onCopied = (_text, result) => {
    setCopied(result);
    setTimeout(() => setCopied(false), TIMEOUTS.fiveSeconds);
    if (onCopy) {
      onCopy();
    }
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(Code, { children: [
      /* @__PURE__ */ jsx(CopyToClipboard, { text: code, onCopy: onCopied, children: withDescription ? /* @__PURE__ */ jsx(Button, { style: buttonStyle, startIcon: /* @__PURE__ */ jsx(CopyPasteIcon, {}), children: "Copy to clipboard" }) : /* @__PURE__ */ jsx(IconButton, { style: buttonStyle, size: "large", children: /* @__PURE__ */ jsx(CopyPasteIcon, {}) }) }),
      /* @__PURE__ */ jsx("span", { style: { whiteSpace: "pre-wrap", wordBreak: "break-word" }, children: code })
    ] }),
    /* @__PURE__ */ jsx("p", { children: copied && /* @__PURE__ */ jsx("span", { className: "green fadeIn", children: "Copied to clipboard." }) })
  ] });
};
var CopyCode_default = CopyCode;

export {
  Code,
  CopyCode,
  CopyCode_default
};
//# sourceMappingURL=chunk-SD7CDOOV.js.map