// src/ExpandableAttribute.tsx
import { useCallback, useEffect, useRef, useState } from "react";
import { FileCopyOutlined as CopyToClipboardIcon } from "@mui/icons-material";
import { ListItem, ListItemText, Tooltip } from "@mui/material";
import { toggle } from "@northern.tech/utils/helpers";
import copy from "copy-to-clipboard";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var defaultClasses = { root: "attributes" };
var ExpandableAttribute = ({
  className = "",
  copyToClipboard,
  dividerDisabled,
  onExpansion,
  primary,
  secondary,
  secondaryTypographyProps = {},
  setSnackbar,
  style,
  textClasses,
  ...remainder
}) => {
  const textContent = useRef(null);
  const [expanded, setExpanded] = useState(false);
  const [overflowActive, setOverflowActive] = useState(false);
  const [tooltipVisible, setTooltipVisible] = useState(false);
  useEffect(() => {
    if (textContent.current) {
      const overflowActiveCurrently = textContent.current.scrollWidth > textContent.current.clientWidth || textContent.current.scrollHeight > textContent.current.clientHeight;
      if (overflowActive !== overflowActiveCurrently && !expanded) {
        setOverflowActive(overflowActiveCurrently);
      }
    }
  }, [expanded, overflowActive, textContent]);
  const onClick = useCallback(() => {
    if (copyToClipboard && setSnackbar) {
      copy(secondary);
      setSnackbar("Value copied to clipboard");
    }
    if (!expanded && !!onExpansion) {
      onExpansion();
    }
    setExpanded(toggle);
  }, [copyToClipboard, expanded, onExpansion, secondary, setSnackbar]);
  const currentTextClasses = `${textClasses ? textClasses.secondary : "inventory-text"}${expanded && overflowActive ? " expanded-attribute" : ""}`;
  const secondaryText = /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("span", { className: currentTextClasses, ref: textContent, children: secondary }),
    " ",
    overflowActive ? /* @__PURE__ */ jsxs("a", { children: [
      "show ",
      expanded ? "less" : "more"
    ] }) : null
  ] });
  const cssClasses = { ...defaultClasses, root: `${defaultClasses.root} ${copyToClipboard ? "copy-to-clipboard" : ""}`.trim() };
  return /* @__PURE__ */ jsx("div", { className, onClick, onMouseEnter: () => setTooltipVisible(true), onMouseLeave: () => setTooltipVisible(false), style, children: /* @__PURE__ */ jsxs(ListItem, { classes: cssClasses, divider: !dividerDisabled, ...remainder, children: [
    /* @__PURE__ */ jsx(
      ListItemText,
      {
        primary,
        secondary: secondaryText,
        secondaryTypographyProps: { title: secondary, component: "div", ...secondaryTypographyProps }
      }
    ),
    copyToClipboard ? /* @__PURE__ */ jsx(Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ jsx(CopyToClipboardIcon, { fontSize: "small" }) }) : null
  ] }) });
};
var ExpandableAttribute_default = ExpandableAttribute;

export {
  ExpandableAttribute,
  ExpandableAttribute_default
};
//# sourceMappingURL=chunk-SQS3CAW7.js.map