import {
  EventDetailsDrawerContentMap_default
} from "./chunk-A33MALPY.js";
import {
  FallbackComponent_default
} from "./chunk-4HUJEAGX.js";
import {
  AuditLogsFilter_default
} from "./chunk-6QK3J3GE.js";
import {
  AuditLogsList_default
} from "./chunk-F35TRHF4.js";
import {
  AuditlogsView_default
} from "./chunk-OOY4IOLD.js";
import {
  ActionDescriptor,
  ChangeDescriptor,
  ChangeDetailsDescriptor,
  TimeWrapper,
  TypeDescriptor,
  UserDescriptor
} from "./chunk-BNQO4KJ2.js";
import {
  EventDetailsDrawer_default
} from "./chunk-27FPFGHG.js";

// src/auditlogs/AuditLogs.tsx
import { useCallback, useEffect, useRef, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { makeStyles } from "tss-react/mui";
import EnterpriseNotification, { DefaultUpgradeNotification } from "@northern.tech/common-ui/EnterpriseNotification";
import { AUDIT_LOGS_TYPES, BEGINNING_OF_TIME, BENEFITS, SORTING_OPTIONS, SP_AUDIT_LOGS_TYPES, TIMEOUTS } from "@northern.tech/store/constants";
import { useLocationParams } from "@northern.tech/store/liststatehook";
import {
  getAuditLog,
  getAuditLogEntry,
  getAuditLogSelectionState,
  getCurrentSession,
  getGroupNames,
  getIsServiceProvider,
  getTenantCapabilities,
  getUserCapabilities
} from "@northern.tech/store/selectors";
import { getAuditLogs, getAuditLogsCsvLink, getUserList, setAuditlogsState } from "@northern.tech/store/thunks";
import { createDownload, getISOStringBoundaries } from "@northern.tech/utils/helpers";
import dayjs from "dayjs";

// ../../assets/img/history.png
var history_default = "./history-JI2OFHQF.png";

// src/auditlogs/AuditLogs.tsx
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  filters: {
    backgroundColor: theme.palette.background.lightgrey,
    padding: "0px 25px 5px",
    display: "grid",
    gridTemplateColumns: "400px 250px 250px 1fr",
    gridColumnGap: theme.spacing(2),
    gridRowGap: theme.spacing(2)
  },
  filterReset: { alignSelf: "flex-end", marginBottom: 5 },
  timeframe: { gridColumnStart: 2, gridColumnEnd: 4, marginLeft: 7.5 },
  typeDetails: { marginRight: 15, marginTop: theme.spacing(2) },
  upgradeNote: { marginTop: "5vh", placeSelf: "center" }
}));
var isUserOptionEqualToValue = ({ email, id }, value) => id === value || email === value || email === value?.email;
var locationDefaults = { sort: { direction: SORTING_OPTIONS.desc } };
var AuditLogs = () => {
  const [csvLoading, setCsvLoading] = useState(false);
  const [date] = useState(getISOStringBoundaries(/* @__PURE__ */ new Date()));
  const { start: today, end: tonight } = date;
  const isInitialized = useRef();
  const [locationParams, setLocationParams] = useLocationParams("auditlogs", { today, tonight, defaults: locationDefaults });
  const { classes } = useStyles();
  const dispatch = useDispatch();
  const events = useSelector(getAuditLog);
  const eventItem = useSelector(getAuditLogEntry);
  const groups = useSelector(getGroupNames);
  const selectionState = useSelector(getAuditLogSelectionState);
  const userCapabilities = useSelector(getUserCapabilities);
  const tenantCapabilities = useSelector(getTenantCapabilities);
  const users = useSelector((state) => state.users.byId);
  const { canReadUsers } = userCapabilities;
  const { hasAuditlogs } = tenantCapabilities;
  const [detailsReset, setDetailsReset] = useState("");
  const [dirtyField, setDirtyField] = useState("");
  const { token } = useSelector(getCurrentSession);
  const isSP = useSelector(getIsServiceProvider);
  const { detail, perPage, endDate, user, sort, startDate, type, total, isLoading } = selectionState;
  const [auditLogsTypes, setAuditLogsTypes] = useState(AUDIT_LOGS_TYPES);
  const timers = useRef({ init: null, detailsReset: null, dirtyField: null });
  useEffect(() => {
    if (isSP) {
      setAuditLogsTypes(SP_AUDIT_LOGS_TYPES);
    }
  }, [isSP]);
  useEffect(() => {
    if (!hasAuditlogs || !isInitialized.current) {
      return;
    }
    setLocationParams({ pageState: selectionState });
  }, [detail, endDate, hasAuditlogs, perPage, selectionState.page, selectionState.selectedId, setLocationParams, startDate, type, user]);
  useEffect(() => {
    if (!isInitialized.current) {
      return;
    }
    setDetailsReset("detail");
    clearTimeout(timers.current.detailsReset);
    timers.current.detailsReset = setTimeout(() => setDetailsReset(""), TIMEOUTS.debounceShort);
  }, [type?.value]);
  useEffect(() => {
    if (canReadUsers) {
      dispatch(getUserList());
    }
  }, [canReadUsers, dispatch]);
  const initAuditlogState = useCallback(
    (result, state) => {
      const { detail: detail2, endDate: endDate2, startDate: startDate2, type: type2, user: user2 } = state;
      const resultList = result ? Object.values(result.events) : [];
      if (resultList.length && startDate2 === today) {
        const newStartDate = new Date(resultList[resultList.length - 1].time);
        const { start } = getISOStringBoundaries(newStartDate);
        state.startDate = start;
      }
      dispatch(setAuditlogsState(state));
      clearTimeout(timers.current.dirtyField);
      timers.current.dirtyField = setTimeout(() => {
        let field = Object.entries({ detail: detail2, type: type2, user: user2 }).reduce((accu, [key, value]) => accu || value ? key : accu, "");
        field = field || (endDate2 !== tonight ? "endDate" : field);
        field = field || (state.startDate !== today ? "startDate" : field);
        setDirtyField(field);
      }, TIMEOUTS.debounceDefault);
      clearTimeout(timers.current.init);
      timers.current.init = setTimeout(() => isInitialized.current = true, TIMEOUTS.oneSecond + TIMEOUTS.debounceDefault);
    },
    [dispatch, today, tonight]
  );
  const updateState = useCallback(
    (nextState) => {
      const state = { ...nextState };
      if (state.id && Boolean(state.open)) {
        state.selectedId = state.id[0];
        const [eventAction, eventTime] = atob(state.selectedId).split("|");
        if (eventTime && !events.some((item) => item.time === eventTime && item.action === eventAction)) {
          const { start, end } = getISOStringBoundaries(new Date(eventTime));
          state.endDate = end;
          state.startDate = start;
        }
        let field = endDate !== tonight ? "endDate" : "";
        field = field || (startDate !== today ? "startDate" : field);
        setDirtyField(field);
      }
      dispatch(setAuditlogsState(state)).then(() => {
        clearTimeout(timers.current.init);
        timers.current.init = setTimeout(() => isInitialized.current = true, TIMEOUTS.oneSecond + TIMEOUTS.debounceDefault);
      });
      return;
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [dispatch, endDate, JSON.stringify(events), startDate, today, tonight]
  );
  useEffect(() => {
    if (!hasAuditlogs || isInitialized.current !== void 0) {
      return;
    }
    isInitialized.current = false;
    const { id, open, detail: detail2, endDate: endDate2, startDate: startDate2, type: type2, user: user2 } = locationParams;
    const state = { ...locationParams };
    if (id && Boolean(open)) {
      updateState(state);
      return;
    }
    dispatch(getAuditLogs({ page: state.page ?? 1, perPage: 50, startDate: startDate2 !== today ? startDate2 : BEGINNING_OF_TIME, endDate: endDate2, user: user2, type: type2, detail: detail2 })).unwrap().then(({ payload: result }) => initAuditlogState(result, state));
  }, [dispatch, hasAuditlogs, JSON.stringify(events), JSON.stringify(locationParams), initAuditlogState, updateState, today, tonight]);
  useEffect(() => {
    const currentTimers = timers.current;
    return () => {
      Object.values(currentTimers).forEach(clearTimeout);
    };
  }, []);
  const createCsvDownload = () => {
    setCsvLoading(true);
    dispatch(getAuditLogsCsvLink()).unwrap().then((address) => {
      createDownload(encodeURI(address), `Mender-AuditLog-${dayjs(startDate).format("YYYY-MM-DD")}-${dayjs(endDate).format("YYYY-MM-DD")}.csv`, token);
      setCsvLoading(false);
    });
  };
  const onChangeSorting = () => {
    const currentSorting = sort.direction === SORTING_OPTIONS.desc ? SORTING_OPTIONS.asc : SORTING_OPTIONS.desc;
    dispatch(setAuditlogsState({ page: 1, sort: { direction: currentSorting } }));
  };
  const onChangePagination = (page, currentPerPage = perPage) => dispatch(setAuditlogsState({ page, perPage: currentPerPage }));
  const onIssueSelection = (selectedIssue) => dispatch(setAuditlogsState({ selectedId: selectedIssue ? btoa(`${selectedIssue.action}|${selectedIssue.time}`) : void 0 }));
  const onFiltersChange = useCallback(
    ({ endDate: endDate2, detail: detail2, startDate: startDate2, user: user2, type: type2 }) => {
      if (!isInitialized.current) {
        return;
      }
      const selectedUser = Object.values(users).find((item) => isUserOptionEqualToValue(item, user2));
      dispatch(setAuditlogsState({ page: 1, detail: detail2, startDate: startDate2, endDate: endDate2, user: selectedUser, type: type2 }));
    },
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [dispatch, JSON.stringify(users)]
  );
  return /* @__PURE__ */ jsxs(
    AuditlogsView_default,
    {
      createCsvDownload,
      hasAuditlogs,
      total,
      csvLoading,
      infoHintComponent: /* @__PURE__ */ jsx(EnterpriseNotification, { id: BENEFITS.auditlog.id }),
      auditLogsFilter: /* @__PURE__ */ jsx(
        AuditLogsFilter_default,
        {
          groups,
          users,
          disabled: !hasAuditlogs,
          onFiltersChange,
          detailsReset,
          selectionState,
          auditLogsTypes,
          dirtyField,
          setDirtyField
        }
      ),
      children: [
        !!total && /* @__PURE__ */ jsx(
          AuditLogsList_default,
          {
            items: events,
            onChangePage: onChangePagination,
            onChangeRowsPerPage: (newPerPage) => onChangePagination(1, newPerPage),
            onChangeSorting,
            selectionState,
            onIssueSelection,
            userCapabilities,
            auditLogColumns: [
              { title: "Performed by", sortable: false, render: UserDescriptor },
              { title: "Action", sortable: false, render: ActionDescriptor },
              { title: "Type", sortable: false, render: TypeDescriptor },
              { title: "Changed", sortable: false, render: ChangeDescriptor },
              { title: "More details", sortable: false, render: ChangeDetailsDescriptor },
              { title: "Time", sortable: true, render: TimeWrapper }
            ]
          }
        ),
        !(isLoading || total) && hasAuditlogs && /* @__PURE__ */ jsxs("div", { className: "dashboard-placeholder", children: [
          /* @__PURE__ */ jsx("p", { children: "No log entries were found." }),
          /* @__PURE__ */ jsx("p", { children: "Try adjusting the filters." }),
          /* @__PURE__ */ jsx("img", { src: history_default, alt: "Past" })
        ] }),
        !hasAuditlogs && /* @__PURE__ */ jsx("div", { className: `dashboard-placeholder flexbox ${classes.upgradeNote}`, children: /* @__PURE__ */ jsx(DefaultUpgradeNotification, { className: "margin-right-small" }) }),
        /* @__PURE__ */ jsx(
          EventDetailsDrawer_default,
          {
            mapChangeToContent: EventDetailsDrawerContentMap_default,
            fallbackComponent: FallbackComponent_default,
            eventItem,
            open: Boolean(eventItem),
            onClose: () => onIssueSelection()
          }
        )
      ]
    }
  );
};
var AuditLogs_default = AuditLogs;

export {
  AuditLogs,
  AuditLogs_default
};
//# sourceMappingURL=chunk-ZNQPD4GE.js.map