import { SentryConfig } from './index.cjs';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@mui/material';
import '@northern.tech/utils/constants';

declare const mockState: {
    searchState: {
        deviceIds: never[];
        searchTerm: string;
        searchTotal: number;
        sort: {};
        isSearching: boolean;
        page?: number;
        perPage?: number;
    };
    snackbar: {};
    uploadsById: {};
    versionInformation: {};
    cancelSource: any;
    commit: string;
    demoArtifactLink: string;
    docsVersion: string;
    features: Record<string, boolean>;
    feedbackProbability: number;
    firstLoginAfterSignup: boolean;
    hostAddress: string | null;
    hostedAnnouncement: string;
    newThreshold: string;
    offlineThreshold: string;
    recaptchaSiteKey: string;
    sentry: SentryConfig;
    stripeAPIKey: string;
    trackerCode: string;
    yesterday?: string;
};

export { mockState };
