import {
  DEVICE_LIST_DEFAULTS,
  SORTING_OPTIONS,
  TENANT_LIST_DEFAULT
} from "./chunk-7C4SQBEE.js";

// src/organizationSlice/index.ts
import { createSlice } from "@reduxjs/toolkit";
var sliceName = "organization";
var initialState = {
  card: {
    last4: "",
    expiration: { month: 1, year: 2020 },
    brand: ""
  },
  intentId: null,
  tenantList: {
    ...TENANT_LIST_DEFAULT,
    total: 0,
    tenants: [],
    selectedTenant: null,
    sort: {
      direction: SORTING_OPTIONS.desc,
      key: "name"
    }
  },
  organization: {
    // id, name, status, tenant_token, plan
  },
  auditlog: {
    events: [],
    selectionState: {
      ...DEVICE_LIST_DEFAULTS,
      detail: void 0,
      endDate: void 0,
      selectedIssue: void 0,
      sort: { direction: SORTING_OPTIONS.desc },
      startDate: void 0,
      total: 0,
      type: void 0,
      user: void 0,
      isLoading: false
    }
  },
  externalDeviceIntegrations: [
    // { <connection_string|x509|...>, id, provider }
  ],
  ssoConfigs: [],
  webhooks: {
    // [id]: { events: [] }
    // for now:
    events: [],
    eventsTotal: 0
  }
};
var organizationSlice = createSlice({
  name: sliceName,
  initialState,
  reducers: {
    receiveAuditLogs: (state, action) => {
      const { events, total } = action.payload;
      state.auditlog.events = events;
      state.auditlog.selectionState.total = total;
    },
    setAuditLogState: (state, action) => {
      state.auditlog.selectionState = {
        ...state.auditlog.selectionState,
        ...action.payload
      };
    },
    receiveCurrentCard: (state, action) => {
      state.card = action.payload;
    },
    receiveSetupIntent: (state, action) => {
      state.intentId = action.payload;
    },
    setOrganization: (state, action) => {
      state.organization = { ...state.organization, ...action.payload };
    },
    setSubscription: (state, action) => {
      state.organization.subscription = { ...state.organization.subscription, ...action.payload };
    },
    setBillingProfile: (state, action) => {
      state.organization.billing_profile = action.payload;
    },
    setTenantListState: (state, action) => {
      state.tenantList = action.payload;
    },
    receiveExternalDeviceIntegrations: (state, action) => {
      state.externalDeviceIntegrations = action.payload;
    },
    receiveSsoConfigs: (state, action) => {
      state.ssoConfigs = action.payload;
    },
    receiveWebhookEvents: (state, action) => {
      const { value, total } = action.payload;
      state.webhooks.events = value;
      state.webhooks.eventsTotal = total;
    }
  }
});
var actions = organizationSlice.actions;
var organizationSlice_default = organizationSlice.reducer;

export {
  sliceName,
  initialState,
  organizationSlice,
  actions,
  organizationSlice_default
};
//# sourceMappingURL=chunk-MZNANSS2.js.map