import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { DeviceDeployments, DeploymentDeployments, DeviceWithImage, Filter as Filter$1, FilterPredicate, Limit } from '@northern.tech/types/MenderTypes';

declare const sliceName = "deployments";
type Filter = {
    key: string;
    operator: FilterPredicate.type;
    scope: string;
    value: any;
};
type DeviceDeployment = DeviceDeployments & {
    deviceId: string;
    release: string;
    route: string;
};
type Deployment = DeploymentDeployments & {
    devices: Record<string, DeviceWithImage>;
    filter?: Filter$1 & {
        filters: Filter[];
        name?: string;
    };
    group?: string;
    totalDeviceCount: number;
};
type DeploymentStatus = {
    deploymentIds: string[];
    total: number;
};
type DeploymentByStatus = {
    finished: DeploymentStatus;
    inprogress: DeploymentStatus;
    pending: DeploymentStatus;
    scheduled: DeploymentStatus;
};
type DeploymentByStatusKey = keyof DeploymentByStatus;
type DeploymentConfig = {
    binaryDelta: {
        compressionLevel: number;
        disableChecksum: boolean;
        disableDecompression: boolean;
        duplicatesWindow: number;
        inputWindow: number;
        instructionBuffer: number;
        sourceWindow: number;
        timeout: number;
    };
    binaryDeltaLimits: {
        duplicatesWindow: Limit;
        inputWindow: Limit;
        instructionBuffer: Limit;
        sourceWindow: Limit;
        timeout: Limit;
    };
};
type SelectionListState = {
    endDate?: string;
    page?: number;
    perPage?: number;
    search?: string;
    selection: string[];
    startDate?: string;
    total?: number;
    type?: string;
};
type SelectionState = {
    finished: SelectionListState;
    general: {
        reportType: string | null;
        showCreationDialog: boolean;
        showReportDialog: boolean;
        state: string;
    };
    inprogress: SelectionListState;
    pending: SelectionListState;
    scheduled: SelectionListState;
    selectedId?: string;
};
type DeploymentsSliceType = {
    byId: Record<string, Deployment>;
    byStatus: DeploymentByStatus;
    config: DeploymentConfig;
    deploymentDeviceLimit: number;
    selectedDeviceIds: string[];
    selectionState: SelectionState;
};
declare const initialState: DeploymentsSliceType;
declare const deploymentsSlice: _reduxjs_toolkit.Slice<DeploymentsSliceType, {
    createdDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
    removedDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<string>) => void;
    receivedDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<Deployment>) => void;
    receivedDeploymentDeviceLog: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deviceId: string;
        id: string;
        log: boolean;
    }>) => void;
    receivedDeploymentDevices: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        devices: Record<string, DeviceWithImage>;
        id: string;
        selectedDeviceIds: string[];
        totalDeviceCount: number;
    }>) => void;
    receivedDeployments: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<Record<string, Deployment>>) => void;
    receivedDeploymentsForStatus: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }>) => void;
    selectDeploymentsForStatus: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }>) => void;
    setDeploymentsState: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<SelectionState>) => void;
    setDeploymentsConfig: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<DeploymentConfig>) => void;
}, "deployments", "deployments", _reduxjs_toolkit.SliceSelectors<DeploymentsSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    createdDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
    removedDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<string>) => void;
    receivedDeployment: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<Deployment>) => void;
    receivedDeploymentDeviceLog: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deviceId: string;
        id: string;
        log: boolean;
    }>) => void;
    receivedDeploymentDevices: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        devices: Record<string, DeviceWithImage>;
        id: string;
        selectedDeviceIds: string[];
        totalDeviceCount: number;
    }>) => void;
    receivedDeployments: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<Record<string, Deployment>>) => void;
    receivedDeploymentsForStatus: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }>) => void;
    selectDeploymentsForStatus: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<{
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    }>) => void;
    setDeploymentsState: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<SelectionState>) => void;
    setDeploymentsConfig: (state: immer.WritableDraft<DeploymentsSliceType>, action: PayloadAction<DeploymentConfig>) => void;
}, "deployments">;
declare const _default: redux.Reducer<DeploymentsSliceType>;

export { type Deployment, type DeploymentByStatus, type DeploymentByStatusKey, type DeploymentConfig, type DeploymentStatus, type DeviceDeployment, type SelectionListState, type SelectionState, actions, _default as default, deploymentsSlice, initialState, sliceName };
