import { FormatReleasesParams } from './locationutils.cjs';

declare const defaultProcessors: {
    auditlogs: {
        format: ({ pageState }: {
            pageState: any;
        }, { today, tonight }: {
            today: any;
            tonight: any;
        }) => string;
        locate: () => undefined;
        parse: (params: any, { today, tonight }: {
            today: any;
            tonight: any;
        }) => {
            detail: any;
            endDate: any;
            startDate: any;
            type: {
                title: string;
                queryParameter: string;
                value: string;
            } | undefined;
            user: any;
        };
    };
    common: {
        format: ({ selectedId, selectedIssues, page, perPage, sort }: {
            selectedId: any;
            selectedIssues: any;
            page: any;
            perPage: any;
            sort: any;
        }, { defaults }: {
            defaults: any;
        }) => string;
        locate: () => undefined;
        parse: (searchParams: any) => {
            pageState: {};
            params: URLSearchParams;
            sort: {} | undefined;
        };
    };
    deployments: {
        format: ({ deploymentObject, pageState }: {
            deploymentObject: any;
            pageState: any;
        }, { defaults, today, tonight }: {
            defaults: any;
            today: any;
            tonight: any;
        }) => string;
        locate: ({ pageState }: {
            pageState: any;
        }) => string;
        parse: (params: any, { pageState, location, tonight }: {
            pageState: any;
            location: any;
            tonight: any;
        }) => {
            deploymentObject: {};
            general: {
                showCreationDialog: boolean;
                showReportDialog: boolean;
                state: any;
            };
        };
    };
    devices: {
        format: ({ pageState, filters, selectedGroup }: {
            pageState: any;
            filters: any;
            selectedGroup: any;
        }) => string;
        locate: ({ pageState }: {
            pageState: any;
        }) => string;
        parse: (searchParams: any, extraProps?: {}) => {
            open: boolean;
            detailsTab: string | null;
            filters: unknown[];
            groupName: string;
        } | {
            open?: undefined;
            detailsTab: string | null;
            filters: unknown[];
            groupName: string;
        };
    };
    releases: {
        format: ({ pageState: { searchTerm, selectedTags, tab, type } }: FormatReleasesParams) => string;
        locate: ({ pageState: { selectedRelease } }: {
            pageState: {
                selectedRelease: any;
            };
        }) => string;
        parse: (queryParams: any, extraProps: any) => {
            searchTerm: any;
            selectedRelease: string;
            tab: any;
            tags: any;
            type: any;
        };
    };
    tenants: {
        format: () => string;
        locate: ({ pageState: { selectedTenant } }: {
            pageState: {
                selectedTenant: any;
            };
        }) => string;
        parse: (queryParams: any, extraProps: any) => {
            name: any;
            selectedTenant: any;
        };
    };
};
declare const useLocationParams: (key: any, extras: any, processors?: {
    auditlogs: {
        format: ({ pageState }: {
            pageState: any;
        }, { today, tonight }: {
            today: any;
            tonight: any;
        }) => string;
        locate: () => undefined;
        parse: (params: any, { today, tonight }: {
            today: any;
            tonight: any;
        }) => {
            detail: any;
            endDate: any;
            startDate: any;
            type: {
                title: string;
                queryParameter: string;
                value: string;
            } | undefined;
            user: any;
        };
    };
    common: {
        format: ({ selectedId, selectedIssues, page, perPage, sort }: {
            selectedId: any;
            selectedIssues: any;
            page: any;
            perPage: any;
            sort: any;
        }, { defaults }: {
            defaults: any;
        }) => string;
        locate: () => undefined;
        parse: (searchParams: any) => {
            pageState: {};
            params: URLSearchParams;
            sort: {} | undefined;
        };
    };
    deployments: {
        format: ({ deploymentObject, pageState }: {
            deploymentObject: any;
            pageState: any;
        }, { defaults, today, tonight }: {
            defaults: any;
            today: any;
            tonight: any;
        }) => string;
        locate: ({ pageState }: {
            pageState: any;
        }) => string;
        parse: (params: any, { pageState, location, tonight }: {
            pageState: any;
            location: any;
            tonight: any;
        }) => {
            deploymentObject: {};
            general: {
                showCreationDialog: boolean;
                showReportDialog: boolean;
                state: any;
            };
        };
    };
    devices: {
        format: ({ pageState, filters, selectedGroup }: {
            pageState: any;
            filters: any;
            selectedGroup: any;
        }) => string;
        locate: ({ pageState }: {
            pageState: any;
        }) => string;
        parse: (searchParams: any, extraProps?: {}) => {
            open: boolean;
            detailsTab: string | null;
            filters: unknown[];
            groupName: string;
        } | {
            open?: undefined;
            detailsTab: string | null;
            filters: unknown[];
            groupName: string;
        };
    };
    releases: {
        format: ({ pageState: { searchTerm, selectedTags, tab, type } }: FormatReleasesParams) => string;
        locate: ({ pageState: { selectedRelease } }: {
            pageState: {
                selectedRelease: any;
            };
        }) => string;
        parse: (queryParams: any, extraProps: any) => {
            searchTerm: any;
            selectedRelease: string;
            tab: any;
            tags: any;
            type: any;
        };
    };
    tenants: {
        format: () => string;
        locate: ({ pageState: { selectedTenant } }: {
            pageState: {
                selectedTenant: any;
            };
        }) => string;
        parse: (queryParams: any, extraProps: any) => {
            name: any;
            selectedTenant: any;
        };
    };
}) => any[];

export { defaultProcessors, useLocationParams };
