"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/monitorSlice/index.ts
var monitorSlice_exports = {};
__export(monitorSlice_exports, {
  actions: () => actions,
  default: () => monitorSlice_default,
  initialState: () => initialState,
  monitorSlice: () => monitorSlice,
  sliceName: () => sliceName
});
module.exports = __toCommonJS(monitorSlice_exports);
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/monitorSlice/index.ts
var sliceName = "monitor";
var initialState = {
  alerts: {
    alertList: { ...import_constants.DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {}
  },
  issueCounts: {
    byType: Object.keys(import_constants.DEVICE_ISSUE_OPTIONS).reduce((accu, key) => ({ ...accu, [key]: { filtered: 0, total: 0 } }), {})
  },
  settings: {
    global: {
      channels: {
        ...Object.keys(import_constants.alertChannels).reduce((accu, item) => ({ ...accu, [item]: { enabled: true } }), {})
      }
    }
  }
};
var monitorSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    changeAlertChannel: (state, action) => {
      const { channel, enabled } = action.payload;
      state.settings.global.channels[channel] = { enabled };
    },
    receiveDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { alerts };
    },
    receiveLatestDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { ...state.alerts.byDeviceId[deviceId], latest: alerts };
    },
    receiveDeviceIssueCounts: (state, action) => {
      const { issueType, counts } = action.payload;
      state.issueCounts.byType[issueType] = counts;
    },
    setAlertListState: (state, action) => {
      state.alerts.alertList = { ...state.alerts.alertList, ...action.payload };
    }
  }
});
var actions = monitorSlice.actions;
var monitorSlice_default = monitorSlice.reducer;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  actions,
  initialState,
  monitorSlice,
  sliceName
});
//# sourceMappingURL=index.cjs.map