import { Actor } from './Actor.js';
import { AuditLogObject } from './AuditLogObject.js';
import './Artifact.js';
import './ArtifactInfo.js';
import './Update.js';
import './ArtifactTypeInfo.js';
import './UpdateFile.js';
import './Deployment.js';
import './DeploymentPhase.js';
import './DeploymentStatistics.js';
import './DeploymentStatusStatistics.js';
import './Filter.js';
import './FilterPredicate.js';
import './Device.js';
import './DeviceStatus.js';
import './Tenant.js';
import './TenantV1.js';
import './Addon.js';
import './Plan.js';
import './Features.js';
import './TenantAdditionalInfo.js';
import './TenantApiLimits.js';
import './ApiLimits.js';
import './ApiBurst.js';
import './ApiQuota.js';
import './User.js';

/**
 * Audit log entry
 */
type AuditLog = {
    actor: Actor;
    time: string;
    action: AuditLog.action;
    object: AuditLogObject;
    change?: string;
};
declare namespace AuditLog {
    enum action {
        CREATE = "create",
        UPDATE = "update",
        DELETE = "delete",
        ABORT = "abort",
        REJECT = "reject",
        DECOMMISSION = "decommission",
        OPEN_TERMINAL = "open_terminal",
        CLOSE_TERMINAL = "close_terminal",
        OPEN_PORTFORWARD = "open_portforward",
        CLOSE_PORTFORWARD = "close_portforward",
        DOWNLOAD_FILE = "download_file",
        UPLOAD_FILE = "upload_file",
        SET_CONFIGURATION = "set_configuration",
        DEPLOY_CONFIGURATION = "deploy_configuration",
        UPLOAD = "upload"
    }
}

export { AuditLog };
