import { SubscriptionRequest } from './SubscriptionRequest.cjs';
import './Plan.cjs';
import './Features.cjs';
import './Product.cjs';
import './Addon.cjs';

type Subscription = SubscriptionRequest & {
    /**
     * The unique subscription ID.
     */
    id?: string;
    /**
     * The subscription status.
     */
    status?: Subscription.status;
};
declare namespace Subscription {
    /**
     * The subscription status.
     */
    enum status {
        ACTIVE = "active",
        CANCELED = "canceled",
        INCOMPLETE = "incomplete",
        PAST_DUE = "past_due",
        UNPAID = "unpaid"
    }
}

export { Subscription };
