import { TenantV1 } from './TenantV1.cjs';
import './Addon.cjs';
import './Plan.cjs';
import './Features.cjs';
import './TenantAdditionalInfo.cjs';
import './TenantApiLimits.cjs';
import './ApiLimits.cjs';
import './ApiBurst.cjs';
import './ApiQuota.cjs';

/**
 * Tenant descriptor.
 */
type Tenant = TenantV1 & {
    /**
     * Count of accepted devices for the tenant.
     */
    device_count?: number;
    /**
     * Device limit for the tenant.
     */
    device_limit?: number;
    /**
     * Server side binary delta generation for the tenant is enabled.
     */
    binary_delta?: boolean;
};

export type { Tenant };
