import { TenantV1 } from './TenantV1.js';
import './Addon.js';
import './Plan.js';
import './Features.js';
import './TenantAdditionalInfo.js';
import './TenantApiLimits.js';
import './ApiLimits.js';
import './ApiBurst.js';
import './ApiQuota.js';

/**
 * Tenant descriptor.
 */
type Tenant = TenantV1 & {
    /**
     * Count of accepted devices for the tenant.
     */
    device_count?: number;
    /**
     * Device limit for the tenant.
     */
    device_limit?: number;
    /**
     * Server side binary delta generation for the tenant is enabled.
     */
    binary_delta?: boolean;
};

export type { Tenant };
