export { apiRoot, apiUrl, auditLogsApiUrl, deploymentsApiUrl, deploymentsApiUrlV1, deploymentsApiUrlV2, deviceAuthV2, deviceConfig, deviceConnect, headerNames, inventoryApiUrl, inventoryApiUrlV1, inventoryApiUrlV2, iotManagerBaseURL, maxSessionAge, monitorApiUrlv1, reportingApiUrl, ssoIdpApiUrlv1, tenantadmApiUrlv1, tenantadmApiUrlv2, useradmApiUrl, useradmApiUrlv1, useradmApiUrlv2 } from './api.cjs';
export { APPLICATION_JSON_CONTENT_TYPE, APPLICATION_JWT_CONTENT_TYPE } from './app.cjs';
export { ALL_DEVICES, ALL_DEVICE_STATES, ATTRIBUTE_SCOPES, DEVICE_FILTERING_OPTIONS, DEVICE_ISSUE_OPTIONS, DEVICE_STATES, DeviceIssueOption, DeviceIssueOptionKey, FilterRule } from './devices.cjs';
export { AnyPermission, AuditLogPermission, ConfigurePermission, ConnectPermission, DeployPermission, DeploymentPermission, GroupsPermission, ManagePermission, PermissionObject, PermissionSet, PermissionSetId, PermissionTypes, ReadPermission, ReleasesPermission, Role, ScopedPermissionsByAreaKey, UiPermissionsByAreaKey, UiPermissionsByIdKey, UiPermissionsDefinition, UiRoleDefinition, UploadPermission, UserManagementPermission, defaultPermissionSets, emptyRole, emptyUiPermissions, rolesById, rolesByName, scopedPermissionAreas, serviceProviderRolesById, uiPermissionsByArea, uiPermissionsById } from './users.cjs';
import '@northern.tech/types/MenderTypes';

declare const alertChannels: {
    email: string;
};
declare const limitDefault: {
    min: number;
    max: number;
    default: number;
};
declare const ALL_RELEASES = "All releases";
declare const SORTING_OPTIONS: {
    readonly asc: "asc";
    readonly desc: "desc";
};
interface SortOptions {
    direction: keyof typeof SORTING_OPTIONS;
    key?: string;
}
declare const DEVICE_LIST_DEFAULTS: {
    page: number;
    perPage: number;
};
declare const twoFAStates: {
    readonly enabled: "enabled";
    readonly disabled: "disabled";
    readonly unverified: "unverified";
};

export { ALL_RELEASES, DEVICE_LIST_DEFAULTS, SORTING_OPTIONS, type SortOptions, alertChannels, limitDefault, twoFAStates };
