<?php

/**
 * Class hub_management
 */
class Hub_management extends Cf_Controller
{

    public function __construct()
    {
        parent::__construct();
        setCurrentApplication('hub_management');
        $this->load->helper('url');
    }

    function index()
    {
        if (str_ends_with(uri_string(),'hub_management')){
            redirect('hub-management', 'refresh');
        }
        $requiredcss = array(
            array('angularjs-ui/angular-ui.css')
        );

        $this->carabiner->css($requiredcss);

        $requiredAngularjs = array(
            array('node_modules/underscore/underscore-min.js'),
            array('node_modules/angular/angular.min.js'),
            array('node_modules/angular-cookies/angular-cookies.min.js'),
            array('node_modules/angular-route/angular-route.min.js'),
            array('node_modules/angular-sanitize/angular-sanitize.min.js'),

            // services
            array('libs/angularjs-ui/ui-bootstrap-tpls-0.9.0.min.js'),
            array('libs/class.js'),
        );

        $requiredjs = array(// project
            array('libs/baseclasses/BaseController.js'),
            array('libs/baseclasses/EventDispatcher.js'),
            array('libs/baseclasses/Notifications.js'),

            array('hubManagement/app.js'),
            array('hubManagement/controllers/hubManagementController.js'),
            array('hubManagement/services/hubManagementService.js'),
            array('hubManagement/directives/sshKeyLoader.js'),

            // action service to trigger an agent run after enabling the Policy analyzer
            array('common_directives/actions/actionService.js'),
            array('common_directives/actions/actionHelper.js'),
        );

        $this->carabiner->js($requiredAngularjs, $requiredAngularjs, $combine = true, $minify = false);
        $this->carabiner->js($requiredjs, $requiredjs, $combine = true, $minify = true);

        $data = array('title' => 'Mission Portal - Hub management');

        $this->template->load('template', 'hub_management/index', $data);
    }

}
