import "./chunk-424PT5DM.js";

// src/InputErrorNotification.tsx
import { useEffect, useRef, useState } from "react";
import { TIMEOUTS } from "@northern.tech/store/constants";
import { jsx } from "react/jsx-runtime";
var InputErrorNotification = ({ className, content }) => {
  const [isVisible, setIsVisible] = useState(false);
  const timer = useRef();
  useEffect(() => {
    if (!content) {
      return;
    }
    setIsVisible(true);
    timer.current = setTimeout(() => setIsVisible(false), TIMEOUTS.fiveSeconds);
    return () => clearTimeout(timer.current);
  }, [content]);
  return /* @__PURE__ */ jsx("p", { className: `warning ${isVisible ? "fadeInSlow" : "fadeOut"} ${className}`, children: content });
};
export {
  InputErrorNotification
};
//# sourceMappingURL=InputErrorNotification.js.map